/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.handlers;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointWizard;
import com.kms.katalon.composer.checkpoint.dialogs.wizard.NewCheckpointWizardDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.CheckpointTreeEntity;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.SelectionServiceSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.CheckpointController;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;

public class NewCheckpointHandler {
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    protected Shell parentShell;
    private FolderEntity parentFolder;
    private static NewCheckpointHandler instance;

    public static NewCheckpointHandler getInstance() {
        if (instance == null) {
            instance = new NewCheckpointHandler();
        }
        return instance;
    }

    @CanExecute
    public boolean canExecute() {
        return NewCheckpointHandler.getProject() != null;
    }

    @Execute
    public void execute() {
        try {
            if (!this.featureService.canUse(KSEFeature.CHECKPOINT)) {
                KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CHECKPOINT);
                return;
            }
            ITreeEntity parent = this.findParentSelection();
            if (parent == null) {
                parent = new FolderTreeEntity(FolderController.getInstance().getCheckpointRoot(NewCheckpointHandler.getProject()), null);
            }
            this.parentFolder = (FolderEntity)parent.getObject();
            CheckpointEntity checkpoint = this.getCheckpointFromDialog(this.parentFolder);
            if (checkpoint == null) {
                return;
            }
            checkpoint = CheckpointController.getInstance().create(checkpoint);
            if (checkpoint == null) {
                MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR, (String)StringConstants.HAND_MSG_UNABLE_TO_CREATE_CHECKPOINT);
                return;
            }
            try {
                CheckpointController.getInstance().takeSnapshot(checkpoint);
            }
            catch (Exception exception) {}
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)parent);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new CheckpointTreeEntity(checkpoint, parent));
            this.eventBroker.post("CHECKPOINT/OPEN", (Object)checkpoint);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)this.parentShell, (String)StringConstants.ERROR, (String)e.getMessage());
        }
    }

    protected CheckpointEntity getCheckpointFromDialog(FolderEntity parentFolder) throws Exception {
        NewCheckpointWizard newCheckpointWizard = new NewCheckpointWizard(this.getSuggestedName(StringConstants.CHECKPOINT), parentFolder);
        NewCheckpointWizardDialog dialog = new NewCheckpointWizardDialog(this.parentShell, (IWizard)newCheckpointWizard);
        if (dialog.open() != 0) {
            return null;
        }
        return newCheckpointWizard.getCheckpoint();
    }

    protected static ProjectEntity getProject() {
        return ProjectController.getInstance().getCurrentProject();
    }

    protected String getSuggestedName(String suggestedName) throws Exception {
        suggestedName = StringUtils.defaultIfBlank((String)suggestedName, (String)StringConstants.CHECKPOINT);
        return CheckpointController.getInstance().getAvailableName(this.parentFolder, suggestedName);
    }

    public ITreeEntity findParentSelection() throws Exception {
        ITreeEntity selectedTreeEntity = this.getFirstSelection();
        if (selectedTreeEntity == null) {
            return null;
        }
        Object entityObject = selectedTreeEntity.getObject();
        if (entityObject instanceof FolderEntity && ((FolderEntity)entityObject).getFolderType() == FolderEntity.FolderType.CHECKPOINT) {
            return selectedTreeEntity;
        }
        if (entityObject instanceof CheckpointEntity) {
            return selectedTreeEntity.getParent();
        }
        return null;
    }

    public ITreeEntity getFirstSelection() {
        Object o = SelectionServiceSingleton.getInstance().getSelectionService().getSelection("com.kms.katalon.composer.part.explorer");
        if (o == null || !o.getClass().isArray()) {
            return null;
        }
        Object[] selectedObjects = (Object[])o;
        if (selectedObjects.length != 1) {
            return null;
        }
        Object selectedObject = selectedObjects[0];
        if (!(selectedObject instanceof ITreeEntity)) {
            return null;
        }
        return (ITreeEntity)selectedObject;
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="CHECKPOINT/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute();
    }
}

