/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.checkpoint.parts;

import com.kms.katalon.composer.checkpoint.constants.StringConstants;
import com.kms.katalon.composer.checkpoint.dialogs.EditCheckpointDatabaseDialog;
import com.kms.katalon.composer.checkpoint.parts.CheckpointAbstractPart;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.entity.checkpoint.CheckpointEntity;
import com.kms.katalon.entity.checkpoint.CheckpointSourceInfo;
import com.kms.katalon.entity.checkpoint.DatabaseCheckpointSourceInfo;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CheckpointDatabasePart
extends CheckpointAbstractPart {
    private Text txtQuery;
    private Button btnEdit;

    @Override
    protected Composite createSourceInfoPartDetails(Composite parent) {
        this.compSourceInfoDetails = new Composite(parent, 0);
        GridLayout glCompositeSrcInfoDetails = new GridLayout(4, false);
        glCompositeSrcInfoDetails.marginWidth = 0;
        glCompositeSrcInfoDetails.marginHeight = 0;
        this.compSourceInfoDetails.setLayout((Layout)glCompositeSrcInfoDetails);
        this.compSourceInfoDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblQuery = new Label(this.compSourceInfoDetails, 0);
        lblQuery.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblQuery.setText(StringConstants.PART_LBL_SQL_QUERY);
        this.txtQuery = new Text(this.compSourceInfoDetails, 2056);
        this.txtQuery.setLayoutData((Object)new GridData(4, 4, true, false));
        this.btnEdit = new Button(this.compSourceInfoDetails, 0x800008);
        this.btnEdit.setText(StringConstants.EDIT);
        this.btnEdit.setLayoutData((Object)new GridData(131072, 4, false, true));
        return parent;
    }

    @Override
    protected void addSourceInfoConstrolListeners() {
        this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckpointDatabasePart.this.executeOperation((IUndoableOperation)new ChangeDatabaseSourceInfoOperation());
            }
        });
    }

    @Override
    protected void loadCheckpointSourceInfo(CheckpointSourceInfo sourceInfo) {
        this.txtQuery.setText(((DatabaseCheckpointSourceInfo)sourceInfo).getQuery());
    }

    @Override
    protected String getDocumentationUrl() {
        return DocumentationMessageConstants.CHECKPOINT_DATABASE;
    }

    private class ChangeDatabaseSourceInfoOperation
    extends CheckpointAbstractPart.ChangeCheckpointSourceInfoOperation {
        public ChangeDatabaseSourceInfoOperation() {
            super(ChangeDatabaseSourceInfoOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CheckpointEntity currentCheckpoint = CheckpointDatabasePart.this.getCheckpoint();
            this.oldCheckpointSourceInfo = currentCheckpoint.getSourceInfo().clone();
            EditCheckpointDatabaseDialog dialog = new EditCheckpointDatabaseDialog(Display.getCurrent().getActiveShell(), (DatabaseCheckpointSourceInfo)currentCheckpoint.getSourceInfo());
            if (dialog.open() != 0 || !dialog.isChanged()) {
                return Status.CANCEL_STATUS;
            }
            DatabaseCheckpointSourceInfo sourceInfo = dialog.getSourceInfo();
            this.newCheckpointSourceInfo = sourceInfo.clone();
            currentCheckpoint.setSourceInfo((CheckpointSourceInfo)sourceInfo);
            CheckpointDatabasePart.this.loadCheckpointSourceInfo((CheckpointSourceInfo)sourceInfo);
            CheckpointDatabasePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }
}

