/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.cfr.decompiler;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.benf.cfr.reader.api.ClassFileSource;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.Pair;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.CannotLoadClassException;
import org.benf.cfr.reader.util.getopt.GetOptParser;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.benf.cfr.reader.util.output.IllegalIdentifierDump;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.cfr.decompiler.StringDumper;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UnicodeUtil;

public class CfrDecompiler
implements IDecompiler {
    private String source = "";
    private long time;
    private long start;
    private String log = "";

    public void decompile(String root, String packege, String className) {
        this.start = System.currentTimeMillis();
        this.log = "";
        this.source = "";
        File workingDir = new File(String.valueOf(root) + "/" + packege);
        String classPathStr = new File(workingDir, className).getAbsolutePath();
        GetOptParser getOptParser = new GetOptParser();
        try {
            Pair<List<String>, Options> options = getOptParser.parse(new String[]{classPathStr}, OptionsImpl.getFactory());
            Options namedOptions = options.getSecond();
            ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(namedOptions);
            DCCommonState dcCommonState = new DCCommonState(namedOptions, (ClassFileSource)classFileSource);
            IllegalIdentifierDump illegalIdentifierDump = IllegalIdentifierDump.Factory.get(namedOptions);
            ClassFile c = dcCommonState.getClassFileMaybePath(classPathStr);
            dcCommonState.configureWith(c);
            try {
                c = dcCommonState.getClassFile(c.getClassType());
            }
            catch (CannotLoadClassException cannotLoadClassException) {
                // empty catch block
            }
            if (((Boolean)namedOptions.getOption(OptionsImpl.DECOMPILE_INNER_CLASSES)).booleanValue()) {
                c.loadInnerClasses(dcCommonState);
            }
            c.analyseTop(dcCommonState);
            TypeUsageCollector collectingDumper = new TypeUsageCollector(c);
            c.collectTypeUsages(collectingDumper);
            StringDumper dumper = new StringDumper(collectingDumper.getTypeUsageInformation(), namedOptions, illegalIdentifierDump);
            c.dump(dumper);
            this.source = UnicodeUtil.decode((String)dumper.toString().trim());
            Pattern wp = Pattern.compile("/\\*.+?\\*/", 32);
            Matcher m = wp.matcher(this.source);
            while (m.find()) {
                if (m.group().matches("/\\*\\s+\\d*\\s+\\*/")) continue;
                String group = m.group();
                group = group.replace("/*", "");
                group = group.replace("*/", "");
                group = group.replace("*", "");
                if (this.log.length() > 0) {
                    this.log = String.valueOf(this.log) + "\n";
                }
                this.log = String.valueOf(this.log) + group;
                this.source = this.source.replace(m.group(), "").trim();
            }
            dumper.close();
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
        }
        this.time = System.currentTimeMillis() - this.start;
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), "", className);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public List getExceptions() {
        return Collections.EMPTY_LIST;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "CFR";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return false;
    }

    public boolean supportDebug() {
        return false;
    }
}

