/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.eclipse.codebrowsing.elements.IGroovyResolvedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.debug.ui.JavaDebugHover;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class GroovyExtraInformationHover
extends JavadocHover {
    private final JavaDebugHover debugHover = new JavaDebugHover();
    private final boolean alwaysReturnInformation;

    public GroovyExtraInformationHover() {
        this(false);
    }

    public GroovyExtraInformationHover(boolean alwaysReturnInformation) {
        this.alwaysReturnInformation = alwaysReturnInformation;
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        this.debugHover.setEditor(editor);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        Object o;
        IEditorPart editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        IFile file = (IFile)Adapters.adapt((Object)editor.getEditorInput(), IFile.class);
        if (file == null) {
            return null;
        }
        if (!ContentTypeUtils.isGroovyLikeFileName((CharSequence)file.getName())) {
            return null;
        }
        if (!this.alwaysReturnInformation && (o = this.debugHover.getHoverInfo2(textViewer, hoverRegion)) != null) {
            return null;
        }
        IJavaElement[] elements = this.getJavaElementsAt(textViewer, hoverRegion);
        if (this.shouldComputeHover(elements)) {
            return this.computeHover(hoverRegion, elements);
        }
        return null;
    }

    private boolean shouldComputeHover(IJavaElement[] elements) {
        return elements != null && elements.length == 1 && (this.alwaysReturnInformation || elements[0] instanceof IGroovyResolvedElement && GroovyExtraInformationHover.isNotBlank(((IGroovyResolvedElement)elements[0]).getExtraDoc()));
    }

    private static boolean isNotBlank(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private Object computeHover(IRegion hoverRegion, IJavaElement[] elements) {
        Class[] types = new Class[]{IJavaElement[].class, ITypeRoot.class, IRegion.class, JavadocBrowserInformationControlInput.class};
        Object[] objectArray = new Object[4];
        objectArray[0] = elements;
        objectArray[1] = this.getEditorInputJavaElement();
        objectArray[2] = hoverRegion;
        Object[] values = objectArray;
        JavadocBrowserInformationControlInput hover = (JavadocBrowserInformationControlInput)ReflectionUtils.executePrivateMethod(JavadocHover.class, (String)"getHoverInfo", (Class[])types, null, (Object[])values);
        if (hover != null && elements[0] instanceof IGroovyResolvedElement) {
            hover = new JavadocBrowserInformationControlInput((JavadocBrowserInformationControlInput)hover.getPrevious(), hover.getElement(), this.wrapHTML(hover, (IGroovyResolvedElement)elements[0]), hover.getLeadingImageWidth());
        }
        return hover;
    }

    protected String wrapHTML(JavadocBrowserInformationControlInput input, IGroovyResolvedElement elt) {
        String preamble = !elt.getElementName().equals(elt.getInferredElementName()) ? this.createLabel(elt.getInferredElement()) : "";
        if (elt.getExtraDoc() != null) {
            return String.valueOf(preamble) + this.extraDocAsHtml(elt) + "\n<br/><hr/><br/>\n" + input.getHtml();
        }
        return String.valueOf(preamble) + input.getHtml();
    }

    protected String extraDocAsHtml(IGroovyResolvedElement elem) {
        String html;
        String extraDoc = elem.getExtraDoc();
        if (!extraDoc.startsWith("/**")) {
            extraDoc = "/**" + extraDoc;
        }
        if (!extraDoc.endsWith("*/")) {
            extraDoc = String.valueOf(extraDoc) + "*/";
        }
        try {
            html = (String)ReflectionUtils.throwableExecutePrivateMethod(JavadocContentAccess2.class, (String)"javadoc2HTML", (Class[])new Class[]{IMember.class, IJavaElement.class, String.class}, null, (Object[])new Object[]{elem, elem, extraDoc});
        }
        catch (NoSuchMethodException e) {
            html = (String)ReflectionUtils.executePrivateMethod(JavadocContentAccess2.class, (String)"javadoc2HTML", (Class[])new Class[]{IMember.class, String.class}, null, (Object[])new Object[]{elem, extraDoc});
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return html;
    }

    private String createLabel(ASTNode inferredElement) {
        if (inferredElement instanceof PropertyNode) {
            inferredElement = ((PropertyNode)inferredElement).getField();
        }
        String label = inferredElement instanceof ClassNode ? this.createTypeLabel((ClassNode)inferredElement) : (inferredElement instanceof MethodNode ? this.createMethodLabel((MethodNode)inferredElement) : (inferredElement instanceof FieldNode ? this.createFieldLabel((FieldNode)inferredElement) : inferredElement.getText()));
        return "<b>" + label + "</b><br>\n";
    }

    private String createTypeLabel(ClassNode node) {
        return Signature.toString((String)GroovyUtils.getTypeSignature((ClassNode)node, (boolean)false, (boolean)false));
    }

    private String createFieldLabel(FieldNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createTypeLabel(node.getType()));
        sb.append(' ');
        sb.append(this.createTypeLabel(node.getDeclaringClass()));
        sb.append('.');
        sb.append(node.getName());
        return sb.toString();
    }

    private String createMethodLabel(MethodNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.createTypeLabel(node.getReturnType()));
        sb.append(' ');
        sb.append(this.createTypeLabel(node.getDeclaringClass()));
        sb.append('.');
        sb.append("<init>".equals(node.getName()) ? this.createTypeLabel(node.getDeclaringClass()) : node.getName());
        sb.append('(');
        Parameter[] params = node.getParameters();
        if (params != null) {
            int i = 0;
            int n = params.length;
            while (i < n) {
                List annotations;
                if (i > 0) {
                    sb.append(", ");
                }
                if (!(annotations = params[i].getAnnotations()).isEmpty()) {
                    sb.append("<span style='font-weight:normal;'>");
                    for (AnnotationNode annotation : annotations) {
                        sb.append('@').append(this.createTypeLabel(annotation.getClassNode()));
                        Map attributes = annotation.getMembers();
                        if (!attributes.isEmpty()) {
                            sb.append('(');
                            int j = 0;
                            for (Map.Entry e : attributes.entrySet()) {
                                if (j++ > 0) {
                                    sb.append(", ");
                                }
                                sb.append((String)e.getKey());
                                sb.append('=');
                                sb.append(this.createValueLabel((Expression)e.getValue()));
                            }
                            sb.append(')');
                        }
                        sb.append(' ');
                    }
                    sb.append("</span>");
                }
                sb.append(this.createTypeLabel(params[i].getType()));
                sb.append(' ').append(params[i].getName());
                ++i;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    private String createValueLabel(Expression value) {
        if (value instanceof ListExpression) {
            StringJoiner sj = new StringJoiner(", ", "[", "]");
            for (Expression e : ((ListExpression)value).getExpressions()) {
                sj.add(this.createValueLabel(e));
            }
            return sj.toString();
        }
        if (value instanceof ClassExpression) {
            return String.valueOf(this.createTypeLabel(value.getType())) + ".class";
        }
        if (value instanceof ConstantExpression) {
            if (value.getType().equals((Object)ClassHelper.STRING_TYPE)) {
                return "\"" + value.getText() + "\"";
            }
            if (value.getType().equals((Object)ClassHelper.char_TYPE)) {
                return "'" + value.getText() + "'";
            }
        }
        return value.getText();
    }
}

