/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.actions;

import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.internal.ui.javaeditor.selectionactions.SelectionHistory;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;

public class ExpandSelectionAction
extends SelectionDispatchAction {
    private GroovyEditor editor;
    private SelectionHistory history;

    public ExpandSelectionAction(GroovyEditor editor, SelectionHistory history) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.editor = editor;
        this.history = history;
        this.setText("Enclosing Element");
    }

    public void run(ITextSelection currentSelection) {
        FindSurroundingNode finder;
        IASTFragment result;
        ModuleNode node;
        GroovyCompilationUnit unit;
        if (currentSelection != null && this.editor != null && (unit = this.editor.getGroovyCompilationUnit()) != null && (node = unit.getModuleNode()) != null && (result = (finder = new FindSurroundingNode(new Region(currentSelection.getOffset(), currentSelection.getLength()))).doVisitSurroundingNode(node)) != null) {
            TextSelection newSelection = new TextSelection(result.getStart(), result.getLength());
            if (!newSelection.equals((Object)currentSelection)) {
                this.history.remember((ISourceRange)new SourceRange(currentSelection.getOffset(), currentSelection.getLength()));
                try {
                    this.history.ignoreSelectionChanges();
                    this.editor.selectAndReveal(result.getStart(), result.getLength());
                }
                finally {
                    this.history.listenToSelectionChanges();
                }
            }
            this.editor.getSelectionProvider().setSelection((ISelection)newSelection);
        }
    }
}

