/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import org.codehaus.groovy.eclipse.refactoring.actions.AbstractGroovyCleanUp;
import org.codehaus.groovy.eclipse.refactoring.formatter.WhitespaceRemover;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.fix.TextEditFix;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.TextEdit;

public class TrailingWhitespacesCleanUp
extends AbstractGroovyCleanUp {
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        if (!(unit instanceof GroovyCompilationUnit)) {
            return null;
        }
        GroovyCompilationUnit gunit = (GroovyCompilationUnit)unit;
        char[] contents = gunit.getContents();
        TextSelection selection = new TextSelection(0, contents.length);
        Document document = new Document(new String(contents));
        WhitespaceRemover formatter = new WhitespaceRemover((ITextSelection)selection, (IDocument)document);
        TextEdit edit = formatter.format();
        return new TextEditFix(edit, (ICompilationUnit)gunit, "Remove trailing whitespaces.");
    }

    public String[] getStepDescriptions() {
        return new String[]{"Remove trailing whitespaces."};
    }
}

