/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.decorators;

import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.ContentTypeUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GroovyImageProvider
extends JavaElementImageProvider {
    private IWindowListener listener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            window.getActivePage().addPartListener(new IPartListener2(){

                public void partOpened(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    if (part instanceof PackageExplorerPart) {
                        GroovyImageProvider.this.enhance((PackageExplorerPart)part);
                    }
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    IWorkbenchPart part = partRef.getPart(false);
                    boolean cfr_ignored_0 = part instanceof PackageExplorerPart;
                }

                public void partActivated(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }
            });
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }
    };

    public GroovyImageProvider() {
        PlatformUI.getWorkbench().addWindowListener(this.listener);
        this.listener.windowOpened(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        PackageExplorerPart packageExplorer = PackageExplorerPart.getFromActivePerspective();
        if (packageExplorer != null) {
            this.enhance(packageExplorer);
        }
    }

    public void disconnect() {
        PlatformUI.getWorkbench().removeWindowListener(this.listener);
    }

    protected void enhance(PackageExplorerPart packageExplorer) {
        JavaElementImageProvider fImageLabelProvider;
        PackageExplorerLabelProvider fLabelProvider = (PackageExplorerLabelProvider)ReflectionUtils.getPrivateField(PackageExplorerPart.class, (String)"fLabelProvider", (Object)packageExplorer);
        if (fLabelProvider != null && (fImageLabelProvider = (JavaElementImageProvider)ReflectionUtils.getPrivateField(JavaUILabelProvider.class, (String)"fImageLabelProvider", (Object)fLabelProvider)) != null && fImageLabelProvider != this) {
            fImageLabelProvider.dispose();
            ReflectionUtils.setPrivateField(JavaUILabelProvider.class, (String)"fImageLabelProvider", (Object)fLabelProvider, (Object)((Object)this));
        }
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        if (ContentTypeUtils.isGroovyLikeFileName((CharSequence)file.getName())) {
            return GroovyPluginImages.DESC_GROOVY_FILE;
        }
        return super.getCUResourceImageDescriptor(file, flags);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement element, int flags) {
        if (element instanceof GroovyCompilationUnit) {
            return GroovyPluginImages.DESC_GROOVY_FILE;
        }
        return super.getJavaImageDescriptor(element, flags);
    }
}

