/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.webui.util.ConsoleCommandExecutor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.math.NumberUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxExecutable {
    private static final String VERSION_SEPARATOR_REGEX = "\\.";
    private static final String MOZILLA_FIREFOX_VERSION_STRING_PREFIX = "Mozilla Firefox";
    private static final File SYSTEM_BINARY = FirefoxExecutable.locateFirefoxBinaryFromSystemProperty();
    private static final File PLATFORM_BINARY = FirefoxExecutable.locateFirefoxBinaryFromPlatform();
    public static final String MAC_FIREFOX_BINARY_FILE_LOCATION = "/Applications/Firefox.app/Contents/MacOS/firefox";

    private FirefoxExecutable() {
    }

    public static int getFirefoxVersion(DesiredCapabilities desiredCapabilities) {
        String firefoxVersionString;
        block5: {
            File defaultFirefoxBinary;
            block4: {
                defaultFirefoxBinary = FirefoxExecutable.getFirefoxBinaryFile(FirefoxExecutable.getFirefoxBinary(desiredCapabilities));
                if (defaultFirefoxBinary != null) break block4;
                return 0;
            }
            firefoxVersionString = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult(new String[]{defaultFirefoxBinary.getAbsolutePath(), "-v", "|", "more"});
            if (firefoxVersionString != null && firefoxVersionString.startsWith(MOZILLA_FIREFOX_VERSION_STRING_PREFIX)) break block5;
            return 0;
        }
        try {
            firefoxVersionString = firefoxVersionString.substring(MOZILLA_FIREFOX_VERSION_STRING_PREFIX.length()).trim();
            String firefoxVersionMajor = firefoxVersionString.split(VERSION_SEPARATOR_REGEX)[0];
            Number firefoxVersion = NumberUtils.createNumber((String)firefoxVersionMajor);
            return firefoxVersion.intValue();
        }
        catch (IOException | InterruptedException | NumberFormatException exception) {
            return 0;
        }
    }

    private static String getFirefoxBinary(DesiredCapabilities desiredCapabilities) {
        if (desiredCapabilities == null || desiredCapabilities.getCapability("firefox_binary") == null) {
            return null;
        }
        Object raw = desiredCapabilities.getCapability("firefox_binary");
        if (raw instanceof String) {
            return (String)raw;
        }
        return null;
    }

    public static File getFirefoxBinaryFile(String userSpecifiedBinaryPath) {
        if (userSpecifiedBinaryPath != null) {
            File userSpecifiedBinaryFile = new File(userSpecifiedBinaryPath);
            if (userSpecifiedBinaryFile.exists() && userSpecifiedBinaryFile.isFile()) {
                return userSpecifiedBinaryFile;
            }
            throw new WebDriverException("Specified firefox binary location does not exist or is not a real file: " + userSpecifiedBinaryPath);
        }
        if (SYSTEM_BINARY != null && SYSTEM_BINARY.exists()) {
            return SYSTEM_BINARY;
        }
        if (PLATFORM_BINARY != null && PLATFORM_BINARY.exists()) {
            return PLATFORM_BINARY;
        }
        return null;
    }

    private static File locateFirefoxBinaryFromSystemProperty() {
        String binaryName = System.getProperty("webdriver.firefox.bin");
        if (binaryName == null) {
            return null;
        }
        File binary = new File(binaryName);
        if (binary.exists()) {
            return binary;
        }
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            if (!binaryName.endsWith(".exe")) {
                binaryName = String.valueOf(binaryName) + ".exe";
            }
        } else if (current.is(Platform.MAC)) {
            if (!binaryName.endsWith(".app")) {
                binaryName = String.valueOf(binaryName) + ".app";
            }
            binaryName = String.valueOf(binaryName) + "/Contents/MacOS/firefox";
        }
        if ((binary = new File(binaryName)).exists()) {
            return binary;
        }
        throw new WebDriverException(String.format("'%s' property set, but unable to locate the requested binary: %s", "webdriver.firefox.bin", binaryName));
    }

    private static File locateFirefoxBinaryFromPlatform() {
        String systemFirefox;
        File binary = null;
        Platform current = Platform.getCurrent();
        if (current.is(Platform.WINDOWS)) {
            File firefoxBinary64File = new File("C:\\Program Files\\Mozilla Firefox\\firefox.exe");
            if (firefoxBinary64File.exists()) {
                return firefoxBinary64File;
            }
            File firefoxBinary32File = new File("C:\\Program Files\\Mozilla Firefox (x86)\\firefox.exe");
            if (firefoxBinary32File.exists()) {
                return firefoxBinary32File;
            }
        } else if (current.is(Platform.MAC) && !(binary = new File(MAC_FIREFOX_BINARY_FILE_LOCATION)).exists()) {
            binary = new File(String.valueOf(System.getProperty("user.home")) + binary.getAbsolutePath());
        }
        if (binary != null && binary.exists()) {
            return binary;
        }
        ExecutableFinder binaryFinder = new ExecutableFinder();
        if (current.is(Platform.UNIX) && (systemFirefox = binaryFinder.find("firefox-bin")) != null) {
            return new File(systemFirefox);
        }
        systemFirefox = binaryFinder.find("firefox");
        if (systemFirefox != null) {
            return new File(systemFirefox);
        }
        return null;
    }
}

