/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.selenium.firefox.CFirefoxProfile;
import java.io.File;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverPropertyUtil {
    private static final KeywordLogger logger = KeywordLogger.getInstance(WebDriverPropertyUtil.class);
    public static final String DISABLE_EXTENSIONS = "--disable-extensions";
    public static final String CHROME_SWITCHES = "chrome.switches";
    public static final String CHROME_NO_SANDBOX = "--no-sandbox";
    private static final String CHROME_ARGUMENT_PROPERTY_KEY = "args";
    private static final String CHROME_BINARY_PROPERTY_KEY = "binary";
    private static final String CHROME_EXTENSIONS_PROPERTY_KEY = "extensions";
    private static final String CHROME_PREFERENCES_PROPERTY_KEY = "prefs";
    private static final String CHROME_LOCALSTATE_PROPERTY_KEY = "localState";
    private static final String CHROME_DETACH_PROPERTY_KEY = "detach";
    private static final String CHROME_DEBUGGER_ADDRESS_PROPERTY_KEY = "debuggerAddress";
    private static final String CHROME_EXCLUDE_SWITCHES_PROPERTY_KEY = "excludeSwitches";
    private static final String CHROME_MINI_DUMP_PATH_PROPERTY_KEY = "minidumpPath";
    private static final String CHROME_MOBILE_EMULATION_PROPERTY_KEY = "mobileEmulation";
    private static final String CHROME_PREF_LOGGING_PREFS_PROPERTY_KEY = "perfLoggingPrefs";
    private static final String[] CHROME_CAPABILITIES = new String[]{"args", "binary", "extensions", "prefs", "localState", "detach", "debuggerAddress", "excludeSwitches", "minidumpPath", "mobileEmulation", "perfLoggingPrefs"};
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE = "startup.homepage_welcome_url.additional";
    private static final String STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE = "startup.homepage_welcome_url";
    private static final String BROWSER_STARTUP_HOMEPAGE_PREFERENCE = "browser.startup.homepage";
    private static final String FIREFOX_BLANK_PAGE = "about:blank";
    private static final String EDGE_OPTIONS_CAPABILITY = "ms:edgeOptions";
    private static final String EDGE_BINARY_PROPERTY_KEY = "binary";
    public static final String KATALON_DOCKER_ENV_KEY = "KATALON_DOCKER";
    private static final String CHROME_PROPERTY_USER_DATA_DIR = "user-data-dir=";
    private static final String CHROME_PROPERTY_PROFILE_DIR = "profile-directory=";
    private static final String CHROME_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH = "Extensions" + File.separator + "gkihajmjffefinkmpokfepcdbhnpflee";
    private static final String EDGE_CHROMIUM_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH = "Extensions" + File.separator + "kkmafoknllgdaapbegpkpmbncidodkaa";

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, WebUIDriverType webUIDriverType) {
        if (propertyMap == null) {
            return null;
        }
        switch (webUIDriverType) {
            case CHROME_DRIVER: 
            case HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForChrome(propertyMap);
            }
            case FIREFOX_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                return WebDriverPropertyUtil.getDesireCapabilitiesForFirefox(propertyMap);
            }
            case EDGE_CHROMIUM_DRIVER: {
                return WebDriverPropertyUtil.getDesiredCapabilitiesForEdgeChromium(propertyMap, true);
            }
        }
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap);
    }

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap) {
        return WebDriverPropertyUtil.toDesireCapabilities(propertyMap, new DesiredCapabilities(), true);
    }

    public static DesiredCapabilities toDesireCapabilities(Map<String, Object> propertyMap, DesiredCapabilities desireCapabilities, boolean isLog) {
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            desireCapabilities.setCapability(property.getKey(), property.getValue());
            if (!isLog || WebDriverPropertyUtil.isRunFromTestCloudWithSauceLabs(property)) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        return desireCapabilities;
    }

    public static DesiredCapabilities getDesiredCapabilitiesForEdgeChromium(Map<String, Object> propertyMap, boolean isLog) {
        HashMap<String, String> msEdgeOptions;
        DesiredCapabilities capabilities = DesiredCapabilities.edge();
        if (OSUtil.isMac()) {
            capabilities.setPlatform(Platform.MAC);
        } else if (OSUtil.isWindows()) {
            capabilities.setPlatform(Platform.WINDOWS);
        } else {
            capabilities.setPlatform(Platform.LINUX);
        }
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (isLog) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
            }
            capabilities.setCapability(property.getKey(), property.getValue());
        }
        if (!(capabilities.getPlatform() != Platform.LINUX || (msEdgeOptions = (HashMap<String, String>)capabilities.getCapability(EDGE_OPTIONS_CAPABILITY)) != null && msEdgeOptions.containsKey("binary"))) {
            File msEdgeBinaryFilePath;
            String msEdgeBinary;
            if (msEdgeOptions == null) {
                msEdgeOptions = new HashMap<String, String>();
            }
            if (StringUtils.isEmpty((CharSequence)(msEdgeBinary = ConsoleCommandExecutor.safeWhere((String)"microsoft-edge")))) {
                msEdgeBinary = "/usr/bin/microsoft-edge";
            }
            if ((msEdgeBinaryFilePath = new File(msEdgeBinary)).exists()) {
                msEdgeOptions.put("binary", msEdgeBinary);
            }
            capabilities.setCapability(EDGE_OPTIONS_CAPABILITY, msEdgeOptions);
        }
        return capabilities;
    }

    public static DesiredCapabilities getDesireCapabilitiesForFirefox(Map<String, Object> propertyMap) {
        DesiredCapabilities desireCapabilities = DesiredCapabilities.firefox();
        FirefoxProfile firefoxProfile = WebDriverPropertyUtil.createDefaultFirefoxProfile();
        for (Map.Entry<String, Object> property : propertyMap.entrySet()) {
            if (property.getKey().equals("firefox_profile") && property.getValue() instanceof Map) {
                WebDriverPropertyUtil.processFirefoxPreferencesSetting(firefoxProfile, (Map)property.getValue());
                continue;
            }
            desireCapabilities.setCapability(property.getKey(), property.getValue());
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, property.getKey(), property.getValue()));
        }
        desireCapabilities.setCapability("firefox_profile", (Object)firefoxProfile);
        return desireCapabilities;
    }

    private static void processFirefoxPreferencesSetting(FirefoxProfile firefoxProfile, Map<?, ?> firefoxPropertyMap) {
        for (Map.Entry<?, ?> entry : firefoxPropertyMap.entrySet()) {
            String entryKey;
            if (!(entry.getKey() instanceof String) || !WebDriverPropertyUtil.setFirefoxPreferenceValue(firefoxProfile, entryKey = (String)entry.getKey(), entry.getValue())) continue;
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FIREFOX_PROPERTY_SETTING, entryKey, entry.getValue()));
        }
    }

    private static boolean setFirefoxPreferenceValue(FirefoxProfile firefoxProfile, String entryKey, Object entryValue) {
        if (entryValue instanceof Number) {
            firefoxProfile.setPreference(entryKey, ((Number)entryValue).intValue());
            return true;
        }
        if (entryValue instanceof Boolean) {
            firefoxProfile.setPreference(entryKey, ((Boolean)entryValue).booleanValue());
            return true;
        }
        if (entryValue instanceof String) {
            firefoxProfile.setPreference(entryKey, (String)entryValue);
            return true;
        }
        return false;
    }

    public static FirefoxProfile createDefaultFirefoxProfile() {
        CFirefoxProfile firefoxProfile = new CFirefoxProfile();
        firefoxProfile.setPreference(BROWSER_STARTUP_HOMEPAGE_PREFERENCE, FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_PREFERENCE, FIREFOX_BLANK_PAGE);
        firefoxProfile.setPreference(STARTUP_HOMEPAGE_WELCOME_URL_ADDITIONAL_PREFERENCE, FIREFOX_BLANK_PAGE);
        return firefoxProfile;
    }

    public static DesiredCapabilities getDesireCapabilitiesForChrome(Map<String, Object> propertyMap) {
        DesiredCapabilities desireCapabilities = DesiredCapabilities.chrome();
        HashMap<String, Object> chromeOptions = new HashMap<String, Object>();
        for (Map.Entry<String, Object> driverProperty : propertyMap.entrySet()) {
            if (Arrays.asList(CHROME_CAPABILITIES).contains(driverProperty.getKey())) {
                chromeOptions.put(driverProperty.getKey(), driverProperty.getValue());
            } else {
                desireCapabilities.setCapability(driverProperty.getKey(), driverProperty.getValue());
            }
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_WEB_UI_PROPERTY_SETTING, driverProperty.getKey(), driverProperty.getValue()));
        }
        if (!propertyMap.containsKey("binary")) {
            if (OSUtil.isMac()) {
                chromeBinary = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
                chromeBinaryFilePath = new File(chromeBinary);
                if (chromeBinaryFilePath.exists()) {
                    chromeOptions.put("binary", chromeBinary);
                }
            } else if (!OSUtil.isWindows()) {
                chromeBinary = ConsoleCommandExecutor.safeWhere((String)"google-chrome");
                if (StringUtils.isEmpty((CharSequence)BROWSER_STARTUP_HOMEPAGE_PREFERENCE)) {
                    chromeBinary = "/usr/bin/google-chrome";
                }
                if ((chromeBinaryFilePath = new File(chromeBinary)).exists()) {
                    chromeOptions.put("binary", chromeBinary);
                }
            }
        }
        WebDriverPropertyUtil.injectAddtionalArgumentsForChrome(chromeOptions);
        desireCapabilities.setCapability("goog:chromeOptions", chromeOptions);
        return desireCapabilities;
    }

    private static void injectAddtionalArgumentsForChrome(Map<String, Object> chromeOptions) {
        if (chromeOptions == null) {
            return;
        }
        ArrayList<String> argumentsList = new ArrayList<String>();
        if (chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY) instanceof List) {
            argumentsList.addAll((List)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY));
        }
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argumentsList.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argumentsList);
    }

    public static void addArgumentsForChrome(DesiredCapabilities caps, String ... args) {
        ArrayList<String> argsEntry;
        HashMap<String, ArrayList<String>> chromeOptions = (HashMap<String, ArrayList<String>>)caps.getCapability("goog:chromeOptions");
        if (chromeOptions == null) {
            chromeOptions = new HashMap<String, ArrayList<String>>();
        }
        if ((argsEntry = (ArrayList<String>)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList<String>();
        }
        argsEntry.addAll(Arrays.asList(args));
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argsEntry.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability("goog:chromeOptions", chromeOptions);
    }

    public static void removeArgumentsForChrome(DesiredCapabilities caps, String ... args) {
        ArrayList<String> argsEntry;
        HashMap chromeOptions = (HashMap)caps.getCapability("goog:chromeOptions");
        if (chromeOptions == null) {
            chromeOptions = new HashMap();
        }
        if ((argsEntry = (ArrayList<String>)chromeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList<String>();
        }
        argsEntry.removeAll(Arrays.asList(args));
        if (WebDriverPropertyUtil.isRunningInDocker()) {
            argsEntry.add(CHROME_NO_SANDBOX);
        }
        chromeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability("goog:chromeOptions", chromeOptions);
    }

    public static void addArgumentsForEdgeChromium(DesiredCapabilities caps, String ... args) {
        ArrayList<String> argsEntry;
        HashMap<String, ArrayList<String>> edgeOptions = (HashMap<String, ArrayList<String>>)caps.getCapability(EDGE_OPTIONS_CAPABILITY);
        if (edgeOptions == null) {
            edgeOptions = new HashMap<String, ArrayList<String>>();
        }
        if ((argsEntry = (ArrayList<String>)edgeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList<String>();
        }
        argsEntry.addAll(Arrays.asList(args));
        edgeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability(EDGE_OPTIONS_CAPABILITY, edgeOptions);
    }

    public static void removeArgumentsForEdgeChromium(DesiredCapabilities caps, String ... args) {
        ArrayList argsEntry;
        HashMap edgeOptions = (HashMap)caps.getCapability(EDGE_OPTIONS_CAPABILITY);
        if (edgeOptions == null) {
            edgeOptions = new HashMap();
        }
        if ((argsEntry = (ArrayList)edgeOptions.get(CHROME_ARGUMENT_PROPERTY_KEY)) == null) {
            argsEntry = new ArrayList();
        }
        argsEntry.removeAll(Arrays.asList(args));
        edgeOptions.put(CHROME_ARGUMENT_PROPERTY_KEY, argsEntry);
        caps.setCapability(EDGE_OPTIONS_CAPABILITY, edgeOptions);
    }

    public static boolean isRunningInDocker() {
        if (System.getenv().containsKey(KATALON_DOCKER_ENV_KEY)) {
            return Boolean.valueOf(System.getenv(KATALON_DOCKER_ENV_KEY));
        }
        return false;
    }

    private static boolean isRunFromTestCloudWithSauceLabs(Map.Entry<String, Object> property) {
        return TestCloudPropertyUtil.getInstance().isRunFromTestCloud() && (property.getKey().equals("accessKey") || property.getKey().equals("username"));
    }

    public static boolean didUserProfileInstallKatalonCompactUtility(WebUIDriverType driverType, DesiredCapabilities capabilities) {
        String capabilityKey = "";
        switch (driverType) {
            case CHROME_DRIVER: {
                capabilityKey = "goog:chromeOptions";
                break;
            }
            case EDGE_CHROMIUM_DRIVER: {
                capabilityKey = EDGE_OPTIONS_CAPABILITY;
                break;
            }
            default: {
                return false;
            }
        }
        Map options = (Map)capabilities.getCapability(capabilityKey);
        if (options == null) {
            return false;
        }
        List argsEntry = (List)options.get(CHROME_ARGUMENT_PROPERTY_KEY);
        if (argsEntry == null) {
            return false;
        }
        Optional<String> userDataDirOptional = argsEntry.stream().filter(arg -> arg.contains(CHROME_PROPERTY_USER_DATA_DIR)).map(arg -> arg.replace(CHROME_PROPERTY_USER_DATA_DIR, "")).findAny();
        if (!userDataDirOptional.isPresent() || userDataDirOptional.get().isEmpty()) {
            return false;
        }
        Optional<String> profileDirOptional = argsEntry.stream().filter(arg -> arg.contains(CHROME_PROPERTY_PROFILE_DIR)).map(arg -> arg.replace(CHROME_PROPERTY_PROFILE_DIR, "")).findAny();
        if (!profileDirOptional.isPresent() || profileDirOptional.get().isEmpty()) {
            return false;
        }
        String userDataDir = userDataDirOptional.get().replace(CHROME_PROPERTY_USER_DATA_DIR, "");
        String profileDir = Paths.get(userDataDir, profileDirOptional.get().replace(CHROME_PROPERTY_PROFILE_DIR, "")).toString();
        File extensionChromeKCUFolder = new File(profileDir, CHROME_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH);
        if (extensionChromeKCUFolder.exists()) {
            return true;
        }
        File extensionEdgeKCUFolder = new File(profileDir, EDGE_CHROMIUM_KATALON_COMPACT_UTILITY_EXTENSION_RELATIVE_PATH);
        return extensionEdgeKCUFolder.exists();
    }
}

