/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.util;

import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.network.ProxyServerType;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.util.internal.ProxyUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WebDriverProxyUtil {
    private static final String PROP_SOCKS_PW = "socksPassword";
    private static final String PROP_SOCKS_USERNAME = "socksUsername";
    private static final String PROP_SOCKS_PROXY = "socksProxy";
    private static final String PROP_HTTP_PROXY = "httpProxy";
    private static final String PROP_SSL_PROXY = "sslProxy";
    private static final String PROP_PROXY_TYPE = "proxyType";
    private static final String PROP_NO_PROXY = "noProxy";

    public static Map<String, Object> getSeleniumProxy(ProxyInformation proxyInformation) {
        HashMap<String, Object> proxyMap = new HashMap<String, Object>();
        ArrayList exceptionList = new ArrayList();
        String exclude = proxyInformation.getExceptionList().trim();
        String[] output = exclude.split(",");
        Arrays.stream(output).forEach(part -> {
            if (!StringUtils.isBlank((CharSequence)part)) {
                exceptionList.add(part.trim());
            }
        });
        String proxyString = WebDriverProxyUtil.getProxyString(proxyInformation);
        switch (ProxyOption.valueOf((String)proxyInformation.getProxyOption())) {
            case MANUAL_CONFIG: {
                proxyMap.put(PROP_PROXY_TYPE, "manual");
                if (exceptionList.size() > 0) {
                    proxyMap.put(PROP_NO_PROXY, exceptionList);
                }
                switch (ProxyServerType.valueOf((String)proxyInformation.getProxyServerType())) {
                    case HTTP: 
                    case HTTPS: {
                        proxyMap.put(PROP_HTTP_PROXY, proxyString);
                        proxyMap.put(PROP_SSL_PROXY, proxyString);
                        break;
                    }
                    case SOCKS: {
                        proxyMap.put(PROP_SOCKS_PROXY, proxyString);
                        proxyMap.put(PROP_SOCKS_USERNAME, proxyInformation.getUsername());
                        proxyMap.put(PROP_SOCKS_PW, proxyInformation.getPassword());
                    }
                }
                break;
            }
            case USE_SYSTEM: {
                proxyMap.put(PROP_PROXY_TYPE, "system");
                break;
            }
            case NO_PROXY: {
                proxyMap.put(PROP_PROXY_TYPE, "direct");
            }
        }
        return proxyMap;
    }

    public static Map<String, Object> getSeleniumProxy(ProxyInformation proxyInformation, String url, String driverType) {
        HashMap<String, Object> proxyMap = new HashMap<String, Object>();
        ArrayList exceptionList = new ArrayList();
        String[] output = proxyInformation.getExceptionList().split(",");
        Arrays.stream(output).forEach(part -> {
            boolean bl = exceptionList.add(part.trim());
        });
        URL newUrl = null;
        Proxy proxy = null;
        try {
            newUrl = PathUtil.getUrl((String)url, (String)"http");
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (URISyntaxException uRISyntaxException) {}
        try {
            proxy = ProxyUtil.getProxy((ProxyInformation)proxyInformation, (URL)newUrl);
        }
        catch (IOException | URISyntaxException exception) {}
        String proxyString = WebDriverProxyUtil.getProxyString(proxyInformation);
        switch (ProxyOption.valueOf((String)proxyInformation.getProxyOption())) {
            case MANUAL_CONFIG: {
                proxyMap.put(PROP_PROXY_TYPE, "manual");
                switch (ProxyServerType.valueOf((String)proxyInformation.getProxyServerType())) {
                    case HTTP: 
                    case HTTPS: {
                        if (proxy.type() == Proxy.Type.DIRECT) {
                            if (driverType.equals("") || driverType.equals("internet explorer")) break;
                            proxyMap.put(PROP_PROXY_TYPE, "direct");
                            break;
                        }
                        proxyMap.put(PROP_HTTP_PROXY, proxyString);
                        proxyMap.put(PROP_SSL_PROXY, proxyString);
                        break;
                    }
                    case SOCKS: {
                        proxyMap.put(PROP_SOCKS_PROXY, proxyString);
                        proxyMap.put(PROP_SOCKS_USERNAME, proxyInformation.getUsername());
                        proxyMap.put(PROP_SOCKS_PW, proxyInformation.getPassword());
                    }
                }
                break;
            }
            case USE_SYSTEM: {
                proxyMap.put(PROP_PROXY_TYPE, "system");
                break;
            }
            case NO_PROXY: {
                proxyMap.put(PROP_PROXY_TYPE, "direct");
            }
        }
        return proxyMap;
    }

    public static String getProxyString(ProxyInformation proxyInformation) {
        return String.format("%s:%d", proxyInformation.getProxyServerAddress(), proxyInformation.getProxyServerPort());
    }

    public static boolean isManualSocks(ProxyInformation proxyInformation) {
        return proxyInformation != null && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG && ProxyServerType.valueOf((String)proxyInformation.getProxyServerType()) == ProxyServerType.SOCKS;
    }

    public static boolean isNoProxy(ProxyInformation proxyInformation) {
        return proxyInformation != null && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.NO_PROXY;
    }
}

