/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import groovy.lang.Reference;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.BinaryExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EnclosingASTNodeFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.MethodCallFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.PropertyExpressionFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.SimpleExpressionASTFragment;
import org.codehaus.groovy.syntax.Token;
import org.eclipse.core.runtime.Assert;

public class ASTFragmentFactory {
    public IASTFragment createFragment(ASTNode node) {
        if (node instanceof Expression) {
            return this.createFragment((Expression)node, node.getStart(), node.getEnd());
        }
        return new EnclosingASTNodeFragment(node);
    }

    public IASTFragment createFragment(Expression expression) {
        return this.createFragment(expression, expression.getStart(), expression.getEnd());
    }

    public IASTFragment createFragment(Expression expression, int start, int end) {
        Expression inner;
        Assert.isLegal((expression.getStart() <= start ? 1 : 0) != 0, (String)("Invalid start position: " + start));
        Assert.isLegal((expression.getEnd() >= end ? 1 : 0) != 0, (String)("Invalid end position: " + end));
        if (expression instanceof BooleanExpression) {
            inner = ((BooleanExpression)expression).getExpression();
            if (inner.getStart() == expression.getStart() && inner.getEnd() == expression.getEnd()) {
                expression = inner;
            }
        } else if (expression instanceof TupleExpression && ((TupleExpression)expression).getExpressions().size() == 1 && (inner = ((TupleExpression)expression).getExpression(0)).getStart() == expression.getStart() && inner.getEnd() == expression.getEnd()) {
            expression = inner;
        }
        if (expression instanceof BinaryExpression) {
            IASTFragment fragment = this.createBinaryFragment((BinaryExpression)expression, start, end);
            if (expression instanceof DeclarationExpression) {
                if (fragment.kind() == ASTFragmentKind.BINARY) {
                    ((BinaryExpressionFragment)fragment).setActualStartPosition(((DeclarationExpression)expression).getStart());
                } else if (fragment.kind() == ASTFragmentKind.SIMPLE_EXPRESSION) {
                    ((SimpleExpressionASTFragment)fragment).setActualStartPosition(((DeclarationExpression)expression).getStart());
                }
            }
            return fragment;
        }
        if (expression instanceof PropertyExpression) {
            return this.createPropertyFragment(expression, start, end);
        }
        if (expression instanceof MethodCallExpression) {
            return this.createPropertyFragment(expression, start, end);
        }
        if (expression instanceof MethodPointerExpression) {
            return this.createPropertyFragment(expression, start, end);
        }
        if (expression.getStart() == start && expression.getEnd() == end) {
            return new SimpleExpressionASTFragment(expression);
        }
        return new EmptyASTFragment();
    }

    private IASTFragment createBinaryFragment(BinaryExpression expression, int start, int end) {
        ArrayList expressions = new ArrayList();
        ArrayList tokens = new ArrayList();
        Reference walker = new Reference();
        walker.set(bin -> {
            if (bin.getLeftExpression() instanceof BinaryExpression) {
                ((Consumer)walker.get()).accept((BinaryExpression)bin.getLeftExpression());
            } else {
                expressions.add(bin.getLeftExpression());
            }
            tokens.add(bin.getOperation());
            if (bin.getRightExpression() instanceof BinaryExpression) {
                ((Consumer)walker.get()).accept((BinaryExpression)bin.getRightExpression());
            } else {
                expressions.add(bin.getRightExpression());
            }
        });
        ((Consumer)walker.get()).accept(expression);
        IASTFragment fragment = new EmptyASTFragment();
        Expression lastExpr = (Expression)expressions.get(expressions.size() - 1);
        if (lastExpr.getStart() >= start && lastExpr.getEnd() <= end) {
            fragment = new SimpleExpressionASTFragment(lastExpr);
        }
        int i = tokens.size() - 1;
        while (i >= 0) {
            Expression nextExpr = (Expression)expressions.get(i);
            if (nextExpr.getStart() >= start && nextExpr.getEnd() <= end) {
                fragment = fragment.kind() == ASTFragmentKind.EMPTY ? new SimpleExpressionASTFragment(nextExpr) : new BinaryExpressionFragment((Token)tokens.get(i), nextExpr, fragment);
            }
            --i;
        }
        return fragment;
    }

    private IASTFragment createPropertyFragment(Expression expression, int start, int end) {
        ArrayList kinds = new ArrayList();
        ArrayList exprs = new ArrayList();
        ArrayList args = new ArrayList();
        ArrayList ends = new ArrayList();
        Reference walker = new Reference();
        walker.set(nextExpression -> {
            ASTFragmentKind kind = ASTFragmentKind.SIMPLE_EXPRESSION;
            Expression last = nextExpression;
            Expression aExpr = null;
            Integer until = null;
            if (nextExpression instanceof PropertyExpression) {
                PropertyExpression propExpression = (PropertyExpression)nextExpression;
                ((Consumer)walker.get()).accept(propExpression.getObjectExpression());
                last = propExpression.getProperty();
                int lastIndex = kinds.size() - 1;
                if (kinds.get(lastIndex) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                    kinds.set(lastIndex, ASTFragmentKind.toPropertyKind((Expression)propExpression));
                    args.set(lastIndex, null);
                }
            } else if (nextExpression instanceof MethodCallExpression) {
                MethodCallExpression callExpression = (MethodCallExpression)nextExpression;
                ((Consumer)walker.get()).accept(callExpression.getObjectExpression());
                int lastIndex = kinds.size() - 1;
                if (kinds.get(lastIndex) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                    kinds.set(lastIndex, callExpression.isSpreadSafe() ? ASTFragmentKind.SPREAD_SAFE_PROPERTY : (callExpression.isSafe() ? ASTFragmentKind.SAFE_PROPERTY : ASTFragmentKind.PROPERTY));
                    args.set(lastIndex, null);
                }
                kind = ASTFragmentKind.METHOD_CALL;
                last = callExpression.getMethod();
                aExpr = callExpression.getArguments();
                until = callExpression.getEnd();
            } else if (nextExpression instanceof MethodPointerExpression) {
                ((Consumer)walker.get()).accept(((MethodPointerExpression)nextExpression).getExpression());
                last = ((MethodPointerExpression)nextExpression).getMethodName();
                int lastIndex = kinds.size() - 1;
                if (kinds.get(lastIndex) == ASTFragmentKind.SIMPLE_EXPRESSION) {
                    kinds.set(lastIndex, ASTFragmentKind.METHOD_POINTER);
                    args.set(lastIndex, null);
                }
            }
            if (until == null) {
                until = last.getEnd();
            }
            kinds.add(kind);
            exprs.add(last);
            args.add(aExpr);
            ends.add(until);
        });
        ((Consumer)walker.get()).accept(expression);
        boolean wasImplicitCall = false;
        IASTFragment fragment = new EmptyASTFragment();
        Expression lastExpr = (Expression)exprs.get(exprs.size() - 1);
        if (lastExpr.getStart() >= start && lastExpr.getEnd() <= end) {
            if (kinds.get(kinds.size() - 1) == ASTFragmentKind.METHOD_CALL) {
                MethodCallFragment frag = new MethodCallFragment(lastExpr, (Expression)args.get(exprs.size() - 1), (Integer)ends.get(exprs.size() - 1));
                frag.callExpression = (MethodCallExpression)expression;
                fragment = frag;
            } else {
                fragment = new SimpleExpressionASTFragment(lastExpr);
            }
        } else if (ASTFragmentFactory.isCallImplicit(lastExpr)) {
            wasImplicitCall = true;
        }
        int i = exprs.size() - 2;
        while (i >= 0) {
            Expression expr = (Expression)exprs.get(i);
            if (expr.getStart() >= start && expr.getEnd() <= end) {
                fragment = kinds.get(i) == ASTFragmentKind.METHOD_CALL ? new MethodCallFragment(expr, (Expression)args.get(i), fragment.kind() == ASTFragmentKind.EMPTY ? null : fragment, (Integer)ends.get(i)) : (fragment.kind() == ASTFragmentKind.EMPTY ? (!wasImplicitCall ? new SimpleExpressionASTFragment(expr) : new MethodCallFragment(expr, (Expression)args.get(i + 1), null, (Integer)ends.get(i))) : (!wasImplicitCall ? new PropertyExpressionFragment((ASTFragmentKind)((Object)kinds.get(i)), expr, fragment) : new MethodCallFragment(expr, (Expression)args.get(i + 1), fragment, (Integer)ends.get(i))));
                wasImplicitCall = false;
            } else if (ASTFragmentFactory.isCallImplicit(expr)) {
                wasImplicitCall = true;
            }
            --i;
        }
        return fragment;
    }

    private static boolean isCallImplicit(Expression e) {
        return e.getEnd() == 0 && e instanceof ConstantExpression && ((ConstantExpression)e).getText().equals("call");
    }

    public static String spaces(int num) {
        StringBuilder sb = new StringBuilder();
        while (num-- > 0) {
            sb.append("  ");
        }
        return sb.toString();
    }
}

