/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.element.impl.AndroidSnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.IosSnapshotMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.IosXCUISnapshotMobileElement;
import com.kms.katalon.core.webui.util.OSUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MobileKeywordContextMenu {
    private static final MobileAction SEPARATOR = null;
    private static final MobileAction[] MOBILE_KEYWORDS = new MobileAction[]{MobileAction.CaptureObject, SEPARATOR, MobileAction.VerifyElementExist, MobileAction.VerifyElementNotExist, MobileAction.VerifyElementVisible, MobileAction.VerifyElementNotVisible, MobileAction.VerifyElementChecked, MobileAction.VerifyElementNotChecked, MobileAction.VerifyElementText, SEPARATOR, MobileAction.WaitForElementPresent, MobileAction.WaitForElementNotPresent};
    private static final int SEPARATOR_ID = 100;
    private static final int RIGHT_CLICK_OPTION = 3;
    private Point currentPoint;
    private Menu fullKeywordsPopupMenu;
    private Menu emptyMenu;
    private Menu withoutCheckableKeywordsPopupMenu;
    private List<MenuItem> menuItemList = new ArrayList<MenuItem>();
    private KeywordExecutionProvider keywordExecutionProvider;
    private ChosenMobileElementProvider detectChosenElementProvider;

    public MobileKeywordContextMenu(Control parent) {
        this.fullKeywordsPopupMenu = new Menu(parent);
        this.emptyMenu = new Menu(parent);
        this.withoutCheckableKeywordsPopupMenu = new Menu(parent);
        this.createMenuItems(this.fullKeywordsPopupMenu, this.withoutCheckableKeywordsPopupMenu);
        parent.setMenu(this.emptyMenu);
        this.addEventListener(parent);
    }

    private void createMenuItems(Menu fullKeywordsMenu, Menu withoutCheckableKeywordsMenu) {
        int i = 0;
        while (i < MOBILE_KEYWORDS.length) {
            MobileAction keyword = MOBILE_KEYWORDS[i];
            if (keyword == SEPARATOR) {
                this.addSeparator(fullKeywordsMenu);
                this.addSeparator(withoutCheckableKeywordsMenu);
            } else {
                if (!keyword.getDescription().contains("Checked")) {
                    this.addMenuItem(withoutCheckableKeywordsMenu, keyword.getDescription(), i);
                }
                this.addMenuItem(fullKeywordsMenu, keyword.getDescription(), i);
            }
            ++i;
        }
    }

    private void addSeparator(Menu menu) {
        new MenuItem(menu, 2).setID(100);
    }

    private void addMenuItem(Menu menu, String content, int id) {
        MenuItem item = new MenuItem(menu, 0);
        item.setText(content);
        item.setID(id);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(e.getSource() instanceof MenuItem) || MobileKeywordContextMenu.this.currentPoint == null) {
                    return;
                }
                MenuItem menuItem = (MenuItem)e.getSource();
                int chosenKeywordID = menuItem.getID();
                if (chosenKeywordID == 100 || MobileKeywordContextMenu.this.keywordExecutionProvider == null) {
                    return;
                }
                MobileKeywordContextMenu.this.keywordExecutionProvider.execute(MobileKeywordContextMenu.this.getKeyword(chosenKeywordID), MobileKeywordContextMenu.this.currentPoint);
            }
        });
        this.menuItemList.add(item);
    }

    private void addEventListener(final Control parent) {
        if (OSUtil.isMac()) {
            parent.addListener(32, new Listener(){

                public void handleEvent(Event event) {
                    MobileKeywordContextMenu.this.currentPoint = new Point(event.x, event.y);
                }
            });
            parent.addListener(35, new Listener(){

                public void handleEvent(Event e) {
                    MobileKeywordContextMenu.this.setMenu(parent, MobileKeywordContextMenu.this.currentPoint);
                }
            });
        } else {
            parent.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 3) {
                        MobileKeywordContextMenu.this.currentPoint = new Point(e.x, e.y);
                        MobileKeywordContextMenu.this.setMenu(parent, MobileKeywordContextMenu.this.currentPoint);
                    }
                }
            });
        }
    }

    private void setMenu(Control parent, Point position) {
        boolean shouldDisplayContextMenu;
        CapturedMobileElement chosenElement = this.detectChosenElementProvider.getChosenElement(position);
        boolean bl = shouldDisplayContextMenu = this.detectChosenElementProvider == null || chosenElement != null;
        if (shouldDisplayContextMenu) {
            this.toggleCheckableKeyword(parent, this.isCheckableElement(chosenElement));
        } else {
            parent.setMenu(this.emptyMenu);
        }
    }

    private boolean isCheckableElement(CapturedMobileElement element) {
        if (element.getLink() instanceof AndroidSnapshotMobileElement) {
            if (element.getAttributes().containsKey("checkable")) {
                return element.getAttributes().get("checkable").equals("true");
            }
            return false;
        }
        if ((element.getLink() instanceof IosSnapshotMobileElement || element.getLink() instanceof IosXCUISnapshotMobileElement) && element.getAttributes().containsKey("value")) {
            String value = element.getAttributes().get("value");
            return value.equals("0") || value.equals("1");
        }
        return false;
    }

    private void toggleCheckableKeyword(Control parent, boolean isEnabled) {
        if (isEnabled) {
            parent.setMenu(this.fullKeywordsPopupMenu);
        } else {
            parent.setMenu(this.withoutCheckableKeywordsPopupMenu);
        }
    }

    private MobileAction getKeyword(int id) {
        return MOBILE_KEYWORDS[id];
    }

    public void onKeywordClickedListener(KeywordExecutionProvider listener) {
        this.keywordExecutionProvider = listener;
    }

    public void whichElementChosen(ChosenMobileElementProvider listener) {
        this.detectChosenElementProvider = listener;
    }

    public static interface ChosenMobileElementProvider {
        public CapturedMobileElement getChosenElement(Point var1);
    }

    public static interface KeywordExecutionProvider {
        public void execute(MobileAction var1, Point var2);
    }
}

