/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class MobileDeviceDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Device View";
    private Image currentScreenShot;
    private Canvas canvas;
    public static final int DIALOG_WIDTH = 400;
    public static final int DIALOG_HEIGHT = 750;
    public static final String HIGHLIGHT_COLOR = "#76BF42";
    private List<Rectangle> highlightRects = new ArrayList<Rectangle>();
    private boolean highlightPhase = false;
    private double hRatio;
    private boolean isDisposed;
    private Point initialLocation;
    private MobileElementInspectorDialog mobileInspetorDialog;
    private ScrolledComposite scrolledComposite;

    public MobileDeviceDialog(Shell parentShell, MobileElementInspectorDialog mobileInspectorDialog, Point location) {
        super(parentShell);
        this.mobileInspetorDialog = mobileInspectorDialog;
        this.initialLocation = location;
        this.setShellStyle(1268);
        this.isDisposed = false;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogAreaGridLayout = (GridLayout)dialogArea.getLayout();
        dialogAreaGridLayout.marginWidth = 0;
        dialogAreaGridLayout.marginHeight = 0;
        this.scrolledComposite = new ScrollableComposite(dialogArea, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite container = new Composite((Composite)this.scrolledComposite, 2048);
        container.setLayout((Layout)new FillLayout());
        this.scrolledComposite.setContent((Control)container);
        this.canvas = new Canvas(container, 0);
        this.canvas.pack();
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (MobileDeviceDialog.this.currentScreenShot != null && !MobileDeviceDialog.this.currentScreenShot.isDisposed()) {
                    e.gc.drawImage(MobileDeviceDialog.this.currentScreenShot, 0, 0);
                    if (MobileDeviceDialog.this.highlightPhase && MobileDeviceDialog.this.highlightRects != null && MobileDeviceDialog.this.highlightRects.size() > 0) {
                        Color oldForegroundColor = e.gc.getForeground();
                        e.gc.setForeground(ColorUtil.getColor((String)MobileDeviceDialog.HIGHLIGHT_COLOR));
                        int oldLineWidth = e.gc.getLineWidth();
                        e.gc.setLineWidth(2);
                        MobileDeviceDialog.this.highlightRects.forEach(rect -> paintEvent.gc.drawRectangle(MobileDeviceDialog.safeRoundDouble((double)rect.x * MobileDeviceDialog.this.hRatio), MobileDeviceDialog.safeRoundDouble((double)rect.y * MobileDeviceDialog.this.hRatio), MobileDeviceDialog.safeRoundDouble((double)rect.width * MobileDeviceDialog.this.hRatio), MobileDeviceDialog.safeRoundDouble((double)rect.height * MobileDeviceDialog.this.hRatio)));
                        e.gc.setLineWidth(oldLineWidth);
                        e.gc.setForeground(oldForegroundColor);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    MobileDeviceDialog.this.inspectElementAt(e.x, e.y);
                }
            }
        });
        return dialogArea;
    }

    protected boolean isResizable() {
        return true;
    }

    private void inspectElementAt(int x, int y) {
        Double realX = (double)x / this.hRatio;
        Double realY = (double)y / this.hRatio;
        this.mobileInspetorDialog.setSelectedElementByLocation(MobileDeviceDialog.safeRoundDouble(realX), MobileDeviceDialog.safeRoundDouble(realY));
    }

    private boolean isElementOnScreen(Double x, Double y, Double width, Double height) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        return elementRect.intersects(this.getCurrentViewportRect());
    }

    private void scrollToElement(Double x, Double y) {
        this.scrolledComposite.setOrigin(x.intValue(), y.intValue());
    }

    private Rectangle getCurrentViewportRect() {
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        ScrollBar horizontalBar = this.scrolledComposite.getHorizontalBar();
        int viewPortY = verticalBar.isVisible() ? verticalBar.getSelection() : 0;
        int viewPortX = horizontalBar.isVisible() ? horizontalBar.getSelection() : 0;
        Point viewPortSize = this.scrolledComposite.getSize();
        Rectangle viewPortRect = new Rectangle(viewPortX, viewPortY, viewPortSize.x, viewPortSize.y);
        return viewPortRect;
    }

    public void highlight(double x, double y, double width, double height) {
        Rectangle newHighlightRect = new Rectangle(MobileDeviceDialog.safeRoundDouble(x), MobileDeviceDialog.safeRoundDouble(y), MobileDeviceDialog.safeRoundDouble(width), MobileDeviceDialog.safeRoundDouble(height));
        this.highlightRect(newHighlightRect);
    }

    public void highlightRect(Rectangle rect) {
        ArrayList<Rectangle> newHighlightRects = new ArrayList<Rectangle>();
        newHighlightRects.add(rect);
        this.highlightRects(newHighlightRects);
    }

    public void highlightRects(final List<Rectangle> rects) {
        if (rects == null || rects.size() == 0) {
            return;
        }
        Display.getCurrent().syncExec(new Runnable(){

            @Override
            public void run() {
                Rectangle firstRect;
                Rectangle rectangle = firstRect = rects.size() > 0 ? (Rectangle)rects.get(0) : null;
                if (firstRect == null) {
                    return;
                }
                double currentX = (double)firstRect.x * MobileDeviceDialog.this.hRatio;
                double currentY = (double)firstRect.y * MobileDeviceDialog.this.hRatio;
                double currentWidth = (double)firstRect.width * MobileDeviceDialog.this.hRatio;
                double currentHeight = (double)firstRect.height * MobileDeviceDialog.this.hRatio;
                if (!MobileDeviceDialog.this.isElementOnScreen(currentX, currentY, currentWidth, currentHeight)) {
                    MobileDeviceDialog.this.scrollToElement(currentX, currentY);
                }
            }
        });
        Thread highlightThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MobileDeviceDialog.this.highlightRects.addAll(rects);
                int i = 0;
                while (i < 9) {
                    MobileDeviceDialog.this.highlightPhase = i % 2 == 1;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    UISynchronizeService.syncExec(() -> {
                        if (!MobileDeviceDialog.this.canvas.isDisposed()) {
                            MobileDeviceDialog.this.canvas.redraw();
                        }
                    });
                    ++i;
                }
                List<Rectangle> list = MobileDeviceDialog.this.highlightRects = Collections.synchronizedList(MobileDeviceDialog.this.highlightRects);
                synchronized (list) {
                    MobileDeviceDialog.this.highlightRects.removeAll(rects);
                }
            }
        });
        highlightThread.start();
    }

    private Image scaleImage(Image image, double newWidth, double newHeight) {
        Image scaled = new Image((Device)Display.getDefault(), MobileDeviceDialog.safeRoundDouble(newWidth), MobileDeviceDialog.safeRoundDouble(newHeight));
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, MobileDeviceDialog.safeRoundDouble(newWidth), MobileDeviceDialog.safeRoundDouble(newHeight));
        gc.dispose();
        image.dispose();
        return scaled;
    }

    protected Point getInitialSize() {
        return new Point(400, 807);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(2160);
        this.setBlockOnOpen(false);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    public void closeApp() {
        this.handleShellCloseEvent();
    }

    public void highlightElement(MobileElement selectedElement) {
        Map<String, String> attributes = selectedElement.getAttributes();
        if (!(attributes != null && attributes.containsKey("x") && attributes.containsKey("y") && attributes.containsKey("width") && attributes.containsKey("height"))) {
            return;
        }
        double x = Double.parseDouble(attributes.get("x"));
        double y = Double.parseDouble(attributes.get("y"));
        double w = Double.parseDouble(attributes.get("width"));
        double h = Double.parseDouble(attributes.get("height"));
        this.highlight(x, y, w, h);
    }

    public void refreshDialog(File imageFile, MobileElement root) {
        try {
            ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
            Image img = imgDesc.createImage();
            this.getShell().getDisplay().syncExec(() -> {
                Map<String, String> attributes;
                double rootHeight = image.getBounds().height;
                if (root != null && (attributes = root.getAttributes()).containsKey("height") && attributes.containsKey("width") && attributes.containsKey("x") && attributes.containsKey("y")) {
                    rootHeight = Double.parseDouble(attributes.get("height"));
                }
                double imageRatio = rootHeight / (double)image.getBounds().height;
                this.hRatio = (double)this.canvas.getSize().y / rootHeight;
                this.currentScreenShot = this.scaleImage(img, (double)image.getBounds().width * imageRatio * this.hRatio, (double)image.getBounds().height * this.hRatio * imageRatio);
                this.canvas.redraw();
            });
            this.refreshView();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void refreshView() {
        if (this.scrolledComposite == null || this.currentScreenShot == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MobileDeviceDialog.this.scrolledComposite.setMinSize(MobileDeviceDialog.this.currentScreenShot.getImageData().width, MobileDeviceDialog.this.currentScreenShot.getImageData().height);
            }
        });
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected Point getInitialLocation(Point initialSize) {
        if ((this.getShell().getStyle() & 0x10) == 0) {
            return new Point(this.initialLocation.x, this.initialLocation.y + 5);
        }
        return this.initialLocation;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }
}

