/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.beust.jcommander.internal.Lists;
import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.mobile.objectspy.components.MobileKeywordContextMenu;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.ElementSelectionHelper;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.core.webui.util.OSUtil;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class MobileDeviceView {
    private ElementSelectionHelper helper = new ElementSelectionHelper();
    private Image scaledScreenShot;
    private Image originalScreenshot;
    private Canvas canvas;
    private List<Rectangle> highlightRects = new ArrayList<Rectangle>();
    private List<TreeMobileElement> lastPosibleElements = new ArrayList<TreeMobileElement>();
    private boolean highlighPhase;
    private double elementXRatio;
    private double elementYRatio;
    private double screenshotYRatio;
    private TreeMobileElement rootElement;
    private TreeMobileElement lastFocusedElement;
    private Point cursorCoordinate;
    private boolean isDisposed;
    private MobileElementInspectorDialog parentDialog;
    private ScrolledComposite scrolledComposite;
    private Label locatorLabel;
    private int elementLayerIndex;

    public MobileDeviceView(MobileElementInspectorDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Composite createControls(Composite parent) {
        Composite mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().build();
        ComponentBuilder.label((Composite)mainComposite).text("DEVICE VIEW").fillHorizontal().bold().build();
        Composite deviceViewContainer = (Composite)ComponentBuilder.gridContainer((Composite)mainComposite, (int)1, (int)2048).fill().build();
        this.locatorLabel = (Label)ComponentBuilder.label((Composite)deviceViewContainer).text("").background(ColorUtil.GRAY_DARK_COLOR).fillHorizontal().height(ComponentUtil.applyZoom((int)16)).build();
        this.scrolledComposite = new ScrollableComposite(deviceViewContainer, 768);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        Composite container = (Composite)ComponentBuilder.fillContainer((Composite)this.scrolledComposite).build();
        this.scrolledComposite.setContent((Control)container);
        this.canvas = (Canvas)ComponentBuilder.canvas((Composite)container).onPaint((event, gc, widget) -> {
            if (this.scaledScreenShot != null && !this.scaledScreenShot.isDisposed()) {
                gc.drawImage(this.scaledScreenShot, 0, 0);
                if (this.highlighPhase && !this.highlightRects.isEmpty()) {
                    Color oldForegroundColor = gc.getForeground();
                    gc.setForeground(ColorUtil.getColor((String)"#76BF42"));
                    int oldLineWidth = gc.getLineWidth();
                    gc.setLineWidth(2);
                    this.highlightRects.forEach(rect -> gc.drawRectangle(rect.x, rect.y, rect.width, rect.height));
                    gc.setLineWidth(oldLineWidth);
                    gc.setForeground(oldForegroundColor);
                }
                MobileElement targetElement = null;
                if (!this.lastPosibleElements.isEmpty()) {
                    targetElement = this.lastPosibleElements.get(this.elementLayerIndex);
                    int nextIndex = (this.elementLayerIndex + 1) % this.lastPosibleElements.size();
                    MobileElement nextElement = this.lastPosibleElements.size() > nextIndex ? (MobileElement)this.lastPosibleElements.get(nextIndex) : null;
                    int index = 0;
                    while (index < this.lastPosibleElements.size()) {
                        MobileElement elementI = this.lastPosibleElements.get(index);
                        if (elementI != targetElement && elementI != nextElement) {
                            this.drawElementRect(elementI, gc, "#333333", 100, index + 1);
                        }
                        ++index;
                    }
                    if (nextElement != null) {
                        this.drawElementRect(nextElement, gc, "#3c7be6", 200, nextIndex + 1);
                    }
                    this.drawElementRect(targetElement, gc, "#ff0000", 255, this.elementLayerIndex + 1);
                }
                this.drawCoordinates(gc, targetElement);
            }
        }).onResize(event -> this.rerenderScreenview()).onClick(event -> {
            if (event.button == 1) {
                this.inspectHoveringElement();
            }
        }).mouseTrack((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                MobileDeviceView.this.lastPosibleElements.clear();
                MobileDeviceView.this.cursorCoordinate = null;
                MobileDeviceView.this.redrawCanvas();
                MobileDeviceView.this.rerenderLocatorLabel();
            }
        }).onMouseMove(event -> {
            boolean hasChanged;
            ElementSelectionHelper helper = new ElementSelectionHelper();
            this.cursorCoordinate = new Point(event.x, event.y);
            Point cursorPosition = this.screenToElementSpace(event.x, event.y);
            List<TreeMobileElement> elements = helper.findTopMostElementsByLocation(this.rootElement, cursorPosition.x, cursorPosition.y);
            boolean bl = hasChanged = !this.lastPosibleElements.equals(elements) || elements.size() - 1 < this.elementLayerIndex;
            if (hasChanged) {
                this.elementLayerIndex = 0;
            }
            if (!elements.isEmpty()) {
                TreeMobileElement mostPosibleElement = elements.get(this.elementLayerIndex);
                this.locatorLabel.setText(MessageFormat.format("{0} ({1}/{2})", mostPosibleElement.getName(), this.elementLayerIndex + 1, elements.size()));
            }
            this.lastPosibleElements = elements;
            this.redrawCanvas();
            this.rerenderLocatorLabel();
        }).build();
        this.canvas.pack();
        parent.getDisplay().addFilter(1, event -> {
            if (this.canvas.isDisposed()) {
                return;
            }
            if (event.keyCode == 262144 || event.keyCode == 0x400000) {
                this.elementLayerIndex = (this.elementLayerIndex + 1) % this.lastPosibleElements.size();
                this.redrawCanvas();
                this.rerenderLocatorLabel();
            }
        });
        TimeUtil.setInterval(timer -> {
            if (this.canvas.isDisposed()) {
                TimeUtil.cancel((Timer)timer);
            }
            this.highlighPhase = !this.highlighPhase;
            this.redrawCanvas();
        }, (long)500L);
        ComponentBuilder.label((Composite)deviceViewContainer).text(MessageFormat.format("Tips: You can press [{0}] to switch between layers.", OSUtil.isMac() ? "Command" : "Ctrl")).fillHorizontal().background(ColorUtil.GRAY_DARK_COLOR).build();
        this.createKeywordContextMenu();
        return mainComposite;
    }

    private void drawCoordinates(GC gc, MobileElement mostPosibleElement) {
        ArrayList<String> info = new ArrayList<String>();
        if (this.cursorCoordinate != null) {
            Point cursorPosition = this.screenToElementSpace(this.cursorCoordinate);
            String cursorCoordinateInfo = MessageFormat.format("({0,number,#}, {1,number,#})", cursorPosition.x, cursorPosition.y);
            info.add(cursorCoordinateInfo);
        }
        if (mostPosibleElement != null) {
            Rectangle elementBounds = this.helper.getElementBounds(mostPosibleElement);
            String elementInfo = MessageFormat.format("({0,number,#}, {1,number,#}) {2,number,#}x{3,number,#}", elementBounds.x, elementBounds.y, elementBounds.width, elementBounds.height);
            info.add(elementInfo);
        }
        if (info.isEmpty()) {
            return;
        }
        String infoString = String.join((CharSequence)" / ", info);
        gc.setForeground(ColorUtil.getColor((String)"#ffffff"));
        gc.setBackground(ColorUtil.getColor((String)"#333333"));
        gc.drawText(infoString, 0, 0);
    }

    private void drawElementRect(MobileElement element, GC gc, String color, int alpha, int index) {
        Rectangle rect = this.elementToScreenSpace(element);
        gc.setLineWidth(2);
        gc.setAlpha(alpha);
        gc.setForeground(ColorUtil.getColor((String)color));
        gc.drawRectangle(rect.x, rect.y, rect.width, rect.height);
        if (index >= 1) {
            gc.setBackground(ColorUtil.getColor((String)color));
            gc.setForeground(ColorUtil.getColor((String)"#ffffff"));
            gc.drawText(String.valueOf(index), rect.x, rect.y);
        }
    }

    private void rerenderLocatorLabel() {
        boolean shouldHighlightHoveringElement;
        TreeMobileElement mostPosibleElement = this.lastFocusedElement;
        boolean bl = shouldHighlightHoveringElement = this.lastPosibleElements.size() - 1 >= this.elementLayerIndex;
        if (shouldHighlightHoveringElement) {
            mostPosibleElement = this.lastPosibleElements.get(this.elementLayerIndex);
        }
        String indicator = shouldHighlightHoveringElement ? MessageFormat.format("({0}/{1}) ", this.elementLayerIndex + 1, this.lastPosibleElements.size()) : "";
        String locator = mostPosibleElement != null ? MessageFormat.format("{0}{1}", indicator, mostPosibleElement.getName()) : "";
        this.locatorLabel.setText(locator);
    }

    private void createKeywordContextMenu() {
        MobileKeywordContextMenu keywordContextMenu = new MobileKeywordContextMenu((Control)this.canvas);
        keywordContextMenu.onKeywordClickedListener((mobileAction, currentPoint) -> {
            this.inspectHoveringElement();
            this.parentDialog.onActionChosen(mobileAction, null);
        });
        keywordContextMenu.whichElementChosen(currentPoint -> {
            this.inspectHoveringElement();
            Point clickPosition = this.screenToElementSpace(currentPoint.x, currentPoint.y);
            return this.parentDialog.captureMobileElement(clickPosition.x, clickPosition.y);
        });
    }

    private void inspectHoveringElement() {
        TreeMobileElement target;
        if (this.lastPosibleElements.size() - 1 < this.elementLayerIndex) {
            return;
        }
        this.lastFocusedElement = target = this.lastPosibleElements.get(this.elementLayerIndex);
        this.parentDialog.setSelectedElement(target);
    }

    public boolean isElementOnScreen(Double x, Double y, Double width, Double height) {
        Rectangle elementRect = new Rectangle(x.intValue(), y.intValue(), width.intValue(), height.intValue());
        return elementRect.intersects(this.getCurrentViewportRect());
    }

    private void scrollToElement(Double x, Double y) {
        this.scrolledComposite.setOrigin(x.intValue(), y.intValue());
    }

    private Rectangle getCurrentViewportRect() {
        ScrollBar verticalBar = this.scrolledComposite.getVerticalBar();
        ScrollBar horizontalBar = this.scrolledComposite.getHorizontalBar();
        int viewPortY = verticalBar.isVisible() ? verticalBar.getSelection() : 0;
        int viewPortX = horizontalBar.isVisible() ? horizontalBar.getSelection() : 0;
        Point viewPortSize = this.scrolledComposite.getSize();
        Rectangle viewPortRect = new Rectangle(viewPortX, viewPortY, viewPortSize.x, viewPortSize.y);
        return viewPortRect;
    }

    public void highlight(Rectangle rect) {
        this.internalHighlightRects(Lists.newArrayList((Object[])new Rectangle[]{rect}));
    }

    public void highlight(double x, double y, double width, double height) {
        this.highlight(new Rectangle(MobileDeviceView.safeRoundDouble(x), MobileDeviceView.safeRoundDouble(y), MobileDeviceView.safeRoundDouble(width), MobileDeviceView.safeRoundDouble(height)));
    }

    public void highlightRects(List<Rectangle> rects) {
        this.internalHighlightRects(rects);
    }

    private void internalHighlightRects(List<Rectangle> rects) {
        if (rects == null || rects.size() == 0) {
            return;
        }
        List scaledRects = rects.stream().map(rectI -> this.elementToScreenSpace((Rectangle)rectI)).collect(Collectors.toList());
        this.highlightRects.clear();
        this.highlightRects.addAll(scaledRects);
        Display.getCurrent().syncExec(() -> {
            Rectangle firstRect = (Rectangle)rects.get(0);
            double currentX = firstRect.x;
            double currentY = firstRect.y;
            double currentWidth = firstRect.width;
            double currentHeight = firstRect.height;
            if (!this.isElementOnScreen(currentX, currentY, currentWidth, currentHeight)) {
                this.scrollToElement(currentX, currentY);
            }
        });
        this.redrawCanvas();
    }

    private Image scaleImage(Image image, double newWidth, double newHeight) {
        Image scaled = new Image((Device)Display.getDefault(), MobileDeviceView.safeRoundDouble(newWidth), MobileDeviceView.safeRoundDouble(newHeight));
        GC gc = new GC((Drawable)scaled);
        gc.setAntialias(1);
        gc.setInterpolation(2);
        gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, MobileDeviceView.safeRoundDouble(newWidth), MobileDeviceView.safeRoundDouble(newHeight));
        gc.dispose();
        return scaled;
    }

    public void highlightElement(MobileElement selectedElement) {
        this.highlight(this.helper.getElementBounds(selectedElement));
    }

    private Rectangle findContainerRect(MobileElement root) {
        Rectangle containerRect = new Rectangle(0, 0, 0, 0);
        TreeMobileElement elementI = (TreeMobileElement)root;
        while (elementI != null) {
            List<? extends TreeMobileElement> children;
            Rectangle rectI = this.helper.getElementBounds(elementI);
            String type = StringUtils.defaultString((String)elementI.getAttributes().get("type"), (String)elementI.getAttributes().get("class"));
            if (StringUtils.startsWith((CharSequence)type, (CharSequence)"XCUI") && StringUtils.equals((CharSequence)type, (CharSequence)"XCUIElementTypeWindow")) {
                return rectI;
            }
            int areaI = rectI.width * rectI.height;
            int containerArea = containerRect.width * containerRect.height;
            if (areaI > containerArea) {
                containerRect = rectI;
            }
            if ((children = elementI.getChildrenElement()).size() > 1) break;
            TreeMobileElement treeMobileElement = elementI = children != null && children.size() > 0 ? children.get(0) : null;
        }
        boolean isDialog = containerRect.y > 200;
        return isDialog ? null : containerRect;
    }

    private Rectangle elementToScreenSpace(MobileElement element) {
        return this.elementToScreenSpace(this.helper.getElementBounds(element));
    }

    private Rectangle elementToScreenSpace(Rectangle elementSpaceRect) {
        return new Rectangle(MobileDeviceView.safeRoundDouble((double)elementSpaceRect.x / this.elementXRatio / this.screenshotYRatio), MobileDeviceView.safeRoundDouble((double)elementSpaceRect.y / this.elementYRatio / this.screenshotYRatio), MobileDeviceView.safeRoundDouble((double)elementSpaceRect.width / this.elementXRatio / this.screenshotYRatio), MobileDeviceView.safeRoundDouble((double)elementSpaceRect.height / this.elementYRatio / this.screenshotYRatio));
    }

    private Point screenToElementSpace(Point screenSpaceRect) {
        return this.screenToElementSpace(screenSpaceRect.x, screenSpaceRect.y);
    }

    private Point screenToElementSpace(int x, int y) {
        return new Point(MobileDeviceView.safeRoundDouble((double)x * this.elementXRatio * this.screenshotYRatio), MobileDeviceView.safeRoundDouble((double)y * this.elementYRatio * this.screenshotYRatio));
    }

    public void refreshDialog(File imageFile, MobileElement root) {
        try {
            this.rootElement = (TreeMobileElement)root;
            this.highlightRects.clear();
            this.redrawCanvas();
            if (this.originalScreenshot != null) {
                this.originalScreenshot.dispose();
            }
            if (imageFile != null) {
                ImageDescriptor imgDesc = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                this.originalScreenshot = imgDesc.createImage();
            } else {
                this.originalScreenshot = null;
            }
            this.renderScreenshot(root, this.originalScreenshot);
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void rerenderScreenview() {
        if (this.rootElement == null) {
            return;
        }
        this.renderScreenshot(this.rootElement, this.originalScreenshot);
    }

    private void renderScreenshot(MobileElement root, Image screenshot) {
        try {
            if (this.scaledScreenShot != null) {
                this.scaledScreenShot.dispose();
            }
            if (screenshot == null) {
                this.scaledScreenShot = null;
            } else {
                UISynchronizeService.syncExec(() -> {
                    Rectangle foundRootRect;
                    Rectangle imgBounds = screenshot.getBounds();
                    Point canvasSize = this.scrolledComposite.getSize();
                    Rectangle rootRect = imgBounds;
                    if (root != null && (foundRootRect = this.findContainerRect(root)) != null) {
                        rootRect = foundRootRect;
                    }
                    this.elementXRatio = (double)rootRect.width / (double)imgBounds.width;
                    this.elementYRatio = (double)rootRect.width / (double)imgBounds.width;
                    this.screenshotYRatio = (double)imgBounds.height / (double)canvasSize.y;
                    this.scaledScreenShot = this.scaleImage(screenshot, (double)imgBounds.width / this.screenshotYRatio, (double)imgBounds.height / this.screenshotYRatio);
                });
            }
            this.redrawCanvas();
            this.refreshView();
        }
        catch (Exception ex) {
            LoggerSingleton.logError((Throwable)ex);
        }
    }

    private void refreshView() {
        if (this.scrolledComposite == null) {
            return;
        }
        Display.getDefault().asyncExec(() -> {
            if (this.scaledScreenShot != null) {
                this.scrolledComposite.setMinSize(this.scaledScreenShot.getImageData().width - 10, this.scaledScreenShot.getImageData().height - 10);
            } else {
                this.scrolledComposite.setMinSize(this.scrolledComposite.computeSize(-1, -1));
            }
        });
    }

    private void redrawCanvas() {
        UISynchronizeService.asyncExec(() -> {
            if (!this.canvas.isDisposed()) {
                this.canvas.redraw();
            }
        });
    }

    public void setDisposed(boolean isDisposed) {
        this.isDisposed = isDisposed;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }

    public static int parseSize(String size) {
        return MobileDeviceView.safeRoundDouble(Double.parseDouble(size));
    }
}

