/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.impl;

import com.kms.katalon.composer.mobile.objectspy.element.impl.RenderedTreeSnapshotMobileElement;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import com.kms.katalon.entity.repository.MobileElementEntity;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidSnapshotMobileElement
extends RenderedTreeSnapshotMobileElement<Element> {
    private static final long serialVersionUID = -8005661770483917366L;
    private String locator;
    private MobileElementEntity.LocatorStrategy locatorStrategy;

    public AndroidSnapshotMobileElement() {
    }

    public AndroidSnapshotMobileElement(AndroidSnapshotMobileElement parent) {
        super(parent);
    }

    @Override
    public void render(Element xmlElement) {
        if (xmlElement == null) {
            return;
        }
        this.convertXMLElementToWebElementForAndroid(xmlElement);
        if (!xmlElement.hasChildNodes()) {
            return;
        }
        NodeList childElementNodes = xmlElement.getChildNodes();
        int count = childElementNodes.getLength();
        int i = 0;
        while (i < count) {
            Node node = childElementNodes.item(i);
            if (node instanceof Element) {
                AndroidSnapshotMobileElement childNode = new AndroidSnapshotMobileElement(this);
                this.getChildrenElement().add(childNode);
                childNode.render((Element)node);
            }
            ++i;
        }
    }

    public void convertXMLElementToWebElementForAndroid(Element xmlElement) {
        Map<String, String> htmlMobileElementProps = this.getAttributes();
        if (StringUtils.isNotEmpty((String)xmlElement.getAttribute("class"))) {
            htmlMobileElementProps.put("class", xmlElement.getAttribute("class"));
        }
        String instance = "0";
        if (xmlElement.hasAttribute("instance") && xmlElement.getAttribute("instance").length() > 0) {
            instance = xmlElement.getAttribute("instance");
            htmlMobileElementProps.put("instance", instance);
        }
        String index = "0";
        if (xmlElement.hasAttribute("index") && xmlElement.getAttribute("index").length() > 0) {
            index = xmlElement.getAttribute("index");
            htmlMobileElementProps.put("index", index);
        }
        if (xmlElement.hasAttribute("text") && xmlElement.getAttribute("text").length() > 0) {
            htmlMobileElementProps.put("text", xmlElement.getAttribute("text"));
        }
        if (xmlElement.hasAttribute("resource-id") && xmlElement.getAttribute("resource-id").length() > 0) {
            htmlMobileElementProps.put("resource-id", xmlElement.getAttribute("resource-id"));
        }
        if (xmlElement.hasAttribute("package") && xmlElement.getAttribute("package").length() > 0) {
            htmlMobileElementProps.put("package", xmlElement.getAttribute("package"));
        }
        if (xmlElement.hasAttribute("content-desc") && xmlElement.getAttribute("content-desc").length() > 0) {
            htmlMobileElementProps.put("content-desc", xmlElement.getAttribute("content-desc"));
        }
        if (xmlElement.hasAttribute("checkable") && xmlElement.getAttribute("checkable").length() > 0) {
            htmlMobileElementProps.put("checkable", xmlElement.getAttribute("checkable"));
        }
        if (xmlElement.hasAttribute("checked") && xmlElement.getAttribute("checked").length() > 0) {
            htmlMobileElementProps.put("checked", xmlElement.getAttribute("checked"));
        }
        if (xmlElement.hasAttribute("clickable") && xmlElement.getAttribute("clickable").length() > 0) {
            htmlMobileElementProps.put("clickable", xmlElement.getAttribute("clickable"));
        }
        if (xmlElement.hasAttribute("enabled") && xmlElement.getAttribute("enabled").length() > 0) {
            htmlMobileElementProps.put("enabled", xmlElement.getAttribute("enabled"));
        }
        if (xmlElement.hasAttribute("focusable") && xmlElement.getAttribute("focusable").length() > 0) {
            htmlMobileElementProps.put("focusable", xmlElement.getAttribute("focusable"));
        }
        if (xmlElement.hasAttribute("focused") && xmlElement.getAttribute("focused").length() > 0) {
            htmlMobileElementProps.put("focused", xmlElement.getAttribute("focused"));
        }
        if (xmlElement.hasAttribute("scrollable") && xmlElement.getAttribute("scrollable").length() > 0) {
            htmlMobileElementProps.put("scrollable", xmlElement.getAttribute("scrollable"));
        }
        if (xmlElement.hasAttribute("long-clickable") && xmlElement.getAttribute("long-clickable").length() > 0) {
            htmlMobileElementProps.put("long-clickable", xmlElement.getAttribute("long-clickable"));
        }
        if (xmlElement.hasAttribute("password") && xmlElement.getAttribute("password").length() > 0) {
            htmlMobileElementProps.put("password", xmlElement.getAttribute("password"));
        }
        if (xmlElement.hasAttribute("selected") && xmlElement.getAttribute("selected").length() > 0) {
            htmlMobileElementProps.put("selected", xmlElement.getAttribute("selected"));
        }
        if (xmlElement.hasAttribute("bounds") && xmlElement.getAttribute("bounds").length() > 0) {
            String bounds = xmlElement.getAttribute("bounds");
            int left = Integer.parseInt(bounds.substring(1, bounds.indexOf(44)));
            int top = Integer.parseInt(bounds.substring(bounds.indexOf(44) + 1, bounds.indexOf(93)));
            int right = Integer.parseInt(bounds.substring(bounds.lastIndexOf(91) + 1, bounds.lastIndexOf(44)));
            int bottom = Integer.parseInt(bounds.substring(bounds.lastIndexOf(44) + 1, bounds.lastIndexOf(93)));
            htmlMobileElementProps.put("x", String.valueOf(left));
            htmlMobileElementProps.put("y", String.valueOf(top));
            htmlMobileElementProps.put("width", String.valueOf(right - left));
            htmlMobileElementProps.put("height", String.valueOf(bottom - top));
        }
        NamedNodeMap attributes = xmlElement.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            String attrName = attributes.item(i).getNodeName();
            String attrValue = attributes.item(i).getNodeValue();
            if (!htmlMobileElementProps.containsKey(attrName)) {
                htmlMobileElementProps.put(attrName, attrValue);
            }
            ++i;
        }
        String guiName = htmlMobileElementProps.get("class");
        if (StringUtils.isNotEmpty((String)guiName)) {
            if (StringUtils.isNotEmpty((String)htmlMobileElementProps.get("text"))) {
                guiName = String.valueOf(guiName) + " - " + htmlMobileElementProps.get("text");
            }
            if (guiName.contains("\n")) {
                guiName = guiName.replace("\n", "");
            }
        } else {
            guiName = xmlElement.getTagName();
        }
        this.setName(guiName);
        htmlMobileElementProps.put("xpath", this.makeXpath());
        this.setAttributes(htmlMobileElementProps);
    }

    @Override
    protected void buildLocator(AppiumDriver<?> driver) {
        List elements;
        List elements2;
        List elements3;
        List elements4;
        AndroidDriver androidDriver = (AndroidDriver)driver;
        MobileTestObject testObject = new MobileTestObject("");
        ArrayList<TestObjectProperty> properties = new ArrayList<TestObjectProperty>();
        for (Map.Entry<String, String> attr : this.getAttributes().entrySet()) {
            String key = attr.getKey();
            String value = attr.getValue();
            TestObjectProperty prop = new TestObjectProperty(key, ConditionType.EQUALS, value);
            properties.add(prop);
        }
        testObject.setProperties(properties);
        MobileSearchEngine searchEngine = new MobileSearchEngine(driver, (TestObject)testObject);
        String attributesLocator = searchEngine.findAndroidAttributesLocator();
        if (StringUtils.isNotEmpty((String)attributesLocator) && (elements4 = androidDriver.findElementsByXPath(attributesLocator)) != null && elements4.size() == 1) {
            this.setLocator(attributesLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ATTRIBUTES);
            return;
        }
        String accessibilityLocator = searchEngine.findAndroidAccessibilityId();
        if (StringUtils.isNotEmpty((String)accessibilityLocator) && (elements3 = androidDriver.findElementsByAccessibilityId(accessibilityLocator)) != null && elements3.size() == 1) {
            this.setLocator(accessibilityLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ACCESSIBILITY);
            return;
        }
        String idLocator = searchEngine.findAndroidID();
        if (StringUtils.isNotEmpty((String)idLocator) && (elements2 = androidDriver.findElementsById(idLocator)) != null && elements2.size() == 1) {
            this.setLocator(idLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ID);
            return;
        }
        String uiAutomatorLocator = searchEngine.findAndroidUIAutomatorSelector();
        if (StringUtils.isNotEmpty((String)uiAutomatorLocator) && (elements = androidDriver.findElementsByAndroidUIAutomator(uiAutomatorLocator)) != null && elements.size() == 1) {
            this.setLocator(uiAutomatorLocator);
            this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.ANDROID_UI_AUTOMATOR);
            return;
        }
        this.setLocator(this.getXpath());
        this.setLocatorStrategy(MobileElementEntity.LocatorStrategy.XPATH);
    }

    @Override
    public MobileDriverType getMobileDriverType() {
        return MobileDriverType.ANDROID_DRIVER;
    }

    @Override
    public String getXpath() {
        return this.getAttributes().get("xpath");
    }

    @Override
    public String getTagName() {
        return this.getAttributes().get("class");
    }

    @Override
    public String getLocator() {
        return this.locator;
    }

    @Override
    public void setLocator(String locator) {
        this.locator = locator;
    }

    @Override
    public MobileElementEntity.LocatorStrategy getLocatorStrategy() {
        return this.locatorStrategy;
    }

    @Override
    public void setLocatorStrategy(MobileElementEntity.LocatorStrategy locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    @Override
    protected String makeXpath() {
        String xpath = super.makeXpath();
        if (xpath.contains("ActionBar$Tab")) {
            xpath = xpath.replace("ActionBar$Tab", "ActionBar.Tab");
        }
        return xpath;
    }
}

