/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.impl;

import com.kms.katalon.composer.mobile.objectspy.element.impl.RenderedTreeSnapshotMobileElement;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import java.text.DecimalFormat;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class IosSnapshotMobileElement
extends RenderedTreeSnapshotMobileElement<JSONObject> {
    private static final long serialVersionUID = 1462755224775883146L;
    private static final String CHILDREN_JSON_PROPERTY_NAME = "children";
    private static final String INTEGER_PATTERN_FORMAT_STRING = "#####";

    public IosSnapshotMobileElement() {
    }

    public IosSnapshotMobileElement(IosSnapshotMobileElement parentElement) {
        super(parentElement);
    }

    @Override
    public void render(JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        this.convertJsonObjectToWebElementForIos(jsonObject);
        if (jsonObject.has(CHILDREN_JSON_PROPERTY_NAME)) {
            JSONArray childrens = jsonObject.getJSONArray(CHILDREN_JSON_PROPERTY_NAME);
            int i = 0;
            while (i < childrens.length()) {
                JSONObject child = childrens.getJSONObject(i);
                IosSnapshotMobileElement childNode = new IosSnapshotMobileElement(this);
                this.getChildrenElement().add(childNode);
                childNode.render(child);
                ++i;
            }
        }
    }

    public void convertJsonObjectToWebElementForIos(JSONObject jsonObject) {
        Map<String, String> properties = this.getAttributes();
        String propType = jsonObject.getString("type");
        properties.put("type", propType);
        String propName = null;
        if (jsonObject.has("name") && jsonObject.getString("name").length() > 0) {
            propName = jsonObject.getString("name");
            properties.put("name", propName);
        }
        String propLabel = null;
        if (jsonObject.has("label") && jsonObject.getString("label").length() > 0) {
            propLabel = jsonObject.getString("label");
            properties.put("label", propLabel);
        }
        String propValue = null;
        if (jsonObject.has("value") && String.valueOf(jsonObject.get("value")).length() > 0) {
            propValue = String.valueOf(jsonObject.get("value"));
            properties.put("value", propValue);
        }
        if (jsonObject.has("hint") && jsonObject.getString("hint").length() > 0) {
            properties.put("hint", jsonObject.getString("hint"));
        }
        if (jsonObject.has("rect")) {
            DecimalFormat formatter = new DecimalFormat(INTEGER_PATTERN_FORMAT_STRING);
            JSONObject rect = jsonObject.getJSONObject("rect");
            if (rect.has("origin")) {
                JSONObject origin = rect.getJSONObject("origin");
                if (origin.has("x")) {
                    double x = origin.getDouble("x");
                    properties.put("x", String.valueOf(x % 1.0 > 0.0 ? Double.valueOf(x) : formatter.format(x)));
                }
                if (origin.has("y")) {
                    double y = origin.getDouble("y");
                    properties.put("y", String.valueOf(y % 1.0 > 0.0 ? Double.valueOf(y) : formatter.format(y)));
                }
            }
            if (rect.has("size")) {
                JSONObject size = rect.getJSONObject("size");
                if (size.has("width")) {
                    double width = size.getDouble("width");
                    properties.put("width", String.valueOf(width % 1.0 > 0.0 ? Double.valueOf(width) : formatter.format(width)));
                }
                if (size.has("height")) {
                    double height = size.getDouble("height");
                    properties.put("height", String.valueOf(height % 1.0 > 0.0 ? Double.valueOf(height) : formatter.format(height)));
                }
            }
        }
        if (jsonObject.has("enabled")) {
            properties.put("enabled", String.valueOf(jsonObject.getBoolean("enabled")));
        }
        if (jsonObject.has("valid")) {
            properties.put("valid", String.valueOf(jsonObject.getBoolean("valid")));
        }
        if (jsonObject.has("visible")) {
            properties.put("visible", String.valueOf(jsonObject.getBoolean("visible")));
        }
        String guiName = propType;
        if (propName != null) {
            guiName = String.valueOf(guiName) + " - " + propName;
        } else if (propLabel != null) {
            guiName = String.valueOf(guiName) + " - " + propLabel;
        } else if (propValue != null) {
            guiName = String.valueOf(guiName) + " - " + propValue;
        }
        this.getAttributes().put("xpath", this.makeXpath());
        this.setName(guiName);
    }

    @Override
    public MobileDriverType getMobileDriverType() {
        return MobileDriverType.IOS_DRIVER;
    }

    @Override
    public String getTagName() {
        return this.getAttributes().get("type");
    }
}

