/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.components.KobitonAppComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileObjectSpyDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.integration.kobiton.preferences.KobitonPreferencesProvider;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class MobileSpyKobitonDeviceHandler {
    @Inject
    IEventBroker eventBroker;

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell activeShell) {
        this.openObjectSpyDialog(activeShell);
    }

    private boolean openObjectSpyDialog(Shell activeShell) {
        block4: {
            block5: {
                try {
                    boolean isIntegrationEnabled = KobitonPreferencesProvider.isKobitonIntegrationEnabled();
                    if (isIntegrationEnabled) break block4;
                    boolean confirmToConfigureKobiton = MessageDialog.openConfirm((Shell)activeShell, (String)GlobalStringConstants.INFO, (String)"Kobiton integration has not been enabled yet. Would you like to enable now?");
                    if (confirmToConfigureKobiton) break block5;
                    return false;
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    MessageDialog.openError((Shell)activeShell, (String)GlobalStringConstants.ERROR, (String)e.getMessage());
                    return false;
                }
            }
            this.eventBroker.post("KATALON/PREFERENCES", (Object)"com.kms.katalon.composer.preferences.GeneralPreferencePage/com.kms.katalon.composer.integration.kobiton.preferences");
            return false;
        }
        Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
        MobileObjectSpyDialog objectSpyDialog = new MobileObjectSpyDialog(dialogShell, new KobitonAppComposite());
        objectSpyDialog.open();
        return true;
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }
}

