/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.helper.KeywordHelper;
import com.kms.katalon.core.keyword.internal.KeywordMain;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.keyword.builtin.SetTextKeyword;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileBy;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.android.nativekey.AndroidKey;
import io.appium.java_client.android.nativekey.KeyEvent;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.touch.LongPressOptions;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.ElementOption;
import io.appium.java_client.touch.offset.PointOption;
import java.io.File;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Keys;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.touch.TouchActions;
import org.openqa.selenium.remote.RemoteWebElement;

public class MobileActionHelper {
    private static final int timeout = 10;
    private static final FailureHandling flowControl = FailureHandling.STOP_ON_FAILURE;
    private AppiumDriver<?> driver;

    public MobileActionHelper(AppiumDriver<?> driver) {
        this.driver = driver;
    }

    public WebElement findElement(TestObject to, int timeOut) throws Exception {
        Date startTime = new Date();
        long span = 0L;
        WebElement webElement = null;
        Point elementLocation = null;
        MobileSearchEngine searchEngine = new MobileSearchEngine(this.driver, to);
        Dimension screenSize = this.driver.manage().window().getSize();
        while (span < (long)timeOut) {
            webElement = searchEngine.findWebElement(false);
            if (webElement != null) {
                elementLocation = webElement.getLocation();
                if (elementLocation.y < screenSize.height) break;
                try {
                    if (this.driver instanceof AndroidDriver) {
                        TouchActions ta = new TouchActions((WebDriver)((AndroidDriver)this.driver));
                        ta.down(screenSize.width / 2, screenSize.height / 2).perform();
                        ta.move(screenSize.width / 2, (int)((double)(screenSize.height / 2) * 0.5)).perform();
                        ta.release().perform();
                    } else {
                        TouchAction swipe = new TouchAction(this.driver).press(PointOption.point((int)(screenSize.width / 2), (int)(screenSize.height / 2))).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(500L))).moveTo(PointOption.point((int)(screenSize.width / 2), (int)((int)((double)(screenSize.height / 2) * 0.5)))).release();
                        swipe.perform();
                    }
                }
                catch (Exception exception) {}
            }
            Date endTime = new Date();
            span = endTime.getTime() - startTime.getTime();
        }
        return webElement;
    }

    public List<WebElement> findElements(MobileTestObject testObject) throws Exception {
        if (testObject == null) {
            throw new IllegalArgumentException("Test object cannot be null");
        }
        MobileSearchEngine searchEngine = new MobileSearchEngine(this.driver, (TestObject)testObject);
        return searchEngine.findWebElements(false);
    }

    public void tap(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.click();
    }

    public void tapAndHold(TestObject to) throws Exception {
        WebElement element = this.findElement(to, 10);
        TouchAction longPressAction = new TouchAction(this.driver);
        longPressAction = longPressAction.longPress((LongPressOptions)LongPressOptions.longPressOptions().withElement(ElementOption.element((WebElement)element)));
        longPressAction.release().perform();
    }

    public void swipe(int startX, int startY, int endX, int endY) throws Exception {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            TouchAction swipe = new TouchAction(this.driver).press(PointOption.point((int)startX, (int)startY)).waitAction(WaitOptions.waitOptions((Duration)Duration.ofMillis(500L))).moveTo(PointOption.point((int)endX, (int)endY)).release();
            swipe.perform();
        }
        finally {
            this.driver.context(context);
        }
    }

    public String getText(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return null;
        }
        return element.getText();
    }

    public void setText(TestObject to, String text) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
        new SetTextKeyword().sendKeys(element, text);
    }

    public void hideKeyboard() {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            try {
                this.driver.hideKeyboard();
            }
            catch (WebDriverException e) {
                if (!e.getMessage().startsWith(StringConstants.APPIUM_DRIVER_ERROR_JS_FAILED) || !(this.driver instanceof IOSDriver)) {
                    throw e;
                }
                IOSDriver iosDriver = (IOSDriver)this.driver;
                iosDriver.hideKeyboard("pressKey", "Done");
            }
        }
        finally {
            this.driver.context(context);
        }
    }

    public void clearText(TestObject to) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.clear();
    }

    public void scrollToText(String text) {
        String context = this.driver.getContext();
        try {
            List elements;
            this.internalSwitchToNativeContext(this.driver);
            if (this.driver instanceof AndroidDriver) {
                String uiSelector = String.format("new UiSelector().textContains(\"%s\")", text);
                String uiScrollable = String.format("new UiScrollable(new UiSelector().scrollable(true).instance(0)).scrollIntoView(%s)", uiSelector);
                ((AndroidDriver)this.driver).findElementByAndroidUIAutomator(uiScrollable);
            } else if (this.driver instanceof IOSDriver && (elements = ((IOSDriver)this.driver).findElements(MobileBy.xpath((String)("//*[contains(@label, '" + text + "') or contains(@text, '" + text + "')]")))) != null && !elements.isEmpty()) {
                RemoteWebElement remoteElement = (RemoteWebElement)elements.get(0);
                String parentID = remoteElement.getId();
                HashMap<String, String> scrollObject = new HashMap<String, String>();
                scrollObject.put("element", parentID);
                scrollObject.put("toVisible", text);
                this.driver.executeScript("mobile:scroll", new Object[]{scrollObject});
            }
        }
        finally {
            this.driver.context(context);
        }
    }

    private boolean internalSwitchToNativeContext(AppiumDriver<?> driver) {
        return this.internalSwitchToContext(driver, "NATIVE");
    }

    private boolean internalSwitchToWebViewContext(AppiumDriver<?> driver) {
        return this.internalSwitchToContext(driver, "WEBVIEW");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean internalSwitchToContext(AppiumDriver<?> driver, String contextName) {
        try {
            String context;
            Iterator iterator = driver.getContextHandles().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (String)iterator.next()).contains(contextName));
            driver.context(context);
            return true;
        }
        catch (WebDriverException webDriverException) {}
        return false;
    }

    public void pressBack() throws Exception {
        block4: {
            String context = this.driver.getContext();
            try {
                this.internalSwitchToNativeContext(this.driver);
                if (this.driver instanceof AndroidDriver) {
                    ((AndroidDriver)this.driver).pressKey(new KeyEvent(AndroidKey.BACK));
                    break block4;
                }
                KeywordMain.stepFailed((String)StringConstants.KW_MSG_UNSUPPORT_ACT_FOR_THIS_DEVICE, (FailureHandling)flowControl, null);
                return;
            }
            finally {
                this.driver.context(context);
            }
        }
    }

    public void switchToLandscape() throws Exception {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            this.driver.rotate(ScreenOrientation.LANDSCAPE);
        }
        finally {
            this.driver.context(context);
        }
    }

    public void switchToPortrait() throws Exception {
        String context = this.driver.getContext();
        try {
            this.internalSwitchToNativeContext(this.driver);
            this.driver.rotate(ScreenOrientation.PORTRAIT);
        }
        finally {
            this.driver.context(context);
        }
    }

    public void switchToWebView() throws Exception {
        boolean result = this.internalSwitchToWebViewContext(this.driver);
        if (result) {
            RunConfiguration.storeDriver(this.driver);
        } else {
            KeywordMain.stepFailed((String)StringConstants.KW_LOG_FAILED_SWITCH_WEB_VIEW, (FailureHandling)flowControl, null);
        }
    }

    public void switchToNative() throws Exception {
        boolean result = this.internalSwitchToNativeContext(this.driver);
        if (result) {
            RunConfiguration.storeDriver(this.driver);
        } else {
            KeywordMain.stepFailed((String)StringConstants.KW_LOG_FAILED_SWITCH_NATIVE, (FailureHandling)flowControl, null);
        }
    }

    public File takeScreenshot() throws Exception {
        File tempFile;
        block3: {
            tempFile = (File)this.driver.getScreenshotAs(OutputType.FILE);
            if (tempFile.exists()) break block3;
            KeywordMain.stepFailed((String)StringConstants.KW_MSG_UNABLE_TO_TAKE_SCREENSHOT, (FailureHandling)flowControl, null);
            return null;
        }
        return tempFile;
    }

    public String getKeys(ArgumentListExpressionWrapper arguments) {
        String keys = new String();
        boolean isSpecialKey = false;
        for (ExpressionWrapper expr : arguments.getExpressions()) {
            List children = expr.getAstChildren();
            boolean bl = isSpecialKey = children.size() > 0;
            if (isSpecialKey) {
                keys = String.valueOf(keys) + children.stream().map(child -> {
                    if (child instanceof ConstantExpressionWrapper) {
                        String keyName = ((ConstantExpressionWrapper)child).getValue().toString();
                        return Keys.valueOf((String)keyName).toString();
                    }
                    return "";
                }).collect(Collectors.joining());
                continue;
            }
            children = expr.getParent().getAstChildren();
            keys = String.valueOf(keys) + children.stream().map(child -> {
                if (child instanceof ConstantExpressionWrapper) {
                    return ((ConstantExpressionWrapper)child).getValue().toString();
                }
                return "";
            }).collect(Collectors.joining());
        }
        return keys;
    }

    public void sendKeys(TestObject to, String strokeKeys) throws Exception {
        KeywordHelper.checkTestObjectParameter((TestObject)to);
        WebElement element = this.findElement(to, 10000);
        if (element == null) {
            KeywordMain.stepFailed((String)MessageFormat.format(StringConstants.KW_MSG_OBJ_NOT_FOUND, to.getObjectId()), (FailureHandling)flowControl, null);
            return;
        }
        element.sendKeys(new CharSequence[]{strokeKeys});
    }
}

