/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverterV2;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MobileElementHelper {
    public int calculateHashValue(Object elementObj) {
        block6: {
            block5: {
                if (elementObj == null) {
                    return -1;
                }
                hashCodeBuilder = new HashCodeBuilder();
                if (!(elementObj instanceof MobileElement var3_4)) break block5;
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.putAll(mElement.getAttributes());
                attributes.entrySet().stream().sorted(Map.Entry.comparingByKey());
                for (Map.Entry attribute : attributes.entrySet()) {
                    String key = (String)attribute.getKey();
                    String val = (String)attribute.getValue();
                    if (!key.equalsIgnoreCase("xpath")) continue;
                    if (StringUtils.isBlank((String)val)) {
                        return -1;
                    }
                    hashCodeBuilder.append((Object)val);
                }
                break block6;
            }
            if (!(elementObj instanceof MobileElementEntity attributes)) break block6;
            ArrayList entityProperties = new ArrayList();
            entityProperties.addAll(entity.getWebElementProperties());
            Collections.sort(entityProperties, new Comparator<WebElementPropertyEntity>(){

                @Override
                public int compare(WebElementPropertyEntity o1, WebElementPropertyEntity o2) {
                    return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
                }
            });
            for (WebElementPropertyEntity webElementPropertyEntity : entityProperties) {
                String propertyName = webElementPropertyEntity.getName();
                String propertyValue = webElementPropertyEntity.getValue();
                if (!propertyName.equalsIgnoreCase("xpath")) continue;
                if (StringUtils.isBlank((String)propertyValue)) {
                    return -1;
                }
                hashCodeBuilder.append((Object)propertyValue);
            }
        }
        return hashCodeBuilder.toHashCode();
    }

    public void addConflictedMobileElement(CapturedMobileElement mobileElement, AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult dialogResult, List<ITreeEntity> newTreeEntities) throws Exception {
        FolderTreeEntity selectedParentFolder = dialogResult.getSelectedParentFolder();
        AddElementToObjectRepositoryDialogV2.ConflictOptions selectedConflictOption = dialogResult.getSelectedConflictOption();
        List<MobileElementEntity> allConflictedElementEntites = dialogResult.getAllConflictedElementEntities();
        CapturedMobileElement newMobileElement = (CapturedMobileElement)mobileElement.clone();
        String folderPath = String.valueOf(ProjectController.getInstance().getCurrentProject().getFolderLocation()) + File.separator + selectedParentFolder.getObject().getRelativePath();
        FolderEntity conflictedFolderEntity = FolderController.getInstance().getFolder(folderPath);
        if (mobileElement.isConflicted()) {
            String oldElementAbsolutePath = String.valueOf(folderPath) + File.separator + StringUtils.trim((String)newMobileElement.getName()) + MobileElementEntity.getWebElementFileExtension();
            MobileElementEntity objectAtDestinationFolder = (MobileElementEntity)ObjectRepositoryController.getInstance().getWebElement(oldElementAbsolutePath);
            MobileElementEntity oldMobileElementEntity = objectAtDestinationFolder == null ? allConflictedElementEntites.stream().filter(entity -> {
                int newElementAHash = this.calculateHashValue(newMobileElement);
                int entityAHash = this.calculateHashValue(entity);
                return this.isTheSameHashValue(newElementAHash, entityAHash);
            }).findFirst().get() : objectAtDestinationFolder;
            CapturedMobileElementConverterV2 converter = new CapturedMobileElementConverterV2();
            switch (selectedConflictOption) {
                case CREATE_NEW_OBJECT: {
                    newMobileElement.setName(ObjectRepositoryController.getInstance().getAvailableWebElementName(conflictedFolderEntity, StringUtils.trim((String)newMobileElement.getName())));
                    MobileElementEntity importedMobileElement = converter.convert(newMobileElement, conflictedFolderEntity);
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)importedMobileElement);
                    mobileElement.setScriptId(importedMobileElement.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)importedMobileElement, (ITreeEntity)selectedParentFolder));
                    break;
                }
                case REPLACE_EXISTING_OBJECT: {
                    oldMobileElementEntity.setWebElementProperties(converter.convertProperties(newMobileElement.getAttributes()));
                    oldMobileElementEntity.setLocator(newMobileElement.getLocator());
                    oldMobileElementEntity.setLocatorStrategy(newMobileElement.getLocatorStrategy());
                    oldMobileElementEntity.setName(newMobileElement.getName());
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)oldMobileElementEntity);
                    mobileElement.setScriptId(oldMobileElementEntity.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)oldMobileElementEntity, (ITreeEntity)selectedParentFolder));
                    break;
                }
                case MERGE_CHANGE_TO_EXISTING_OBJECT: {
                    List mergedProperties = oldMobileElementEntity.getWebElementProperties();
                    int numOldWebElementProperties = oldMobileElementEntity.getWebElementProperties().size();
                    List<WebElementPropertyEntity> newProperties = converter.convertProperties(newMobileElement.getAttributes());
                    for (WebElementPropertyEntity newMobileElementProperty : newProperties) {
                        boolean newPropertyUsed = false;
                        int i = 0;
                        while (i < numOldWebElementProperties) {
                            if (newMobileElementProperty.getName().equals(((WebElementPropertyEntity)mergedProperties.get(i)).getName())) {
                                mergedProperties.set(i, newMobileElementProperty);
                                newPropertyUsed = true;
                                break;
                            }
                            ++i;
                        }
                        if (newPropertyUsed) continue;
                        mergedProperties.add(newMobileElementProperty);
                    }
                    oldMobileElementEntity.setWebElementProperties(mergedProperties);
                    oldMobileElementEntity.setLocator(newMobileElement.getLocator());
                    oldMobileElementEntity.setLocatorStrategy(newMobileElement.getLocatorStrategy());
                    ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)oldMobileElementEntity);
                    mobileElement.setScriptId(oldMobileElementEntity.getIdForDisplay());
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)oldMobileElementEntity, (ITreeEntity)selectedParentFolder));
                    break;
                }
            }
        }
    }

    public boolean isTheSameHashValue(int objHash, int targetHash) {
        if (objHash == -1 || targetHash == -1) {
            return false;
        }
        return objHash == targetHash;
    }
}

