/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.util.groovy;

import com.kms.katalon.composer.util.groovy.ImportType;
import com.kms.katalon.composer.util.groovy.ImportsManager;
import com.kms.katalon.core.annotation.Keyword;
import com.kms.katalon.groovy.constant.GroovyConstants;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyCompilationHelper {
    private static String constructSimpleTypeStub(String typeName) {
        StringBuffer buf = new StringBuffer("public class ");
        buf.append(typeName);
        buf.append("{ }");
        return buf.toString();
    }

    private static String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cu, null, null, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)ASTProvider.SHARED_AST_LEVEL);
            parser.setProject(cu.getJavaProject());
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((pack.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer buf = new StringBuffer();
        if (!pack.isDefaultPackage()) {
            buf.append("package ").append(pack.getElementName()).append(';');
        }
        buf.append(lineDelimiter).append(lineDelimiter);
        buf.append(typeContent);
        return buf.toString();
    }

    private static CompilationUnit createASTForImports(ICompilationUnit cu) {
        ASTParser parser = ASTParser.newParser((int)ASTProvider.SHARED_AST_LEVEL);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        parser.setFocalPosition(0);
        return (CompilationUnit)parser.createAST(null);
    }

    private static Set<String> getExistingImports(CompilationUnit root) {
        List imports = root.imports();
        HashSet<String> res = new HashSet<String>(imports.size());
        int i = 0;
        while (i < imports.size()) {
            res.add(ASTNodes.asString((ASTNode)((ASTNode)imports.get(i))));
            ++i;
        }
        return res;
    }

    private static String constructTypeStub(String typeName, ICompilationUnit parentCU, ImportsManager imports, String lineDelimiter) throws CoreException {
        StringBuffer buf = new StringBuffer();
        int modifiers = 1;
        buf.append(Flags.toString((int)modifiers));
        if (modifiers != 0) {
            buf.append(' ');
        }
        String type = "class ";
        String templateID = "org.eclipse.jdt.ui.text.codetemplates.classbody";
        buf.append(type);
        buf.append(typeName);
        buf.append(" {").append(lineDelimiter);
        String typeBody = CodeGeneration.getTypeBody((String)templateID, (ICompilationUnit)parentCU, (String)typeName, (String)lineDelimiter);
        if (typeBody != null) {
            buf.append(typeBody);
        } else {
            buf.append(lineDelimiter);
        }
        buf.append('}').append(lineDelimiter);
        return buf.toString();
    }

    private static void removeUnusedImports(ICompilationUnit cu, Set<String> existingImports, boolean needsSave) throws CoreException {
        ASTParser parser = ASTParser.newParser((int)ASTProvider.SHARED_AST_LEVEL);
        parser.setSource(cu);
        parser.setResolveBindings(true);
        CompilationUnit root = (CompilationUnit)parser.createAST(null);
        if (root.getProblems().length == 0) {
            return;
        }
        List importsDecls = root.imports();
        if (importsDecls.isEmpty()) {
            return;
        }
        ImportsManager imports = new ImportsManager(root);
        int importsEnd = ASTNodes.getExclusiveEnd((ASTNode)((ASTNode)importsDecls.get(importsDecls.size() - 1)));
        IProblem[] problems = root.getProblems();
        int i = 0;
        while (i < problems.length) {
            int id;
            IProblem curr = problems[i];
            if (curr.getSourceEnd() < importsEnd && ((id = curr.getID()) == 268435844 || id == 0x1000003)) {
                int pos = curr.getSourceStart();
                int k = 0;
                while (k < importsDecls.size()) {
                    ImportDeclaration decl = (ImportDeclaration)importsDecls.get(k);
                    if (decl.getStartPosition() <= pos && pos < decl.getStartPosition() + decl.getLength()) {
                        if (!existingImports.isEmpty() && existingImports.contains(ASTNodes.asString((ASTNode)decl))) break;
                        String name = decl.getName().getFullyQualifiedName();
                        if (decl.isOnDemand()) {
                            name = String.valueOf(name) + ".*";
                        }
                        if (decl.isStatic()) {
                            imports.removeStaticImport(name);
                            break;
                        }
                        imports.removeImport(name);
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        imports.create(needsSave, null);
    }

    private static String getCompilationUnitName(String typeName) {
        return String.valueOf(typeName) + ".groovy";
    }

    private static ICompilationUnit createType(IPackageFragment parentPackage, String typeName, ImportType type) throws CoreException {
        ICompilationUnit connectedCU = null;
        try {
            ImportsManager imports = null;
            int indent = 0;
            String lineDelimiter = StubUtility.getLineDelimiterUsed((IJavaProject)parentPackage.getJavaProject());
            String cuName = String.valueOf(typeName) + ".groovy";
            ICompilationUnit parentCU = parentPackage.createCompilationUnit(cuName, "", false, null);
            boolean needsSave = true;
            parentCU.becomeWorkingCopy(null);
            connectedCU = parentCU;
            IBuffer buffer = parentCU.getBuffer();
            String simpleTypeStub = GroovyCompilationHelper.constructSimpleTypeStub(typeName);
            String cuContent = GroovyCompilationHelper.constructCUContent(parentCU, simpleTypeStub, lineDelimiter);
            buffer.setContents(cuContent);
            CompilationUnit astRoot = GroovyCompilationHelper.createASTForImports(parentCU);
            Set<String> existingImports = GroovyCompilationHelper.getExistingImports(astRoot);
            switch (type) {
                case SCRIPTS_IMPORTS: {
                    imports = GroovyCompilationHelper.addImports(parentPackage, typeName, astRoot);
                    break;
                }
                case KEYWORD_IMPORTS: {
                    imports = GroovyCompilationHelper.addImportsForCustomKeyword(parentPackage, typeName, astRoot);
                    break;
                }
                default: {
                    imports = new ImportsManager(astRoot);
                }
            }
            String typeContent = GroovyCompilationHelper.constructTypeStub(typeName, parentCU, imports, lineDelimiter);
            int index = cuContent.lastIndexOf(simpleTypeStub);
            if (index == -1) {
                AbstractTypeDeclaration typeNode = (AbstractTypeDeclaration)astRoot.types().get(0);
                int start = ((ASTNode)typeNode.modifiers().get(0)).getStartPosition();
                int end = typeNode.getStartPosition() + typeNode.getLength();
                buffer.replace(start, end - start, typeContent);
            } else {
                buffer.replace(index, simpleTypeStub.length(), typeContent);
            }
            IType createdType = parentCU.getType(typeName);
            ICompilationUnit cu = createdType.getCompilationUnit();
            imports.create(false, null);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            astRoot = GroovyCompilationHelper.createASTForImports(imports.getCompilationUnit());
            imports = new ImportsManager(astRoot);
            imports.create(false, null);
            GroovyCompilationHelper.removeUnusedImports(cu, existingImports, false);
            JavaModelUtil.reconcile((ICompilationUnit)cu);
            ISourceRange range = createdType.getSourceRange();
            IBuffer buf = cu.getBuffer();
            String originalContent = buf.getText(range.getOffset(), range.getLength());
            originalContent = GroovyCompilationHelper.addAliasImportByManual(originalContent, null, null);
            for (Map.Entry entry : GroovyConstants.DEFAULT_KEYWORD_CONTRIBUTOR_IMPORTS.entrySet()) {
                originalContent = GroovyCompilationHelper.addAliasImportByManual(originalContent, StringUtils.substringAfterLast((String)((String)entry.getValue()), (String)"."), (String)entry.getKey());
            }
            String formattedContent = CodeFormatterUtil.format((int)4, (String)originalContent, (int)indent, (String)lineDelimiter, (IJavaProject)parentPackage.getJavaProject());
            formattedContent = Strings.trimLeadingTabsAndSpaces((String)formattedContent);
            if (needsSave) {
                cu.commitWorkingCopy(true, null);
            }
        }
        finally {
            if (connectedCU != null) {
                connectedCU.discardWorkingCopy();
            }
        }
        return connectedCU;
    }

    private static ImportsManager addImports(IPackageFragment parentPackage, String typeName, CompilationUnit astRoot) {
        ImportsManager imports = new ImportsManager(astRoot);
        imports.addImport(JavaModelUtil.concatenateName((String)parentPackage.getElementName(), (String)typeName));
        String[] stringArray = GroovyConstants.getStartingClassesName();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            imports.addImport(className);
            ++n2;
        }
        for (Map.Entry entry : GroovyConstants.DEFAULT_STATIC_METHOD_IMPORTS.entrySet()) {
            imports.addStaticImport((String)entry.getValue(), (String)entry.getKey(), false);
        }
        return imports;
    }

    private static String addAliasImportByManual(String bodyScript, String qualifiedTypeName, String aliasName) {
        if (StringUtils.isBlank((String)qualifiedTypeName) || StringUtils.isBlank((String)aliasName)) {
            return "\r\n" + bodyScript;
        }
        return "import " + qualifiedTypeName + " as " + aliasName + "\r\n" + bodyScript;
    }

    private static ImportsManager addImportsForCustomKeyword(IPackageFragment parentPackage, String typeName, CompilationUnit astRoot) {
        ImportsManager imports = GroovyCompilationHelper.addImports(parentPackage, typeName, astRoot);
        imports.addImport(Keyword.class.getName());
        return imports;
    }

    public static ICompilationUnit createGroovyType(IPackageFragment parentPackage, String typeName) throws CoreException {
        return GroovyCompilationHelper.createGroovyType(parentPackage, typeName, true, ImportType.SCRIPTS_IMPORTS);
    }

    public static ICompilationUnit createGroovyType(IPackageFragment parentPackage, String typeName, boolean noClassDeclaration, ImportType importType) throws CoreException {
        GroovyCompilationHelper.createType(parentPackage, typeName, importType);
        GroovyCompilationUnit unit = (GroovyCompilationUnit)parentPackage.getCompilationUnit(GroovyCompilationHelper.getCompilationUnitName(typeName));
        try {
            ISourceRange range;
            int position;
            IImportDeclaration[] imports;
            ISourceRange range2;
            int position2;
            unit.becomeWorkingCopy(null);
            IPackageDeclaration[] packs = unit.getPackageDeclarations();
            char[] contents = unit.getContents();
            MultiTextEdit multi = new MultiTextEdit();
            if (packs.length > 0 && contents[position2 = (range2 = packs[0].getSourceRange()).getOffset() + range2.getLength()] == ';') {
                multi.addChild((TextEdit)new ReplaceEdit(position2, 1, ""));
            }
            if ((imports = unit.getImports()) != null && imports.length > 0 && contents[position = (range = imports[0].getSourceRange()).getOffset() + range.getLength() - 1] == ';') {
                multi.addChild((TextEdit)new ReplaceEdit(position, 1, ""));
            }
            if (noClassDeclaration) {
                ISourceRange range3 = unit.getTypes()[0].getSourceRange();
                multi.addChild((TextEdit)new DeleteEdit(range3.getOffset(), range3.getLength()));
            }
            if (multi.hasChildren()) {
                unit.applyTextEdit((TextEdit)multi, null);
                unit.commitWorkingCopy(true, null);
            }
        }
        finally {
            if (unit != null) {
                unit.discardWorkingCopy();
            }
        }
        return unit;
    }

    public static ICompilationUnit createGroovyTypeFromString(IPackageFragment parentPackage, String typeName, String content) throws CoreException {
        GroovyCompilationHelper.createType(parentPackage, typeName, ImportType.KEYWORD_IMPORTS);
        GroovyCompilationUnit unit = (GroovyCompilationUnit)parentPackage.getCompilationUnit(GroovyCompilationHelper.getCompilationUnitName(typeName));
        try {
            unit.becomeWorkingCopy(null);
            ISourceRange sourceRange = unit.getSourceRange();
            ReplaceEdit replaceEdit = new ReplaceEdit(0, sourceRange.getLength(), content);
            unit.applyTextEdit((TextEdit)replaceEdit, null);
            unit.commitWorkingCopy(true, null);
        }
        finally {
            if (unit != null) {
                unit.discardWorkingCopy();
            }
        }
        return unit;
    }
}

