package com.kms.katalon.core.appium.driver;

import java.net.URL;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.OkHttpClient;

import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;

public class CustomOkHttpClientFactory extends org.openqa.selenium.remote.internal.OkHttpClient.Builder {

    private Authenticator proxyAuthenticator;

    public CustomOkHttpClientFactory() {
        super();
    }

    public CustomOkHttpClientFactory(Authenticator proxyAuthenticator) {
        super();
        this.proxyAuthenticator = proxyAuthenticator;
    }

    @Override
    public HttpClient createClient(URL url) {
        okhttp3.OkHttpClient.Builder client = (new okhttp3.OkHttpClient.Builder()).proxy(this.proxy)
                .readTimeout(this.readTimeout.toMillis(), TimeUnit.MILLISECONDS)
                .connectTimeout(this.connectionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        String info = url.getUserInfo();
        if (StringUtils.isNotBlank(info)) {
            String[] parts = info.split(":", 2);
            String user = parts[0];
            String pass = parts.length > 1 ? parts[1] : null;
            String credentials = Credentials.basic(user, pass);
            client.authenticator((route, response) -> {
                return response.request().header("Authorization") != null ? null
                        : response.request().newBuilder().header("Authorization", credentials).build();
            });
        }

        client.addNetworkInterceptor((chain) -> {
            Request request = chain.request();
            Response response = chain.proceed(request);
            return response.code() == 408 ? response.newBuilder().code(500).message("Server-Side Timeout").build()
                    : response;
        });
        if (this.proxyAuthenticator != null) {
            client.proxyAuthenticator(this.proxyAuthenticator);
        }
        return new OkHttpClient(client.build(), url);
    }
}
