package com.kms.katalon.core.main;

import java.util.List;

import com.kms.katalon.core.context.internal.ExecutionEventManager;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;

public class RawTestBindingScriptExecutor extends TestCaseBindingExecutor {
    private String rawScript;

    protected TestResult testCaseResult;

    boolean doCleanUp = false;

    FailureHandling flowControl;

    public RawTestBindingScriptExecutor(String rawScript, String testCaseId, ScriptEngine scriptEngine,
            ExecutionEventManager eventManger, boolean doCleanUp, FailureHandling flowControl) {
        super(testCaseId, scriptEngine, eventManger);
        this.rawScript = rawScript;
        this.doCleanUp = doCleanUp;
        this.flowControl = flowControl;
    }

    @Override
    public TestResult accessTestCaseMainPhase(int index, TestCaseBinding tcBinding) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> coppiedErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();

        try {
            InternalTestCaseContext testCaseContext = new InternalTestCaseContext(tcBinding.getTestCaseId(), index);
            return new RawTestScriptExecutor(rawScript, tcBinding, scriptEngine, eventManger, testCaseContext,
                    doCleanUp).execute(flowControl);
        } finally {
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedErrors);
        }
    }
}
