package com.kms.katalon.core.testcase;

public class VariableReport extends Variable {

    private String displayReportName;

    private String value;

    public VariableReport( String value, String name) {
        this(value, name, false);
    }
    
    public VariableReport( String value, String name, boolean isMasked) {
        super.setName(name);
        super.setMasked(isMasked);
        this.value = value;

        if (name.length() > 15) {
            this.displayReportName = name.substring(0, 15) + "...";
        } else {
            this.displayReportName = name;
        }
    }

    public String getDisplayReportName() {
        return displayReportName;
    }

    public void setDisplayReportName(String displayReportName) {
        this.displayReportName = displayReportName;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

}
    