package com.kms.katalon.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.assertj.core.util.Arrays;

import com.kms.katalon.core.util.internal.JsonUtil;

public class JsonBuilder<RootType> {
    public interface ArrayBuilder {
        public void build(JsonBuilder<List<Object>> arrayBuilder);
    }

    public interface ObjectBuilder {
        public void build(JsonBuilder<Map<String, Object>> objectBuilder);
    }

    RootType root;

    public JsonBuilder() {
    }

    public JsonBuilder(RootType root) {
        this.root = root;
    }

    public static JsonBuilder<Map<String, Object>> object() {
        return fromObject(new HashMap<String, Object>());
    }

    public static JsonBuilder<List<Object>> array() {
        return fromArray(new ArrayList<Object>());
    }

    public static JsonBuilder<List<Object>> fromArray(List<Object> array) {
        return from(array);
    }

    public static JsonBuilder<Map<String, Object>> fromObject(Map<String, Object> object) {
        return from(object);
    }

    public static <RootType> JsonBuilder<RootType> from(RootType root) {
        return new JsonBuilder<RootType>(root);
    }

    @SuppressWarnings("unchecked")
    public JsonBuilder<RootType> property(String key, Object value) {
        if (root instanceof Map) {
            ((Map<String, Object>) root).put(key, value);
        }
        return this;
    }

    @SuppressWarnings("unchecked")
    public JsonBuilder<RootType> push(Object... items) {
        if (root instanceof List) {
            ((List<Object>) root).addAll(Arrays.asList(items));
        }
        return this;
    }

    public JsonBuilder<RootType> array(String key, Object... items) {
        return array(key, arrayBuilder -> {
            arrayBuilder.push(items);
        });
    }

    public JsonBuilder<RootType> array(String key, ArrayBuilder arrayProvider) {
        JsonBuilder<List<Object>> subArray = JsonBuilder.array();
        if (arrayProvider != null) {
            arrayProvider.build(subArray);
        }
        return property(key, subArray.root);
    }

    public JsonBuilder<RootType> object(String key, ObjectBuilder objectProvider) {
        JsonBuilder<Map<String, Object>> subObject = JsonBuilder.object();
        if (objectProvider != null) {
            objectProvider.build(subObject);
        }
        return property(key, subObject.root);
    }

    public RootType build() {
        return root;
    }

    public String toJson() {
        return JsonUtil.toJson(root, false);
    }
}
