package com.kms.katalon.core.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.util.NameUtil;

public class TestCloudPropertyUtil {
    
    private static TestCloudPropertyUtil _instance;
    
    public static final String TEST_CLOUD_KATALON_OPTION = "katalon:option";
    
    private static final String TC_RUN_FROM_TEST_CLOUD = "runFromTestCloud";
    
    private static final String SAUCE_LABS_DOC_LINK = "https://docs.saucelabs.com";
        
    private static final String REMOTE_DRIVER_PROPERTY = StringConstants.CONF_PROPERTY_REMOTE_DRIVER;
    
    private boolean isRunFromTestCloud = false;
    
    private static final Logger log = LoggerFactory.getLogger(TestCloudPropertyUtil.class);
    
    private TestCloudPropertyUtil() {
        // Private constructor
    }
    
    public static TestCloudPropertyUtil getInstance() {
        if (_instance == null) {
            _instance = new TestCloudPropertyUtil();
        }
        return _instance;
    }
    
    public boolean isRunFromTestCloud() {
        return isRunFromTestCloud;
    }

    public boolean isRunFromTestCloud(Capabilities desiredCapabilities) {
        Map<String, Object> katalonOptions = (Map<String, Object>) desiredCapabilities
                .getCapability(TEST_CLOUD_KATALON_OPTION);
        if (katalonOptions == null || katalonOptions.isEmpty()) {
            isRunFromTestCloud = false;
            return false;
        }
        boolean runFromTestCloud = (boolean) katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false);
        isRunFromTestCloud = runFromTestCloud;
        return runFromTestCloud;
    }

    public boolean isRunFromTestCloud(Map<String, Object> desiredCapabilities) {
        Map<String, Object> katalonOptions = (Map<String, Object>) desiredCapabilities.get(TEST_CLOUD_KATALON_OPTION);
        if (katalonOptions == null || katalonOptions.isEmpty()) {
            isRunFromTestCloud = false;
            return false;
        }
        boolean runFromTestCloud = (boolean) katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false);
        isRunFromTestCloud = runFromTestCloud;
        return runFromTestCloud;
    }

    public Map<String, Object> hideTestCloudSensitiveDesiredCapabilities(
            Map<String, Object> displayCapabilities) {
            for (Iterator<Entry<String, Object>> iterator = displayCapabilities.entrySet().iterator(); iterator.hasNext();) {
                Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object value = entry.getValue();
                if (containsKeys(key, "app", "lt:options", "LT:Options", "accessKey", "username",
                        "user", "apikey", "jwt", "secret")) {
                    iterator.remove();
                }
                if (value instanceof Map) {
                    Map<String, Object> subCap = (Map<String, Object>) value;
                    subCap = hideTestCloudSensitiveDesiredCapabilities(subCap);
                }
            }
            return displayCapabilities;
        }

    private boolean containsKeys(String searchKey, String...keys) {
        for (String key : keys) {
            if (searchKey.equals(key)) {
                return true;
            }
        }
        return false;
    }
    
    public void setRunFromTestCloud(Map<String, Object> desiredCapabilities) {
        Map<String, Object> katalonOptions = (Map<String, Object>) desiredCapabilities.get(TEST_CLOUD_KATALON_OPTION);
        if (katalonOptions == null || katalonOptions.isEmpty()) {
            isRunFromTestCloud = false;
        } else {
            isRunFromTestCloud = (boolean) katalonOptions.getOrDefault(TC_RUN_FROM_TEST_CLOUD, false);
        }
    }
    
    public boolean containsSensitiveName(String name) {
        return name.contains("lt://") || name.contains("storage:filename");
    }
    
    public String hideTestCloudSensitiveName(String name) {
        if (RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY) == null
                || RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY).isEmpty()) {
            return name;
        }
        
        if (!TestCloudPropertyUtil.getInstance()
                .isRunFromTestCloud(RunConfiguration.getDriverPreferencesProperties(REMOTE_DRIVER_PROPERTY))) {
            return name;
        }
        
        if (name.toLowerCase().contains("lt://")) {
            try {
                int beginIdx = name.indexOf("lt://");
                int lastIdx = name.lastIndexOf("\"");
                if (beginIdx != 0 && lastIdx != 0 && lastIdx > beginIdx) {
                    String sensitiveStr = name.substring(beginIdx, lastIdx);
                    String censor = NameUtil.censor(sensitiveStr, sensitiveStr.length());
                    name = name.replace(sensitiveStr, censor);
                }              
            } catch (Exception e) {
                log.error(e.getMessage());
            }           
        }
        
        if (name.toLowerCase().contains("storage:filename")) {
            try {
                int beginIdx = name.indexOf("storage:filename");
                int lastIdx = name.lastIndexOf("\"");
                if (beginIdx != 0 && lastIdx != 0 && lastIdx > beginIdx) {
                    String sensitiveStr = name.substring(beginIdx, lastIdx);
                    String censor = NameUtil.censor(sensitiveStr, sensitiveStr.length());
                    name = name.replace(sensitiveStr, censor);
                } 
            } catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        
        return name;
    }
    
    public String hideSauceLabsDocumentLink(String message) {
        if (!isRunFromTestCloud) {
            return message;
        }
        
        /* api ref: https://docs.saucelabs.com/dev/api/#accessing-the-apis */
        if (StringUtils.containsAny(message, "Sauce", "SauceLabs", "saucelabs", "sauce", "Sauce Labs RDC")) {
            message = NameUtil.censor(message, "Sauce Labs RDC", 4);
            message = NameUtil.censor(message, "SauceLabs", 3);
            message = NameUtil.censor(message, "Sauce", 3);
            message = NameUtil.censor(message, "saucelabs", 3);
            message = NameUtil.censor(message, "sauce", 3);
            message = NameUtil.censor(message, "api.us-west-1", 3);
            message = NameUtil.censor(message, "api.eu-central-1", 3);
            message = NameUtil.censor(message, "api.apac-southeast-1", 3);
            message = NameUtil.censor(message, "us-east-1", 3);
        }

        if (message.contains(SAUCE_LABS_DOC_LINK)) {
            message = NameUtil.censor(message, SAUCE_LABS_DOC_LINK, 3);
        }
        
        if (StringUtils.containsAny(message, "lambda", "lambdatest", "lambdaTest", "LambdaTest")) {
            message = NameUtil.censor(message, "lambdatest", 3);
            message = NameUtil.censor(message, "lambdaTest", 3);
            message = NameUtil.censor(message, "LambdaTest", 3);
            message = NameUtil.censor(message, "lambda", 3);
        }
        return message;
    }
    
    public void hideConfigurationData(Map<String, String> configurationData) {
        if (configurationData.containsKey("remoteWebDriverUrl")) {
            configurationData.remove("remoteWebDriverUrl");
        }
    }
}
