package com.kms.katalon.core.mobile.keyword.builtin

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.ios.IOSDriver

@Action(value = "closeApplication")
public class CloseApplicationKeyword extends MobileAbstractKeyword {


    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        closeApplication(flowControl)
    }

    @CompileStatic
    public void closeApplication(FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            String context = driver.getContext()
            try {
                internalSwitchToNativeContext(driver)
                String appId = null;
                if (driver instanceof AndroidDriver) {
                    appId = ((AndroidDriver)driver).getCurrentPackage();
                } else if (driver instanceof IOSDriver) {
                    Map<String, Object> out = (Map<String, Object>)((IOSDriver)driver).executeScript("mobile: activeAppInfo");
                    appId = out.get("bundleId");
                }
                if (!Objects.isNull(appId)) {
                    driver.terminateApp(appId);
                }
            } catch(Exception e) {
                logger.logInfo("Cannot close application! " + e.getMessage())
            } finally {
                driver.context(context)
            }

            MobileDriverFactory.closeDriver()
            logger.logPassed(StringConstants.KW_LOG_PASSED_CLOSE_APP)
        }, flowControl, false, StringConstants.KW_MSG_UNABLE_TO_CLOSE_APPLICATION)
    }
}
