package com.kms.katalon.core.mobile.keyword.builtin;

import org.apache.commons.lang3.StringUtils
import org.openqa.selenium.Dimension

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.MobileElement
import io.appium.java_client.TouchAction
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.android.connection.ConnectionStateBuilder
import io.appium.java_client.ios.IOSDriver
import io.appium.java_client.touch.TapOptions
import io.appium.java_client.touch.offset.ElementOption
import io.appium.java_client.touch.offset.PointOption


@Action(value = "toggleWifi")
public class ToggleWifiKeyWord extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String mode = params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        toggleWifi(mode, flowControl)
    }

    @CompileStatic
    public void toggleWifi(String mode, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver<?> driver = getAnyAppiumDriver()
            String context = driver.getContext()
            try {
                internalSwitchToNativeContext(driver)

                boolean isTurnOn = isTurnOn(mode)

                if (driver instanceof AndroidDriver) {
                    AndroidDriver androidDriver = (AndroidDriver) driver
                    androidDriver.setConnection(isTurnOn
                            ? new ConnectionStateBuilder().withWiFiEnabled().build()
                            : new ConnectionStateBuilder().withWiFiDisabled().build())
                } else {
                    IOSDriver iOSDriver = (IOSDriver) driver
                    Dimension size = driver.manage().window().getSize()

                    String deviceModel = MobileDriverFactory.getDeviceModel()
                    String deviceOSVersion = MobileDriverFactory.getDeviceOSVersion()
                    if (StringUtils.containsIgnoreCase(deviceModel, "simulator")) {
                        MobileKeywordMain.stepFailed(CoreMobileMessageConstants.KW_MSG_TOGGLE_WIFI_NOT_AVAILABLE, flowControl, null, true)
                        driver.context(context)
                        return
                    }

                    logger.logDebug("Device model: " + deviceModel)
                    logger.logDebug("Device version: " + deviceOSVersion)
                    boolean swipeUpToOpenControlCenter = true

                    if (MobileCommonHelper.getMajorVersion(deviceOSVersion) >= 12 &&
                            (MobileCommonHelper.isIPhoneXOrLater(deviceModel) || MobileCommonHelper.isIPad(deviceModel))) {
                        swipeUpToOpenControlCenter = false
                    }

                    /**
                     * https://support.apple.com/en-vn/HT202769#open
                     */
                    if (swipeUpToOpenControlCenter) {
                        logger.logDebug("Swipe up from the bottom middle of the screen")
                        MobileCommonHelper.swipe(iOSDriver,
                                (size.getWidth() / 2) as int,
                                size.getHeight(),
                                (size.getWidth() / 2) as int,
                                (size.getHeight() / 2) as int)
                    } else {
                        logger.logDebug("Swipe down from the upper-right corner of the screen")
                        MobileCommonHelper.swipe(iOSDriver,
                                size.getWidth(),
                                0,
                                size.getWidth(),
                                (size.getHeight() / 2) as int)
                    }

                    String wifiButtonName = "wifi-button"
                    MobileElement wifiButton = (MobileElement) MobileCommonHelper.findElementByIosClassChain(iOSDriver, "XCUIElementTypeSwitch", wifiButtonName)
                    if (wifiButton == null) {
                        MobileKeywordMain.stepFailed(CoreMobileMessageConstants.KW_MSG_COULD_NOT_FIND_TOGGLE_WIFI, flowControl, null, false)
                        driver.context(context)
                        return
                    }

                    boolean isEnabled = wifiButton.getAttribute("value") == "1"

                    if (isEnabled != isTurnOn) {
                        TouchAction touchWifiAction = new TouchAction(driver)
                                .tap(TapOptions.tapOptions().withElement(ElementOption.element(wifiButton)))
                                .release()
                        touchWifiAction.perform()

                        logger.logInfo("Wifi switched from " + getSwitchStatus(isEnabled) + " to " + getSwitchStatus(isTurnOn))
                    } else {
                        logger.logInfo("Wifi already switched to " + getSwitchStatus(isEnabled))
                    }

                    PointOption topScreenPoint = PointOption.point(0, 0)
                    TouchAction touchAtTopScreenAction = new TouchAction(driver)
                            .tap(TapOptions.tapOptions().withPosition(topScreenPoint))
                    touchAtTopScreenAction.release().perform()
                }

                logger.logPassed(CoreMobileMessageConstants.KW_LOG_PASSED_TOGGLE_WIFI)
            } finally {
                driver.context(context)
            }
        }, flowControl, true, CoreMobileMessageConstants.KW_MSG_CANNOT_TOGGLE_WIFI)
    }

    @CompileStatic
    boolean isTurnOn(String mode) {
        return StringUtils.equalsIgnoreCase("yes", mode)\
            || StringUtils.equalsIgnoreCase("on", mode)\
            || StringUtils.equalsIgnoreCase("true", mode)
    }

    @CompileStatic
    String getSwitchStatus(boolean status) {
        return status ? "ON" : "OFF"
    }
}
