package com.kms.katalon.core.mobile.keyword.builtin

import org.openqa.selenium.ScreenOrientation

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver

@Action(value = "verifyIsPortrait")
public class VerifyIsPortraitKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        return verifyIsPortrait(flowControl)
    }

    @CompileStatic
    public boolean verifyIsPortrait(FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            String context = driver.getContext()
            try {
                internalSwitchToNativeContext(driver)
                if (driver.getOrientation() == ScreenOrientation.PORTRAIT) {
                    logger.logPassed(StringConstants.KW_LOG_PASSED_VERIFY_PORTRAIT)
                    return true
                } else {
                    MobileKeywordMain.stepFailed(StringConstants.KW_LOG_FAILED_VERIFY_PORTRAIT, flowControl, null, true)
                    return false
                }
            } finally {
                driver.context(context)
            }
        }, flowControl, true, StringConstants.KW_MSG_UNABLE_VERIFY_PORTRAIT)
    }
}
