package com.kms.katalon.core.mobile.keyword.builtin

import groovy.transform.CompileStatic

import java.text.MessageFormat

import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.keyword.internal.AbstractKeyword
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.helper.KeywordHelper
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.mobile.constants.StringConstants

@Action(value = "waitForElementNotPresent")
public class WaitForElementNotPresentKeyword extends MobileAbstractKeyword {
    
    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeout = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        return waitForElementNotPresent(to, timeout, flowControl);
    }
    
    @CompileStatic
    public boolean waitForElementNotPresent(TestObject to, int timeout, FailureHandling flowControl) throws StepFailedException {
        return MobileKeywordMain.runKeyword({
            KeywordHelper.checkTestObjectParameter(to)
            timeout = KeywordHelper.checkTimeout(timeout)
            WebElement element = findElement(to, timeout * 1000)
            if (element == null) {
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_ELEMENT_NOT_PRESENTED, to.getObjectId()))
                return true
            } else {
                logger.logWarning(MessageFormat.format(StringConstants.KW_LOG_PASSED_ELEMENT_PRESENTED, to.getObjectId()))
                return false
            }
        }, flowControl, true, to != null ? MessageFormat.format(StringConstants.KW_MSG_FAILED_TO_WAIT_FOR_ELEMENT_X_NOT_PRESENT, to.getObjectId()) : StringConstants.KW_MSG_FAILED_TO_WAIT_FOR_ELEMENT_NOT_PRESENT)
    }
    
}
