/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.tracking.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.model.KatalonPackage;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.license.models.LicenseType;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.builder.TrackPropertyBuilder;
import com.kms.katalon.tracking.model.ProjectStatistics;
import com.kms.katalon.tracking.model.TestCaseTrackingInfo;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.model.TrackInfo;
import com.kms.katalon.tracking.osgi.service.IProjectStatisticsCollector;
import com.kms.katalon.tracking.osgi.service.ServiceConsumer;
import com.kms.katalon.tracking.service.TrackingService;
import com.kms.katalon.tracking.validation.adapter.IValidationService;
import com.kms.katalon.tracking.validation.adapter.ValidationServiceFactory;
import com.kms.katalon.util.SystemInformationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class Trackings {
    private static TrackingService trackingService = new TrackingService();

    public static void trackOpenApplication(boolean isAnonymous, String runningMode) throws Exception {
        double cpu = 0.0;
        long freePhysicalMemorySize = 0L;
        long totalPhysicalMemorySize = 0L;
        cpu = SystemInformationUtil.getProcessCpuLoad();
        long maxMemory = SystemInformationUtil.getMaxMemory();
        long usedMemory = SystemInformationUtil.getUsedMemory();
        long totalMemory = SystemInformationUtil.getTotalMemory();
        long freeMemory = SystemInformationUtil.getFreeMemory();
        double percentageUsed = SystemInformationUtil.getPercentageUsed();
        freePhysicalMemorySize = SystemInformationUtil.freePhysicalMemorySize();
        totalPhysicalMemorySize = SystemInformationUtil.totalPhysicalMemorySize();
        double percentageUsedFormatted = SystemInformationUtil.getPercentageUsedFormatted();
        Trackings.trackAction("openApplication", isAnonymous, "runningMode", runningMode, "percent_cpu", cpu, "max_memory", maxMemory, "used_memory", usedMemory, "total_memory", totalMemory, "free_memory", freeMemory, "percent_used", percentageUsed, "format_percent_used", percentageUsedFormatted, "freephysicalMemorySize", freePhysicalMemorySize, "totalphysicalMemorySize", totalPhysicalMemorySize);
    }

    public static void trackProjectStatistics(ProjectEntity project, boolean isAnonymous, String runningMode) {
        Trackings.trackUsageData(project, isAnonymous, runningMode, "collectStatistics");
    }

    public static void trackOpenProject(ProjectEntity project) {
        Executors.newFixedThreadPool(1).submit(() -> {
            Trackings.trackUsageData(project, false, "gui", "openProject");
            Trackings.trackOpenObject("project");
        });
    }

    private static void trackUsageData(ProjectEntity project, boolean isAnonymous, String runningMode, String triggeredBy) {
        if (project == null) {
            return;
        }
        try {
            JsonObject statisticsObject = Trackings.collectProjectStatistics(project);
            JsonObject properties = new JsonObject();
            properties.addProperty("triggeredBy", triggeredBy);
            properties.addProperty("runningMode", runningMode);
            KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
            properties.addProperty("katalonPackage", katalonPackage.getPackageName());
            LicenseType licenseType = ActivationInfoCollector.getLicenseType();
            properties.addProperty("licenseType", licenseType.name());
            JsonUtil.mergeJsonObject((JsonObject)statisticsObject, (JsonObject)properties);
            TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Studio Track").anonymous(isAnonymous).properties(properties);
            trackingService.track(trackInfo);
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
        }
    }

    private static JsonObject collectProjectStatistics(ProjectEntity project) throws Exception {
        IProjectStatisticsCollector collector = ServiceConsumer.getProjectStatisticsCollector();
        ProjectStatistics statistics = collector.collect(project);
        JsonObject statisticsObject = JsonUtil.toJsonObject((Object)statistics);
        return statisticsObject;
    }

    public static void trackOpenFirstTime() {
        TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Open First Time").anonymous(true);
        trackingService.track(trackInfo);
    }

    public static void trackSSOEvent(String event) {
        Trackings.trackSSOEvent(event, null);
    }

    public static void trackSSOEvent(String event, String details) {
        Trackings.trackUserAction("ksu_sso_event", "event_name", event, "details", details);
    }

    public static void trackLoginDialogAction(String action) {
        Trackings.trackUserAction("ksu_login_dialog_action", "action_id", action);
    }

    public static void trackQuickStartAction(String action) {
        Trackings.trackUserAction("quickStartAction", "userAction", action);
    }

    public static void trackQuickStartOpen() {
        Trackings.trackUserAction("ksu_quick_start_welcome_open", new Object[0]);
    }

    public static void trackQuickStartWelcome1(boolean newUser) {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue", "new_user", newUser);
    }

    public static void trackQuickStartWelcome2(String projectType, String yearsOfExperience, String testingMethodologies) {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue_2", "project_type", projectType, "years_of_experience", yearsOfExperience, "testing_methodologies", testingMethodologies);
    }

    public static void trackQuickStartWelcome3() {
        Trackings.trackUserAction("ksu_quick_start_welcome_continue_3", new Object[0]);
    }

    public static void trackQuickStartWelcomeCreateProject(String projectType) {
        Trackings.trackUserAction("ksu_quick_start_welcome_create_project", "project_type", projectType);
    }

    public static void trackGitLogin() {
        Trackings.trackUserAction("git_login_required", new Object[0]);
    }

    public static void trackOpenProjectSucceeded() {
        Trackings.trackUserAction("open_project_succeeded", new Object[0]);
    }

    public static void trackOpenProjectFailed() {
        Trackings.trackUserAction("open_project_failed", new Object[0]);
    }

    public static void trackQuickStartRecordOpen(String scenario) {
        Trackings.trackUserAction("ksu_quick_start_record_open", "option", scenario);
    }

    public static void trackQuickStartStartRecord(String browser, String scenario, boolean useDefaultBrowser) {
        Trackings.trackUserAction("ksu_quick_start_record_record", "browser", browser, "option", scenario, "useDefaultBrowser", useDefaultBrowser);
    }

    public static void trackQuickRecordSurveySend(String answer, String other) {
        Trackings.trackUserAction("ksu_quick_start_record_survey_send", "answer", answer, "other", other);
    }

    public static void trackQuickRecordSurveyClose() {
        Trackings.trackUserAction("ksu_quick_start_record_survey_close", new Object[0]);
    }

    public static void trackQuickStartGuidingDialog() {
        Trackings.trackUserAction("ksu_quick_start_record_guide", new Object[0]);
    }

    public static void trackQuickRecordLeave() {
        Trackings.trackUserAction("ksu_quick_start_record_leave", new Object[0]);
    }

    public static void trackQuickRecordContinue() {
        Trackings.trackUserAction("ksu_quick_start_record_continue", new Object[0]);
    }

    public static void trackQuickStartRunOpen() {
        Trackings.trackUserAction("ksu_quick_start_run_open", new Object[0]);
    }

    public static void trackQuickStartStartRun(String browser) {
        Trackings.trackUserAction("ksu_quick_start_run_run", "browser", browser);
    }

    public static void trackQuickStartRunPass() {
        Trackings.trackUserAction("ksu_quick_start_passed_run_open", new Object[0]);
    }

    public static void trackQuickStartRunFail() {
        Trackings.trackUserAction("ksu_quick_start_failed_run_open", new Object[0]);
    }

    public static void trackQuickStartWelcomeBack() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_open", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackOpenProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_open_project", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackCloneProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_clone_git", new Object[0]);
    }

    public static void trackQuickStartWelcomeBackNewProject() {
        Trackings.trackUserAction("ksu_quick_start_greeting_old_user_new_project", new Object[0]);
    }

    public static void trackTourAction(String tourName, String tourAction) {
        Trackings.trackUserAction("ksu_quickstart_tour_action", "tourName", tourName, "tourAction", tourAction);
    }

    public static void trackTourStep(String tourName, String tourStep) {
        Trackings.trackUserAction("ksu_quickstart_tour_step", "tourName", tourName, "tourStep", tourStep);
    }

    public static void trackWebSpy() {
        Trackings.trackUserAction("spyWeb", new Object[0]);
    }

    public static void trackMobileSpy(String deviceType, String appiumVersion) {
        Trackings.trackUserAction("spyMobile", "deviceType", deviceType, "appiumVersion", appiumVersion);
    }

    public static void trackWindowsSpy() {
        Trackings.trackUserAction("spyWindows", new Object[0]);
    }

    public static void trackWebRecord(String browserType, boolean useActiveBrowser, String webLocatorConfig) {
        Trackings.trackUserAction("recordWeb", "browserType", browserType, "active", useActiveBrowser, "webLocatorConfig", webLocatorConfig);
    }

    public static void trackMobileRecord(String deviceType, String appiumVersion) {
        Trackings.trackUserAction("recordMobile", "deviceType", deviceType, "appiumVersion", appiumVersion);
    }

    public static void trackWindowsRecord() {
        Trackings.trackUserAction("recordWindows", new Object[0]);
    }

    public static void trackWindowsNativeRecord() {
        Trackings.trackUserAction("recordWindowsNative", new Object[0]);
    }

    public static void trackNewTestCaseButtonClicked() {
        Trackings.trackUserAction("newTestCaseButtonClicked", new Object[0]);
    }

    public static void trackExecuteTestCase(TestCaseTrackingInfo testCaseTrackingInfo) {
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)testCaseTrackingInfo.getHealingInfo());
        List<Object> properties = TrackPropertyBuilder.create().addProperty("launchMode", testCaseTrackingInfo.getLaunchMode()).addProperty("driver", testCaseTrackingInfo.getDriverType()).addProperty("executionResult", testCaseTrackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(testCaseTrackingInfo.getDuration()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isTriggerSelfHealing()))).addProperty("execute_from_here", (String)((Object)Boolean.valueOf(testCaseTrackingInfo.isExecuteFromHere()))).addProperty("executed_keyword_types", (String)((Object)testCaseTrackingInfo.getKeywordsUsage())).addProperty("executed_applitools_keywords", (Map<String, Boolean>)testCaseTrackingInfo.isUsingApplitools()).addProperty("test_case_data_binding", (Map<String, Boolean>)testCaseTrackingInfo.isUseDataBinding()).build();
        if (hasAnySuccessfulSelfHealed) {
            properties.add((Map<String, Boolean>)((Object)"successful_self_healing"));
            properties.add(testCaseTrackingInfo.getHealingInfo());
        }
        Trackings.addTrackingAppiumVersionForExecuting(testCaseTrackingInfo, properties);
        Trackings.trackUserAction("executeTestCase", properties.toArray());
    }

    private static void addTrackingAppiumVersionForExecuting(TestEntityTrackingInfo info, List<Object> properties) {
        if (info.getAppiumVersion() != null) {
            properties.add("appiumVersion");
            properties.add(info.getAppiumVersion());
        }
    }

    public static void trackExecuteTestSuiteInGuiMode(TestSuiteTrackingInfo testSuiteTrackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "gui").addProperty("launchMode", testSuiteTrackingInfo.getLaunchMode()).addProperty("driver", testSuiteTrackingInfo.getDriverType()).addProperty("executionResult", testSuiteTrackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(testSuiteTrackingInfo.getDuration()))).addProperty("retryStrategy", testSuiteTrackingInfo.getRetryStrategy()).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isTriggerSelfHealing()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)testSuiteTrackingInfo.getOrgId())).addProperty("isInCollection", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isInCollection()))).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableVideo()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableHideHostname()))).addProperty("support_level", testSuiteTrackingInfo.getVideoRecordingLevel()).addProperty("num_test_steps", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumTestSteps()))).addProperty("executed_keyword_types", (String)((Object)testSuiteTrackingInfo.getKeywordsUsage())).addProperty("executed_applitools_keywords", (Map<String, Boolean>)testSuiteTrackingInfo.isUsingApplitools()).addProperty("dynamic_test_suite", (Map<String, Boolean>)testSuiteTrackingInfo.isDynamicTestSuite()).addProperty("testcloud_tunnel_enabled", (Map<String, Boolean>)testSuiteTrackingInfo.getIsTestCloudTunnelEnabled()).addProperty("number_of_emails_sent", (Map<String, Boolean>)testSuiteTrackingInfo.getNumberOfEmailsSent()).addProperty("test_case_data_binding", (Map<String, Boolean>)testSuiteTrackingInfo.isUseDataBinding()).addProperty("testcloud_run_configuration", (Map<String, Boolean>)((Object)testSuiteTrackingInfo.getTestCloudRunConfiguration())).addProperty("test_suite_collection_id", (Map<String, Boolean>)((Object)(testSuiteTrackingInfo.isInCollection() ? testSuiteTrackingInfo.getTestSuiteCollectionId() : ""))).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)testSuiteTrackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add((Map<String, Boolean>)((Object)"successful_self_healing"));
            properties.add((Map<String, Boolean>)((Object)testSuiteTrackingInfo.getHealingInfo()));
        }
        for (Map.Entry<String, Object> entry : testSuiteTrackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(testSuiteTrackingInfo, properties);
        Trackings.trackUserAction("executeTestSuite", properties.toArray());
    }

    public static void trackExecuteTestSuiteInConsoleMode(TestSuiteTrackingInfo testSuiteTrackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "console").addProperty("driver", testSuiteTrackingInfo.getDriverType()).addProperty("executionResult", testSuiteTrackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(testSuiteTrackingInfo.getDuration()))).addProperty("retryStrategy", testSuiteTrackingInfo.getRetryStrategy()).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isTriggerSelfHealing()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)testSuiteTrackingInfo.getOrgId())).addProperty("isInCollection", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isInCollection()))).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableVideo()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(testSuiteTrackingInfo.isEnableHideHostname()))).addProperty("support_level", testSuiteTrackingInfo.getVideoRecordingLevel()).addProperty("num_test_steps", (String)((Object)Integer.valueOf(testSuiteTrackingInfo.getNumTestSteps()))).addProperty("executed_keyword_types", (String)((Object)testSuiteTrackingInfo.getKeywordsUsage())).addProperty("maxFailedTest", (Map<String, Boolean>)testSuiteTrackingInfo.isUsedMaxFailedTestParam()).addProperty("executed_applitools_keywords", (Map<String, Boolean>)testSuiteTrackingInfo.isUsingApplitools()).addProperty("dynamic_test_suite", (Map<String, Boolean>)testSuiteTrackingInfo.isDynamicTestSuite()).addProperty("testcloud_tunnel_enabled", (Map<String, Boolean>)testSuiteTrackingInfo.getIsTestCloudTunnelEnabled()).addProperty("number_of_emails_sent", (Map<String, Boolean>)testSuiteTrackingInfo.getNumberOfEmailsSent()).addProperty("test_case_data_binding", (Map<String, Boolean>)testSuiteTrackingInfo.isUseDataBinding()).addProperty("testcloud_run_configuration", (Map<String, Boolean>)((Object)testSuiteTrackingInfo.getTestCloudRunConfiguration())).addProperty("test_suite_collection_id", (Map<String, Boolean>)((Object)(testSuiteTrackingInfo.isInCollection() ? testSuiteTrackingInfo.getTestSuiteCollectionId() : ""))).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)testSuiteTrackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add((Map<String, Boolean>)((Object)"successful_self_healing"));
            properties.add((Map<String, Boolean>)((Object)testSuiteTrackingInfo.getHealingInfo()));
        }
        for (Map.Entry<String, Object> entry : testSuiteTrackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(testSuiteTrackingInfo, properties);
        Trackings.trackAction("executeTestSuite", testSuiteTrackingInfo.isAnonymous(), properties.toArray());
    }

    public static void trackExecuteSequentialTestSuiteCollectionInGuiMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "gui").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Sequential").addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackUserAction("executeTestSuiteCollection", properties.toArray());
    }

    public static void trackExecuteParallelTestSuiteCollectionInGuiMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "gui").addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Parallel").addProperty("maxConcurrent", (String)((Object)Integer.valueOf(trackingInfo.getMaxConcurrentInstances()))).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackUserAction("executeTestSuiteCollection", properties.toArray());
    }

    public static void trackExecuteSequentialTestSuiteCollectionInConsoleMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "console").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Sequential").addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("maxFailedTest", (String)((Object)Boolean.valueOf(trackingInfo.isUsedMaxFailedTestParam()))).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackAction("executeTestSuiteCollection", trackingInfo.isAnonymous(), properties.toArray());
    }

    public static void trackExecuteParallelTestSuiteCollectionInConsoleMode(TestSuiteCollectionTrackingInfo trackingInfo) {
        List<Object> properties = TrackPropertyBuilder.create().addProperty("runningMode", "console").addProperty("total_test_suites", (String)((Object)Integer.valueOf(trackingInfo.getTotalRunTestSuite()))).addProperty("executionResult", trackingInfo.getResult()).addProperty("duration", (String)((Object)Long.valueOf(trackingInfo.getDuration()))).addProperty("executionMode", "Parallel").addProperty("maxConcurrent", (String)((Object)Integer.valueOf(trackingInfo.getMaxConcurrentInstances()))).addProperty("numberOfRerun", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfRetry()))).addProperty("enable_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isEnableSelfHealing()))).addProperty("trigger_self_healing", (String)((Object)Boolean.valueOf(trackingInfo.isTriggerSelfHealing()))).addProperty("enable_hide_hostname", (String)((Object)Boolean.valueOf(trackingInfo.isEnableHideHostname()))).addProperty("total_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getTotalTestCases()))).addProperty("passed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getPassedTestCases()))).addProperty("failed_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getFailedTestCases()))).addProperty("error_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getErrorTestCases()))).addProperty("skipped_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getSkippedTestCases()))).addProperty("incomplete_test_cases", (String)((Object)Integer.valueOf(trackingInfo.getIncompleteTestCases()))).addProperty("org_id", (String)((Object)trackingInfo.getOrgId())).addProperty("enable_screenshot", (String)((Object)Boolean.valueOf(trackingInfo.isEnableScreenshot()))).addProperty("enable_video", (String)((Object)Boolean.valueOf(trackingInfo.isEnableVideo()))).addProperty("support_level", trackingInfo.getVideoRecordingLevel()).addProperty("maxFailedTest", (String)((Object)Boolean.valueOf(trackingInfo.isUsedMaxFailedTestParam()))).addProperty("number_of_emails_sent", (String)((Object)Integer.valueOf(trackingInfo.getNumberOfEmailsSent()))).addProperty("test_suite_collection_id", trackingInfo.getTestSuiteCollectionId()).build();
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)trackingInfo.getHealingInfo());
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(trackingInfo.getHealingInfo());
        }
        for (Map.Entry<String, Object> entry : trackingInfo.getAdditionalProps().entrySet()) {
            properties.add(entry.getKey());
            properties.add(String.valueOf(entry.getValue()));
        }
        Trackings.addTrackingAppiumVersionForExecuting(trackingInfo, properties);
        Trackings.trackAction("executeTestSuiteCollection", trackingInfo.isAnonymous(), properties.toArray());
    }

    public static void trackExecuteFeatureFile(String launchMode, String driverType, String result, long duration, boolean isEnableSelfHealing, boolean isTriggerSelfHealing, String healingInfo, Map<String, Boolean> keywordsUsage) {
        boolean hasAnySuccessfulSelfHealed = StringUtils.isNotBlank((CharSequence)healingInfo);
        ArrayList<Object> properties = new ArrayList<Object>(Arrays.asList("launchMode", launchMode, "driver", driverType, "executionResult", result, "duration", duration, "enable_self_healing", isEnableSelfHealing, "trigger_self_healing", isTriggerSelfHealing, "executed_keyword_types", keywordsUsage));
        if (hasAnySuccessfulSelfHealed) {
            properties.add("successful_self_healing");
            properties.add(healingInfo);
        }
        Trackings.trackUserAction("executeFeatureFile", properties.toArray());
    }

    public static void trackGenerateCmd() {
        Trackings.trackUserAction("generateCmd", new Object[0]);
    }

    public static void trackQuickOverview(String userClick) {
        Trackings.trackUserAction("quickOverview", "userClick", userClick);
    }

    public static void trackCreatingObject(String objectType) {
        String action = "new" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackCreatingProject(String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType, String newProjectId, ProjectType newProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType, "newProjectId", newProjectId, "newProjectType", newProjectType.toString());
    }

    public static void trackCreatingSampleProject(String sampleProjectType) {
        Trackings.trackUserAction("newProject", "sampleProjectType", sampleProjectType);
    }

    public static void trackOpenDraftRequest(String webServiceType, String openBy) {
        Trackings.trackUserAction("openDraftRequest", "requestType", webServiceType, "openBy", openBy);
    }

    public static void trackOpenObject(String objectType) {
        String action = "open" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackOpenTestCase(String defaultOpenView) {
        Trackings.trackUserAction("openTestCase", "defaultOpenView", defaultOpenView);
    }

    public static void trackOpenSetDefaultTestCaseView() {
        Trackings.trackOpenObject("SetDefaultTestCaseViewFromTestCase");
    }

    public static void trackSaveObject(String objectType) {
        String action = "save" + StringUtils.capitalize((String)objectType);
        Trackings.trackUserAction(action, new Object[0]);
    }

    public static void trackEditObject(String objectName, String objectType) {
        String action = "edit" + StringUtils.capitalize((String)objectName);
        if (StringUtils.isNotBlank((CharSequence)objectType)) {
            Trackings.trackUserAction(action, "objectType", objectType);
        } else {
            Trackings.trackUserAction(action, new Object[0]);
        }
    }

    public static void trackOpenHelp(String url) {
        Trackings.trackUserAction("openHelp", "url", url);
    }

    public static void trackOpenWebSpy() {
        Trackings.trackUserAction("openWebSpy", new Object[0]);
    }

    public static void trackOpenMobileSpy(String deviceType, String appiumVersion) {
        Trackings.trackUserAction("openMobileSpy", "deviceType", deviceType, "appiumVersion", appiumVersion);
    }

    public static void trackOpenWindowsSpy() {
        Trackings.trackUserAction("openWindowsSpy", new Object[0]);
    }

    public static void trackSaveWebSpy(int numberOfSavedObjects) {
        Trackings.trackUserAction("saveWebSpy", "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackSaveWebSpy(int capturedObjectsNumber, int savedObjectsNumber, int duplicatedObjectsNumber, int duplicatedByObjectsID, int duplicatedByHashedAttributes, String chosenConflictOption, String capturedBy) {
        Trackings.trackUserAction("save_captured_web_object", "capturedObjectsNumber", capturedObjectsNumber, "savedObjectsNumber", savedObjectsNumber, "duplicatedObjectsNumber", duplicatedObjectsNumber, "duplicatedByObjectsID", duplicatedByObjectsID, "duplicatedByHashedAttributes", duplicatedByHashedAttributes, "chosenConflictOption", chosenConflictOption, "capturedBy", capturedBy);
    }

    public static void trackSaveMobileSpy(String deviceType, int numberOfSavedObjects) {
        Trackings.trackUserAction("saveMobileSpy", "deviceType", deviceType, "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackSaveWindowsSpy(int numberOfSavedObjects) {
        Trackings.trackUserAction("saveWindowsSpy", "numberOfSavedObjects", numberOfSavedObjects);
    }

    public static void trackCloseWebSpy() {
        Trackings.trackUserAction("closeWebSpy", new Object[0]);
    }

    public static void trackCloseMobileSpy(String deviceType) {
        Trackings.trackUserAction("closeMobileSpy", "deviceType", deviceType);
    }

    public static void trackCloseWindowsSpy(boolean isCancelled) {
        Trackings.trackUserAction("closeWindowsSpy", "isCancelled", isCancelled);
    }

    public static void trackOpenWebRecord(boolean continueRecording, String webLocatorConfig) {
        Trackings.trackUserAction("openWebRecord", "continue", continueRecording, "webLocatorConfig", webLocatorConfig);
    }

    public static void trackWebRecordStepByContextMenu(String keyword) {
        Trackings.trackUserAction("recordStepByContextMenu", "keyword", keyword);
    }

    public static void trackOpenMobileRecord(String deviceType, String appiumVersion) {
        Trackings.trackUserAction("openMobileRecord", "deviceType", deviceType, "appiumVersion", appiumVersion);
    }

    public static void trackOpenWindowsRecord() {
        Trackings.trackUserAction("openWindowsRecord", new Object[0]);
    }

    public static void trackOpenWindowsNativeRecord() {
        Trackings.trackUserAction("openWindowsNativeRecord", new Object[0]);
    }

    public static void trackOpenSelfHealingInsights() {
        Trackings.trackUserAction("openSelfHealingInsights", new Object[0]);
    }

    public static void trackApproveSelfHealingTestObjects(String approvedProposals) {
        Trackings.trackUserAction("approveSelfHealingProposals", "approvedProposals", approvedProposals);
    }

    public static void trackDiscardSelfHealingTestObjects(String discardedProposals) {
        Trackings.trackUserAction("discardSelfHealingProposals", "discardedProposals", discardedProposals);
    }

    public static void trackClickOnSelfHealingInsightsConfigure() {
        Trackings.trackUserAction("ksu_self_healing_insights_configure_click", new Object[0]);
    }

    public static void trackClickOnSelfHealingInsightsHelp() {
        Trackings.trackUserAction("ksu_self_healing_insights_help_click", new Object[0]);
    }

    public static void trackCloseWebRecordByOk(int numberOfTestSteps, String webLocatorConfig) {
        Trackings.trackUserAction("closeWebRecord", "isCancelled", false, "numberOfTestSteps", String.valueOf(numberOfTestSteps), "webLocatorConfig", webLocatorConfig);
    }

    public static void trackCloseWebRecordByCancel(String webLocatorConfig) {
        Trackings.trackUserAction("closeWebRecord", "isCancelled", true, "webLocatorConfig", webLocatorConfig);
    }

    public static void trackCloseMobileRecordByOk(String deviceType, int numberOfTestSteps) {
        Trackings.trackUserAction("closeMobileRecord", "deviceType", deviceType, "isCancelled", false, "numberOfTestSteps", numberOfTestSteps);
    }

    public static void trackCloseMobileRecordByCancel(String deviceType) {
        Trackings.trackUserAction("closeMobileRecord", "deviceType", deviceType, "isCancelled", true);
    }

    public static void trackCloseWindowsRecordByOk(int numberOfRecordedSteps) {
        Trackings.trackUserAction("closeWindowsRecord", "isCancelled", false, "numberOfRecordedSteps", numberOfRecordedSteps);
    }

    public static void trackCloseWindowsRecordByCancel() {
        Trackings.trackUserAction("closeWindowsRecord", "isCancelled", true);
    }

    public static void trackCloseWindowsNativeRecordByOk(int numberOfRecordedSteps) {
        Trackings.trackUserAction("closeWindowsNativeRecord", "isCancelled", false, "numberOfRecordedSteps", numberOfRecordedSteps);
    }

    public static void trackCloseWindowsNativeRecordByCancel() {
        Trackings.trackUserAction("closeWindowsNativeRecord", "isCancelled", true);
    }

    public static void trackWebRecordRunSteps(String type) {
        Trackings.trackUserAction("recordRunSteps", "type", type);
    }

    public static void trackImportKeywords(String type) {
        Trackings.trackUserAction("importKeywords", "type", type);
    }

    public static void trackExportKeywords() {
        Trackings.trackUserAction("exportKeywords", new Object[0]);
    }

    public static void trackForumSearch(String keyword) {
        Trackings.trackUserAction("forumSearch", "keyword", keyword);
    }

    public static void trackQuickDiscussion() {
        Trackings.trackUserAction("quickDiscussion", new Object[0]);
    }

    public static void trackOpenKAIntegration(String objectType) {
        Trackings.trackUserAction("openKAIntegration", "type", objectType);
    }

    public static void trackAddNewTestStep(String stepType) {
        Trackings.trackUserAction("newTestStep", "type", stepType);
    }

    public static void trackTestWebServiceObject(boolean withVerification, boolean isDraftRequest, String authorizationType, boolean isValidatedJsonAganistSchema, boolean isValidatedXMLAganistSchema, boolean isValidatedGraphQLAganistSchema, String requestType) {
        Trackings.trackUserAction("testWebServiceObject", "verify", withVerification, "isDraft", isDraftRequest, "authorization_type", authorizationType, "validated_json_against_schema", isValidatedJsonAganistSchema, "validated_xml_against_schema", isValidatedXMLAganistSchema, "validated_graphql_request_against_schema", isValidatedGraphQLAganistSchema, "request_type", requestType);
    }

    public static void trackAddApiVariable() {
        Trackings.trackUserAction("addApiVariable", new Object[0]);
    }

    public static void trackOpenImportingSwagger() {
        Trackings.trackUserAction("openImportingSwagger", new Object[0]);
    }

    public static void trackClickTestCloudConfiguration() {
        Trackings.trackUserAction("ksu_click_testcloud_configuration", new Object[0]);
    }

    public static void trackClickExecuteTestSuiteWithTestCloud() {
        Trackings.trackUserAction("ksu_click_execute_test_suite_by_testcloud", new Object[0]);
    }

    public static void trackClickExecuteTestSuiteCollectionWithTestCloud() {
        Trackings.trackUserAction("ksu_click_execute_test_suite_collection_by_testcloud", new Object[0]);
    }

    public static void trackOpenImportingPostman() {
        Trackings.trackUserAction("openImportingPostman", new Object[0]);
    }

    public static void trackOpenImportingWsdl() {
        Trackings.trackUserAction("openImportingWSDL", new Object[0]);
    }

    public static void trackImportSwagger(String importType) {
        Trackings.trackUserAction("importSwagger", "type", importType);
    }

    public static void trackImportPostman(String importType) {
        Trackings.trackUserAction("importPostman", "type", importType);
    }

    public static void trackImportWSDL(String importType) {
        Trackings.trackUserAction("importWSDL", "type", importType);
    }

    public static void trackImportOpenApi3(String importType) {
        Trackings.trackUserAction("importOpenApi3", "type", importType);
    }

    public static void trackImportSoapUI(String importType) {
        Trackings.trackUserAction("importSoapUI", "type", importType);
    }

    public static void trackClickSavingDraftRequest() {
        Trackings.trackUserAction("clickSavingDraftRequest", new Object[0]);
    }

    public static void trackSaveDraftRequest() {
        Trackings.trackUserAction("saveDraftRequest", new Object[0]);
    }

    public static void trackClickDeletingDraftRequest() {
        Trackings.trackUserAction("clickDeletingDraftRequest", new Object[0]);
    }

    public static void trackDeleteDraftRequest(int numberOfDeletedRequests) {
        Trackings.trackUserAction("deleteDraftRequest", "deletedRequestCount", numberOfDeletedRequests);
    }

    public static void trackClickAddingRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("clickAddingRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackAddRequestToTestCase(boolean addToNewTestCase) {
        Trackings.trackUserAction("addRequestToTestCase", "addType", addToNewTestCase ? "new" : "existing");
    }

    public static void trackOpenTwitterDialog() {
        Trackings.trackUserAction("openTwitterDialog", new Object[0]);
    }

    public static void trackUserResponseForTwitterDialog(String option) {
        Trackings.trackUserAction("responseTwitterDialog", "type", option);
    }

    public static void trackOpenLinkedJiraIssuesDialog() {
        Trackings.trackUserAction("openLinkedJiraIssuesDialog", new Object[0]);
    }

    public static void trackClickCreateNewJiraIssue() {
        Trackings.trackUserAction("clickCreateNewJiraIssue", new Object[0]);
    }

    public static void trackClickCreateJiraSubIssue() {
        Trackings.trackUserAction("clickCreateSubJiraIssue", new Object[0]);
    }

    public static void trackClickLinkToExistingJiraIssue() {
        Trackings.trackUserAction("clickLinkToExistingJiraIssue", new Object[0]);
    }

    public static void trackClickHarLink() {
        Trackings.trackUserAction("clickHarLink", new Object[0]);
    }

    public static void trackInAppSurveyRatingAndIdea(int numberOfStars, String userIdea) {
        Trackings.trackUserAction("katalonStudioSurvey", "star", numberOfStars, "content", userIdea);
    }

    public static void trackInAppSurveyWillContinueToUse(boolean willContinueToUse, String quitUsingReason) {
        Trackings.trackUserAction("willContinueToUseSurvey", "willContinueToUse", willContinueToUse, "quitUsingReason", quitUsingReason);
    }

    public static void trackQuitSurvey2Open() {
        Trackings.trackUserAction("quit_survey_version_2_opened", new Object[0]);
    }

    public static void trackQuitSurvey2Action(String action) {
        Trackings.trackUserAction("quit_survey_version_2_clicked", "userAction", action);
    }

    public static void trackQuitSurvey2Close() {
        Trackings.trackUserAction("quit_survey_version_2_close", new Object[0]);
    }

    public static void trackQuitSurvey2SendAnswer(String answer, String comment) {
        Trackings.trackUserAction("quit_survey_version_2_send", "answer", answer, "comment", comment);
    }

    public static void trackClickWalkthroughDialogLink(String dialogId, String linkName, String link) {
        Trackings.trackUserAction("clickWalkthroughLink", "dialogId", dialogId, "linkName", linkName, "link", link);
    }

    public static void trackClickWalkthroughIgnoreButton(String dialogId) {
        Trackings.trackUserAction("clickWalkthroughIgnoreButton", "dialogId", dialogId);
    }

    public static void trackDownloadPlugin(String apiKey, long pluginId, String pluginName, String pluginVersion, RunningMode runningMode) {
        apiKey = StringUtils.isNotBlank((CharSequence)apiKey) ? apiKey : "";
        Trackings.trackUserAction("downloadPlugin", "apiKey", apiKey, "pluginId", pluginId, "pluginName", pluginName, "pluginVersion", pluginVersion, "runningMode", runningMode.toString());
    }

    public static void trackInstallPlugins(List<Long> installedPluginIds, String apiKey, RunningMode runningMode) {
        Trackings.trackUserAction("installPlugins", "pluginIdList", JsonUtil.toJson(installedPluginIds), "apiKey", StringUtils.isNotBlank((CharSequence)apiKey) ? apiKey : "", "runningMode", runningMode.toString());
    }

    public static void trackUsePrivatePlugins(int customKeywordPluginCount, int idePluginCount) {
        Trackings.trackUserAction("usePrivatePlugin", "customKeywordPluginsCount", customKeywordPluginCount, "idePluginsCount", idePluginCount);
    }

    public static void trackOpenExportTestArtifactsDialog() {
        Trackings.trackUserAction("openExportTestArtifactsDialog", new Object[0]);
    }

    public static void trackOpenImportTestArtifactsDialog() {
        Trackings.trackUserAction("openImportTestArtifactsDialog", new Object[0]);
    }

    public static void trackOpenConsoleView() {
        Trackings.trackUserAction("openConsoleView", new Object[0]);
    }

    public static void trackGitOperation(String operationName, String protocol) {
        Trackings.trackUserAction("performGitOperation", "operationName", operationName, "protocol", protocol);
    }

    public static void trackUseSourceCodeForDebugging(String className) {
        Trackings.trackUserAction("useSourceCodeForDebugging", "className", className);
    }

    public static void trackUseDatabaseConnectionForEnterpriseAccount(String dataSourceType) {
        Trackings.trackUserAction("useDatabaseConnectionForEnterpriseAccount", "type", dataSourceType);
    }

    public static void trackUseAdditionalTestDataSource() {
        Trackings.trackUserAction("useAdditionalTestDataSource", new Object[0]);
    }

    public static void trackUnauthorizedAccessOfKSEFeatures(KSEFeature feature) {
        Trackings.trackUserAction("unauthorizedAccessKSEFeature", "featureKey", feature.toString());
    }

    public static void trackOpenKSEBrochurePage() {
        Trackings.trackUserAction("openKSEBrochurePage", new Object[0]);
    }

    public static void trackFailedToSpyRecordDueToOutdatedChromeDriver() {
        Trackings.trackUserAction("failedToSpyRecordDueToOutdatedChromeDriver", new Object[0]);
    }

    public static void trackFailedToSpyRecordDueToOutdatedEdgeChromiumDriver() {
        Trackings.trackUserAction("failedToSpyRecordDueToOutdatedEdgeChromiumDriver", new Object[0]);
    }

    public static void trackUseAutoUpdateChromeDriver() {
        Trackings.trackUserAction("autoUpdateChromeDriver", new Object[0]);
    }

    public static void trackUseAutoUpdateEdgeChromiumDriver() {
        Trackings.trackUserAction("autoUpdateEdgeChromiumDriver", new Object[0]);
    }

    public static void trackClickOnExceptionDocInLogViewer(String link) {
        Trackings.trackUserAction("clickOnExceptionLinkInLogViewer", "link", link);
    }

    public static void trackTroubleshootFailedActivation(String email, String errorMessage) {
        Trackings.trackAction("troubleshoot-failed-activation", true, "email", email, "errorMessage", errorMessage);
    }

    public static void trackOpenDecompilerEditor() {
        Trackings.trackUserAction("open_decompiler_editor", new Object[0]);
    }

    public static void trackClickUseDefaultClassFileEditor() {
        Trackings.trackUserAction("click_use_default_class_file_editor", new Object[0]);
    }

    public static void trackClassFileEditorChanged(String classFileEditor, String classFileNoSourceEditor) {
        Trackings.trackUserAction("change_class_file_editor", "classFileEditor", classFileEditor, "classFileNoSourceEditor", classFileNoSourceEditor);
    }

    public static void trackStudioAssistFeedback(int numStars, String feedback) {
        Trackings.trackUserAction("studioassist_feedback", "num_of_stars", numStars, "feedback_text", feedback);
    }

    public static void trackStudioAssistUsage(String property) {
        Trackings.trackUserAction("ksu_click_studioassist", "studioassist_action", property);
    }

    private static void trackUserAction(String actionName, Object ... properties) {
        Trackings.trackAction(actionName, false, properties);
    }

    private static void trackAction(String actionName, boolean isAnonymous, Object ... properties) {
        JsonObject propertiesObject = new JsonObject();
        propertiesObject.addProperty("action", actionName);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            propertiesObject.addProperty("projectId", currentProject.getUUID());
            propertiesObject.addProperty("projectType", currentProject.getType().toString());
        }
        KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
        propertiesObject.addProperty("katalonPackage", katalonPackage.getPackageName());
        LicenseType licenseType = ActivationInfoCollector.getLicenseType();
        if (licenseType != null) {
            propertiesObject.addProperty("licenseType", licenseType.name());
        }
        if (properties != null) {
            JsonUtil.mergeJsonObject((JsonObject)Trackings.createJsonObject(properties), (JsonObject)propertiesObject);
        }
        TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Studio Used").anonymous(isAnonymous).properties(propertiesObject);
        IValidationService service = ValidationServiceFactory.getInstance().getValidationService();
        if (service != null) {
            try {
                service.insertEventIntoDatabaseUseCase(actionName, properties);
                service.triggerSurveysAndGetUserResponseEvents(actionName).forEach((n, p) -> Trackings.trackActionForValidationMechanism(n, p));
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
        trackingService.track(trackInfo);
    }

    private static void trackActionForValidationMechanism(String actionName, Object[] properties) {
        JsonObject propertiesObject = new JsonObject();
        propertiesObject.addProperty("action", actionName);
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        if (currentProject != null) {
            propertiesObject.addProperty("projectId", currentProject.getUUID());
            propertiesObject.addProperty("projectType", currentProject.getType().toString());
        }
        KatalonPackage katalonPackage = KatalonApplication.getKatalonPackage();
        propertiesObject.addProperty("katalonPackage", katalonPackage.getPackageName());
        LicenseType licenseType = ActivationInfoCollector.getLicenseType();
        if (licenseType != null) {
            propertiesObject.addProperty("licenseType", licenseType.name());
        }
        if (properties != null) {
            JsonUtil.mergeJsonObject((JsonObject)Trackings.createJsonObject(properties), (JsonObject)propertiesObject);
        }
        TrackInfo trackInfo = TrackInfo.create().eventName("Katalon Studio Used").anonymous(false).properties(propertiesObject);
        trackingService.track(trackInfo);
    }

    private static JsonObject createJsonObject(Object ... properties) {
        JsonObject jsonObject = new JsonObject();
        if (properties != null) {
            int i = 0;
            while (i < properties.length - 1) {
                String key = (String)properties[i];
                Object value = properties[i + 1];
                if (value instanceof Character) {
                    jsonObject.addProperty(key, (Character)value);
                } else if (value instanceof String) {
                    jsonObject.addProperty(key, (String)value);
                } else if (value instanceof Number) {
                    jsonObject.addProperty(key, (Number)value);
                } else if (value instanceof Boolean) {
                    jsonObject.addProperty(key, (Boolean)value);
                } else if (value instanceof Map) {
                    ArrayList mapAsProperties = new ArrayList();
                    Map valueAsMap = (Map)value;
                    valueAsMap.forEach((keyI, valueI) -> {
                        mapAsProperties.add(keyI);
                        mapAsProperties.add(valueI);
                    });
                    jsonObject.add(key, (JsonElement)Trackings.createJsonObject(mapAsProperties.toArray()));
                }
                i += 2;
            }
        }
        return jsonObject;
    }

    public static void trackClickOnTrialNotification(String message) {
        Trackings.trackUserAction("clickOnTrialNotification", "message", message);
    }

    public static void trackClickOnTrialNotificationButton() {
        Trackings.trackUserAction("clickOnTrialNotificationButton", new Object[0]);
    }

    public static void trackTriggerFixingBrokenTestObjectFromLogViewer() {
        Trackings.trackUserAction("fixBrokenTO_triggeredFromLogViewer", new Object[0]);
    }

    public static void trackTriggerFixingBrokenTestObjectFromReport() {
        Trackings.trackUserAction("fixBrokenTO_triggeredFromReport", new Object[0]);
    }

    public static void trackUsedSpyToFixBrokenTestObject() {
        Trackings.trackUserAction("fixBrokenTO_usingSpyToFixBrokenTestObject", new Object[0]);
    }

    public static void trackCaptureObjectWhenFixingBrokenTestObject() {
        Trackings.trackUserAction("fixBrokenTO_capturedObject", new Object[0]);
    }

    public static void trackUserCancelSaveObjectToRepositoryWhenFixingBrokenTestObjects() {
        Trackings.trackUserAction("fixBrokenTO_cancelSavingToObjectRepository", new Object[0]);
    }

    public static void trackUserSavedObjectToRepositoryWhenFixingBrokenTestObjects() {
        Trackings.trackUserAction("fixBrokenTO_savedToObjectRepository", new Object[0]);
    }

    public static void trackUsersFailedToFixBrokenTestObjectsFeedback(String userAnswer, String userChoiceText) {
        Trackings.trackUserAction("fixBrokenTO_failureSurvey", "userAnswer", userAnswer, "userChoiceText", userChoiceText);
    }

    public static void trackUsersSucceededInFixingBrokenTestObjectsFeedback(String userAnswer) {
        Trackings.trackUserAction("fixBrokenTO_successSurvey", "userAnswer", userAnswer);
    }

    public static void trackClickImportOpenApi3() {
        Trackings.trackUserAction("clickImportOpenApi3", new Object[0]);
    }

    public static void trackClickImportSeleniumIde() {
        Trackings.trackUserAction("clickImportSeleniumIde", new Object[0]);
    }

    public static void trackImportSeleniumIdeResult(int numTestCases, int numTestSuites) {
        Trackings.trackUserAction("importSeleniumIdeResult", "numOfImportedTestCases", numTestCases, "numOfImportedTestSuites", numTestSuites);
    }

    public static void trackEnableCoordinatesBasedRecording(boolean isEnabled) {
        Trackings.trackUserAction("windowscoordinate_enableCoordinatesBasedRecording", "isEnabled", isEnabled);
    }

    public static void trackCoordinateActionUsed(String actionName) {
        Trackings.trackUserAction("windowscoordinate_coordinateActionRecorded", "usedAction", actionName);
    }

    public static void trackUserSaveScriptWithCoordinatedAction() {
        Trackings.trackUserAction("windowscoordinate_saveScriptWithCoordinateAction", new Object[0]);
    }

    public static void trackTestExplorerActionUsed(String actionName) {
        Trackings.trackUserAction("ksu_testexplorer_clicked", "project_action", actionName);
    }

    public static void trackTestExplorerSampleProject(String projectName) {
        Trackings.trackUserAction("ksu_testexplorer_clicked", "project_action", "sample_project", "sample_project_name", projectName);
    }

    public static void trackStartPageAreaClicked(String area) {
        Trackings.trackUserAction("ksu_startpage_clicked", "area", area);
    }

    public static void trackStartPageLinkClicked(String area, String url) {
        Trackings.trackUserAction("ksu_startpage_clicked", "area", area, "url", url);
    }

    public static void trackTroubleshootOpenRecentProjectClicked(String cause) {
        Trackings.trackUserAction("openRecentProjectFailed", "cause", cause);
    }

    public static void trackInstallDependencies(boolean result, String step) {
        String sResult = result ? "passed" : "failed";
        List<String> properties = TrackPropertyBuilder.create().addProperty("result", sResult).addProperty("step", result ? null : step).build();
        Trackings.trackUserAction("ksu_install_dependencies", properties.toArray());
    }

    public static void trackInstallWebdriverAgent(boolean result, String step) {
        String sResult = result ? "passed" : "failed";
        List<String> properties = TrackPropertyBuilder.create().addProperty("result", sResult).addProperty("step", result ? null : step).build();
        Trackings.trackUserAction("ksu_install_webdriver_agent", properties.toArray());
    }
}

