/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.IEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DeleteWindowsObjectHandler
implements IDeleteEntityHandler {
    @Inject
    private IEventBroker eventBroker;

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        try {
            if (!(treeEntity instanceof WindowsElementTreeEntity)) {
                return false;
            }
            String taskName = "Deleting " + treeEntity.getTypeName() + " '" + treeEntity.getText() + "'...";
            monitor.beginTask(taskName, 1);
            WindowsElementEntity windowsElementEntity = (WindowsElementEntity)treeEntity.getObject();
            UISynchronizeService.syncExec(() -> EntityPartUtil.closePart((IEntity)windowsElementEntity));
            WindowsElementController.getInstance().deleteWindowsElementEntity(windowsElementEntity);
            this.eventBroker.post("EXPLORER/DELETED_SELECTED_ITEM", (Object)windowsElementEntity.getIdForDisplay());
            return true;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
        finally {
            monitor.done();
        }
    }

    public Class<? extends ITreeEntity> entityType() {
        return WindowsElementTreeEntity.class;
    }
}

