/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.util.internal.ProcessUtil;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class InstallWinAppDriversHandler {
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final String RELATIVE_PATH_TO_WINAPPDRIVER = String.valueOf(File.separator) + "extensions" + File.separator + "WinAppDriver" + File.separator + "WindowsApplicationDriver.msi";

    @CanExecute
    public boolean canExecute() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    @Execute
    public void execute(Shell shell) throws IOException, InterruptedException {
        try {
            this.runWinAppDriverInstaller();
        }
        catch (IOException | InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public static void killRunningProcess() throws InterruptedException, IOException {
        try {
            ProcessUtil.killProcessOnWindows((String)"WinAppDriver.exe");
        }
        catch (IOException | InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private File getWinAppDriversResourcesDirectory() throws IOException {
        Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.composer.windows");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
        if (bundleFile.isDirectory()) {
            return new File(bundleFile + File.separator + RESOURCES_FOLDER_NAME);
        }
        return new File(ClassPathResolver.getConfigurationFolder() + File.separator + RESOURCES_FOLDER_NAME);
    }

    private void runWinAppDriverInstaller() throws IOException, InterruptedException {
        InstallWinAppDriversHandler.killRunningProcess();
        String winAppDriversAddonSetupPath = String.valueOf(this.getWinAppDriversResourcesDirectory().getAbsolutePath()) + RELATIVE_PATH_TO_WINAPPDRIVER;
        Desktop desktop = Desktop.getDesktop();
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        desktop.open(new File(winAppDriversAddonSetupPath));
    }
}

