/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameWindowsObjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                Object object = this.getObject(event);
                if (object instanceof WindowsElementTreeEntity) {
                    RenameWindowsObjectHandler.this.execute((WindowsElementTreeEntity)object);
                }
            }
        });
    }

    private void execute(WindowsElementTreeEntity windowsElementTree) {
        try {
            if (!(windowsElementTree.getObject() instanceof WindowsElementEntity)) {
                return;
            }
            this.rename(windowsElementTree);
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)windowsElementTree.getParent());
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)windowsElementTree);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to rename Windows Object", (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void rename(WindowsElementTreeEntity windowsElementTree) throws Exception {
        WindowsElementEntity windowsElementEntity = windowsElementTree.getObject();
        RenameWizard renameWizard = new RenameWizard((ITreeEntity)windowsElementTree, this.getSibblingNames(windowsElementEntity));
        if (new CWizardDialog(this.parentShell, (IWizard)renameWizard).open() != 0) {
            return;
        }
        String newName = renameWizard.getNewNameValue();
        if (windowsElementEntity.getName().equals(newName)) {
            return;
        }
        String oldIdForDisplay = windowsElementEntity.getIdForDisplay();
        WindowsElementController.getInstance().renameWindowsElementEntity(newName, windowsElementEntity);
        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, windowsElementEntity.getIdForDisplay()});
    }

    private List<String> getSibblingNames(WindowsElementEntity testRunEntity) throws Exception {
        List sibblingNames = FolderController.getInstance().getChildNames(testRunEntity.getParentFolder());
        sibblingNames.remove(testRunEntity.getName());
        return sibblingNames;
    }
}

