/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialog;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.windows.constant.WindowsRecorderMessagesConstants;
import com.kms.katalon.composer.windows.dialog.ExportReportToTestCaseSelectionDialog;
import com.kms.katalon.composer.windows.dialog.WindowsRecorderDialogV2;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElementConverter;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WindowsRecorderProHandler {
    @CanExecute
    public boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null && SystemUtils.IS_OS_WINDOWS;
    }

    @Execute
    public void execute(Shell activeShell) {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        if (!featureService.canUse(KSEFeature.WINDOWS_NATIVE_RECORDER)) {
            KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.WINDOWS_NATIVE_RECORDER);
            return;
        }
        Shell shell = this.getShell(activeShell);
        try {
            WindowsRecorderDialogV2 dialog = new WindowsRecorderDialogV2(shell);
            if (dialog.open() != 0) {
                return;
            }
            WindowsRecorderDialogV2.RecordActionResult recordActionResult = dialog.getRecordActionResult();
            if (recordActionResult.getScript().getBlock().getAstChildren().isEmpty()) {
                return;
            }
            try {
                this.trackTestScriptContent(recordActionResult);
                this.saveTestObject(shell, recordActionResult);
                this.saveToTestCase(shell, recordActionResult);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
                MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)GlobalStringConstants.WARN, (String)e.getMessage());
            }
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
        }
    }

    private void trackTestScriptContent(WindowsRecorderDialogV2.RecordActionResult recordActionResult) throws GroovyParsingException {
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(recordActionResult.getScript());
        ScriptNodeWrapper script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        List children = script.getBlock().getAstChildren();
        List methodsRun = children.stream().map(child -> {
            try {
                return (ExpressionStatementWrapper)child;
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(child -> child != null).map(child -> child.getExpression()).map(child -> {
            try {
                return (MethodCallExpressionWrapper)child;
            }
            catch (Exception exception) {
                return null;
            }
        }).filter(child -> child != null).map(child -> child.getMethodAsString()).collect(Collectors.toList());
        if (methodsRun.contains("clickElementOffset") || methodsRun.contains("rightClickElementOffset")) {
            Trackings.trackUserSaveScriptWithCoordinatedAction();
        }
    }

    private Shell getShell(Shell activeShell) {
        String os = Platform.getOS();
        if ("win32".equals(os) || "linux".equals(os)) {
            return null;
        }
        Shell shell = new Shell();
        return shell;
    }

    private void saveToTestCase(Shell activeShell, WindowsRecorderDialogV2.RecordActionResult actionResult) throws ControllerException, Exception {
        ExportReportToTestCaseSelectionDialog dialog = new ExportReportToTestCaseSelectionDialog(activeShell);
        if (dialog.open() != 0) {
            return;
        }
        ExportReportToTestCaseSelectionDialog.ExportTestCaseSelectionResult exportResult = dialog.getResult();
        FolderEntity selectedFolder = exportResult.getFolder();
        FolderTreeEntity selectedFolderTreeEntity = TreeEntityUtil.getFolderTreeEntity((FolderEntity)selectedFolder);
        TestCaseEntity testCaseEntity = this.getTestCase(exportResult);
        TestCaseTreeEntity testCaseTreeEntity = new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)selectedFolderTreeEntity);
        ExplorerPart.getInstance().refreshTreeEntity((Object)selectedFolderTreeEntity);
        ExplorerPart.getInstance().setSelectedItems(new Object[]{testCaseTreeEntity});
        MCompositePart part = OpenTestCaseHandler.getInstance().openTestCase(testCaseEntity);
        boolean shouldOverride = false;
        if (exportResult.getOption() == ExportReportToTestCaseSelectionDialog.ExportTestCaseOption.OVERWRITE_TEST_CASE) {
            shouldOverride = true;
        }
        boolean isNewTestCase = false;
        if (exportResult.getOption() == ExportReportToTestCaseSelectionDialog.ExportTestCaseOption.EXPORT_TO_NEW_TEST_CASE) {
            isNewTestCase = true;
        }
        TestCaseCompositePart testCaseCompositePart = (TestCaseCompositePart)part.getObject();
        TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        testCaseCompositePart.setScriptContentToManual();
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(actionResult.getScript());
        ScriptNodeWrapper script = GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
        List children = script.getBlock().getAstChildren();
        if (shouldOverride) {
            testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        } else {
            testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
        }
        testCasePart.addImports(script.getImports());
        testCasePart.getTreeTableInput().setChanged(true);
        testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
        testCaseCompositePart.recorderSave(isNewTestCase);
    }

    private TestCaseEntity getTestCase(ExportReportToTestCaseSelectionDialog.ExportTestCaseSelectionResult result) throws ControllerException {
        switch (result.getOption()) {
            case APPEND_TO_TEST_CASE: 
            case OVERWRITE_TEST_CASE: {
                return TestCaseController.getInstance().getTestCaseByDisplayId(String.valueOf(result.getFolder().getIdForDisplay()) + "/" + result.getTestCaseName());
            }
            case EXPORT_TO_NEW_TEST_CASE: {
                return TestCaseController.getInstance().newTestCase(result.getFolder(), result.getTestCaseName());
            }
        }
        return null;
    }

    private void saveTestObject(Shell activeShell, WindowsRecorderDialogV2.RecordActionResult recordResult) throws ControllerException {
        if (recordResult.getScript().getBlock().getAstChildren().isEmpty()) {
            return;
        }
        if (!recordResult.getWindowsElements().isEmpty()) {
            AddElementToObjectRepositoryDialog objectRepositoryDialog = new AddElementToObjectRepositoryDialog(activeShell);
            if (objectRepositoryDialog.open() != 0) {
                return;
            }
            FolderTreeEntity selectedTreeFolder = objectRepositoryDialog.getSelectedFolderTreeEntity();
            FolderEntity folder = this.getFolder(selectedTreeFolder);
            CapturedWindowsElementConverter converter = new CapturedWindowsElementConverter();
            ArrayList<WindowsElementTreeEntity> selectedTreeEntities = new ArrayList<WindowsElementTreeEntity>();
            for (CapturedWindowsElement capturedElement : recordResult.getWindowsElements()) {
                try {
                    WindowsElementEntity windowsElement = converter.convert(capturedElement, folder);
                    WindowsElementController.getInstance().updateWindowsElementEntity(windowsElement);
                    capturedElement.setScriptId(windowsElement.getIdForDisplay());
                    selectedTreeEntities.add(new WindowsElementTreeEntity(windowsElement, selectedTreeFolder));
                }
                catch (Exception e) {
                    UISynchronizeService.syncExec((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)WindowsRecorderMessagesConstants.ERROR, (String)WindowsRecorderMessagesConstants.MSG_ERR_CANNOT_GENERATE_TEST_STEPS);
                            LoggerSingleton.logError((Throwable)e);
                        }
                    });
                    LoggerSingleton.logError((Throwable)e);
                }
            }
            ExplorerPart.getInstance().setSelectedItems(selectedTreeEntities.toArray());
        }
    }

    private FolderEntity getFolder(FolderTreeEntity selectedTreeFolder) {
        FolderEntity folder = null;
        try {
            folder = selectedTreeFolder.getObject();
        }
        catch (Exception exception) {}
        return folder;
    }
}

