/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.nativerecorder;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.classpath.ClassPathResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class NativeRecorderDriver {
    private static final String DRIVER_FOLDER = Paths.get("resources", "KatalonNativeRecorder").toString();
    private static final String DRIVER_FILE_NAME = "KatalonNativeRecorder.exe";
    private Thread driverThread = null;
    private boolean isRunning = false;

    public boolean isRunning() {
        return this.isRunning;
    }

    public void setRunning(boolean isRunning) {
        this.isRunning = isRunning;
    }

    public File getDriverDirectory() throws IOException {
        Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.composer.windows");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
        Path driverDirectory = null;
        driverDirectory = bundleFile.isDirectory() ? Paths.get(bundleFile.toString(), DRIVER_FOLDER) : Paths.get(ClassPathResolver.getConfigurationFolder().toString(), DRIVER_FOLDER);
        return new File(driverDirectory.toString());
    }

    public String getDriverFilePath() throws IOException {
        return Paths.get(this.getDriverDirectory().getAbsolutePath(), DRIVER_FILE_NAME).toString();
    }

    public void start() throws IOException {
        this.start(false);
    }

    public void start(boolean forceNew) throws IOException {
        final String driverPath = this.getDriverFilePath();
        if (forceNew || !this.isRunning()) {
            if (this.driverThread != null && !this.driverThread.isInterrupted()) {
                this.driverThread.interrupt();
            }
            this.driverThread = new Thread(){

                @Override
                public void run() {
                    try {
                        try {
                            List driverOutputs = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])new String[]{driverPath});
                            String driverLog = driverOutputs.stream().collect(Collectors.joining("\r\n"));
                            LoggerSingleton.logInfo((String)"Driver running log:");
                            LoggerSingleton.logInfo((String)driverLog);
                        }
                        catch (IOException | InterruptedException exception) {
                            LoggerSingleton.logError((Throwable)exception);
                            NativeRecorderDriver.this.setRunning(false);
                        }
                    }
                    finally {
                        NativeRecorderDriver.this.setRunning(false);
                    }
                }
            };
            this.driverThread.start();
        }
        this.setRunning(true);
    }
}

