/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.part;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.impl.handler.ObjectPropertyHandler;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.part.IComposerPart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.windows.dialog.EditWindowsElementPropertyDialog;
import com.kms.katalon.composer.windows.dialog.NewWindowsElementPropertyDialog;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.tracking.service.Trackings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WindowsObjectPart
implements IComposerPart {
    private WindowsElementEntity entity;
    private StyledText txtLocator;
    private CTableViewer tableViewerObjectProperties;
    private Combo cbbLocatorStrategy;
    private MPart mpart;
    private Composite mainComposite;
    private static String[] strategies = WindowsElementEntity.LocatorStrategy.getStrategies();
    private List<WebElementPropertyEntity> properties;
    private WindowsElementEntity editingEntity;
    @Inject
    IEventBroker eventBroker;
    private EventServiceAdapter eventHandler = new EventServiceAdapter(){

        public void handleEvent(Event event) {
            Object[] objects = this.getObjects(event);
            if (objects == null || objects.length != 2) {
                return;
            }
            try {
                String oldWindowsObjectId = (String)objects[0];
                String newWindowsObjectId = (String)objects[1];
                if (WindowsObjectPart.this.editingEntity.getIdForDisplay().equals(oldWindowsObjectId)) {
                    WindowsObjectPart.this.entity = WindowsElementController.getInstance().getWindowsElementByDisplayId(newWindowsObjectId);
                    WindowsObjectPart.this.editingEntity = (WindowsElementEntity)WindowsObjectPart.this.entity.clone();
                    WindowsObjectPart.this.editingEntity.setName(WindowsObjectPart.this.entity.getName());
                    WindowsObjectPart.this.mpart.setLabel(WindowsObjectPart.this.editingEntity.getName());
                }
            }
            catch (ControllerException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    };

    @PostConstruct
    public void onCreatePart(MPart mpart, Composite parent) {
        this.mpart = mpart;
        this.entity = (WindowsElementEntity)mpart.getObject();
        this.createControls(parent);
        this.setInput();
        this.addListeners();
    }

    @PreDestroy
    public void onDestroyPart() {
        this.eventBroker.unsubscribe((EventHandler)this.eventHandler);
    }

    private void addListeners() {
        this.eventBroker.subscribe("EXPLORER/RENAMED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.eventBroker.subscribe("EXPLORER/CUT_PASTED_SELECTED_ITEM", (EventHandler)this.eventHandler);
        this.txtLocator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WindowsObjectPart.this.mpart.setDirty(true);
            }
        });
        this.cbbLocatorStrategy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WindowsObjectPart.this.mpart.setDirty(true);
            }
        });
    }

    private void setInput() {
        this.editingEntity = (WindowsElementEntity)this.entity.clone();
        this.mpart.setLabel(this.editingEntity.getName());
        WindowsElementEntity.LocatorStrategy selectedLocator = this.editingEntity.getLocatorStrategy();
        int selectedIndex = Arrays.asList(strategies).indexOf(selectedLocator.getLocatorStrategy());
        this.cbbLocatorStrategy.select(selectedIndex);
        this.txtLocator.setText(StringUtils.defaultString((String)this.editingEntity.getLocator()));
        this.properties = new ArrayList<WebElementPropertyEntity>(this.editingEntity.getProperties());
        this.tableViewerObjectProperties.setInput(this.properties);
    }

    private Shell getShell() {
        return this.mainComposite.getShell();
    }

    private void createControls(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setBackground(ColorUtil.getPartBackgroundColor());
        this.mainComposite.setLayout((Layout)new GridLayout(1, false));
        Composite locatorComposite = new Composite(this.mainComposite, 0);
        locatorComposite.setLayout((Layout)new GridLayout(1, false));
        locatorComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblLocatorTitle = new Label(locatorComposite, 0);
        lblLocatorTitle.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblLocatorTitle.setText("Locator");
        ControlUtils.setFontToBeBold((Control)lblLocatorTitle);
        Composite locatorDetailsComposite = new Composite(locatorComposite, 0);
        locatorDetailsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout glLocatorDetails = new GridLayout(2, false);
        glLocatorDetails.marginWidth = 0;
        glLocatorDetails.marginHeight = 0;
        locatorDetailsComposite.setLayout((Layout)glLocatorDetails);
        Label lblLocatorStrategy = new Label(locatorDetailsComposite, 0);
        lblLocatorStrategy.setText("Locator Strategy");
        lblLocatorStrategy.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.cbbLocatorStrategy = new Combo(locatorDetailsComposite, 8);
        this.cbbLocatorStrategy.setItems(strategies);
        Label lblLocator = new Label(locatorDetailsComposite, 0);
        lblLocator.setLayoutData((Object)new GridData(16384, 128, false, false));
        lblLocator.setText("Locator");
        this.txtLocator = new StyledText(locatorDetailsComposite, 2562);
        GridData gdTxtEditor = new GridData(4, 4, true, false);
        gdTxtEditor.heightHint = 100;
        this.txtLocator.setLayoutData((Object)gdTxtEditor);
        Composite tableComposite = new Composite(this.mainComposite, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glTableComposite = new GridLayout();
        glTableComposite.marginTop = 15;
        tableComposite.setLayout((Layout)glTableComposite);
        Label lblObjectPropertiesTitle = new Label(tableComposite, 0);
        lblObjectPropertiesTitle.setText("Object Properties");
        ControlUtils.setFontToBeBold((Control)lblObjectPropertiesTitle);
        ToolBar tbProperties = new ToolBar(tableComposite, 0x820000);
        tbProperties.setForeground(ColorUtil.getToolBarForegroundColor());
        tbProperties.setLayoutData((Object)new GridData(4, 128, true, false));
        ToolItem tltmAdd = new ToolItem(tbProperties, 8);
        tltmAdd.setText("Add");
        tltmAdd.setImage(ImageManager.getImage((String)"add_16.png"));
        tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWindowsElementPropertyDialog windowsElementDialog = new NewWindowsElementPropertyDialog(WindowsObjectPart.this.getShell());
                if (windowsElementDialog.open() == 0) {
                    WindowsObjectPart.this.properties.add(windowsElementDialog.getNewProperty());
                    WindowsObjectPart.this.tableViewerObjectProperties.setInput(WindowsObjectPart.this.properties);
                    WindowsObjectPart.this.tableViewerObjectProperties.refresh();
                    if (OSUtil.isMacBigSurOrLater()) {
                        WindowsObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                    }
                    WindowsObjectPart.this.mpart.setDirty(true);
                }
            }
        });
        ToolItem tltmEdit = new ToolItem(tbProperties, 8);
        tltmEdit.setText("Edit");
        tltmEdit.setImage(ImageManager.getImage((String)"edit_16.png"));
        tltmEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection = WindowsObjectPart.this.tableViewerObjectProperties.getStructuredSelection();
                if (structuredSelection.isEmpty()) {
                    return;
                }
                WebElementPropertyEntity editingProperty = (WebElementPropertyEntity)structuredSelection.getFirstElement();
                EditWindowsElementPropertyDialog windowsElementDialog = new EditWindowsElementPropertyDialog(WindowsObjectPart.this.getShell(), editingProperty);
                if (windowsElementDialog.open() == 0) {
                    WindowsObjectPart.this.tableViewerObjectProperties.refresh((Object)editingProperty);
                    WindowsObjectPart.this.mpart.setDirty(true);
                }
            }
        });
        ToolItem tltmDelete = new ToolItem(tbProperties, 8);
        tltmDelete.setText("Delete");
        tltmDelete.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List objects = WindowsObjectPart.this.tableViewerObjectProperties.getStructuredSelection().toList();
                if (objects == null || objects.isEmpty()) {
                    return;
                }
                WindowsObjectPart.this.properties.removeAll(objects);
                WindowsObjectPart.this.tableViewerObjectProperties.setInput(WindowsObjectPart.this.properties);
                WindowsObjectPart.this.tableViewerObjectProperties.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    WindowsObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                WindowsObjectPart.this.mpart.setDirty(true);
            }
        });
        ToolItem tltmClear = new ToolItem(tbProperties, 8);
        tltmClear.setText("Clear");
        tltmClear.setImage(ImageManager.getImage((String)"delete_16.png"));
        tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WindowsObjectPart.this.properties.isEmpty()) {
                    return;
                }
                if (!MessageDialog.openConfirm((Shell)WindowsObjectPart.this.getShell(), (String)GlobalStringConstants.CONFIRMATION, (String)"Do you want to clear all these properties?")) {
                    return;
                }
                WindowsObjectPart.this.properties.clear();
                WindowsObjectPart.this.tableViewerObjectProperties.setInput(WindowsObjectPart.this.properties);
                WindowsObjectPart.this.tableViewerObjectProperties.refresh();
                if (OSUtil.isMacBigSurOrLater()) {
                    WindowsObjectPart.this.tableViewerObjectProperties.getTable().redraw();
                }
                WindowsObjectPart.this.mpart.setDirty(true);
            }
        });
        this.tableViewerObjectProperties = new CTableViewer(tableComposite, 2048);
        Table table = this.tableViewerObjectProperties.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        TableViewerColumn treeViewerColumnName = new TableViewerColumn((TableViewer)this.tableViewerObjectProperties, 0);
        TableColumn trclmnColumnName = treeViewerColumnName.getColumn();
        trclmnColumnName.setText("Name");
        trclmnColumnName.setWidth(175);
        treeViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getName();
            }
        });
        TableViewerColumn treeViewerColumnValue = new TableViewerColumn((TableViewer)this.tableViewerObjectProperties, 0);
        TableColumn trclmnColumnValue = treeViewerColumnValue.getColumn();
        trclmnColumnValue.setText("Value");
        trclmnColumnValue.setWidth(350);
        treeViewerColumnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((WebElementPropertyEntity)element).getValue();
            }
        });
        this.tableViewerObjectProperties.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerObjectProperties.setInput(Collections.emptyList());
    }

    @Persist
    public void onSave() {
        WindowsElementEntity.LocatorStrategy selectedLocator = WindowsElementEntity.LocatorStrategy.valueOfStrategy((String)this.cbbLocatorStrategy.getText());
        this.editingEntity.setLocatorStrategy(selectedLocator);
        this.editingEntity.setLocator(this.txtLocator.getText());
        this.editingEntity.setProperties(this.properties);
        try {
            WindowsElementController.getInstance().updateWindowsElementEntity(this.editingEntity);
            this.entity = this.editingEntity;
            this.editingEntity = (WindowsElementEntity)this.editingEntity.clone();
            List list = (List)this.tableViewerObjectProperties.getInput();
            if (!ObjectPropertyHandler.verifyObjectProperties((Object)this.editingEntity, (List)list)) {
                return;
            }
            WindowsElementTreeEntity treeEntity = TreeEntityUtil.getWindowsElementTreeEntity((WindowsElementEntity)this.entity, (FolderEntity)this.entity.getParentFolder());
            ExplorerPart.getInstance().refreshTreeEntity((Object)treeEntity);
            this.mpart.setDirty(false);
            Trackings.trackEditObject((String)"testObject", (String)"WINDOWS");
        }
        catch (ControllerException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Error", (String)"Unable to save Windows Object");
        }
    }

    public String getEntityId() {
        return this.entity.getIdForDisplay();
    }
}

