/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.record.model;

import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.record.model.WindowsRecordedElement;
import com.kms.katalon.composer.windows.record.model.WindowsRecordedPayload;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class RecordedElementLocatorHelper {
    private WindowsRecordedElement recordedElement;
    private WindowsRecordedPayload payload;
    private WindowsElementEntity.LocatorStrategy locatorStrategy;
    private String locator;

    public RecordedElementLocatorHelper(WindowsRecordedPayload payload) {
        this.payload = payload;
        this.recordedElement = payload.getElement();
    }

    public CapturedWindowsElement getCapturedElement() {
        CapturedWindowsElement element = new CapturedWindowsElement();
        element.setTagName(this.getTitleCaseName(this.recordedElement.getType()));
        element.setName(this.getTitleCaseName(this.recordedElement.getType()));
        element.setProperties(this.recordedElement.getAttributes());
        element.getProperties().put("XPath", this.buildXPath());
        this.buildXPathLocator();
        element.setLocator(this.locator);
        element.setLocatorStrategy(this.locatorStrategy);
        return element;
    }

    private void buildLocator() {
        Map<String, String> attributes = this.recordedElement.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.XPATH;
            this.locator = "";
            return;
        }
        String name = attributes.get("Name");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.NAME;
            this.locator = name;
            return;
        }
        this.locatorStrategy = WindowsElementEntity.LocatorStrategy.XPATH;
        this.locator = this.buildXPath();
    }

    private void buildXPathLocator() {
        Map<String, String> attributes = this.recordedElement.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            this.locatorStrategy = WindowsElementEntity.LocatorStrategy.XPATH;
            this.locator = "";
            return;
        }
        this.locatorStrategy = WindowsElementEntity.LocatorStrategy.XPATH;
        this.locator = this.buildXPath();
    }

    private String buildXPath() {
        StringBuilder sb = new StringBuilder("/");
        List<WindowsRecordedElement> elements = this.payload.getParent();
        int i = 0;
        while (i < elements.size()) {
            WindowsRecordedElement p = elements.get(i);
            if (p.getAttributes() != null && !p.getAttributes().isEmpty()) {
                sb.append(this.buildPartialIndexBasedXPath(p, i == 1));
                sb.append("/");
            }
            ++i;
        }
        sb.append(this.buildPartialIndexBasedXPath(this.recordedElement, false));
        return sb.toString();
    }

    private String buildPartialXPath(WindowsRecordedElement e, boolean isMainWindow) {
        String type = this.getTitleCaseName(e.getType());
        if (isMainWindow) {
            return type;
        }
        Map<String, String> attributes = e.getAttributes();
        String automationId = attributes.get("AutomationId");
        String className = attributes.get("ClassName");
        String name = attributes.get("Name");
        if (StringUtils.isEmpty((CharSequence)automationId) && StringUtils.isEmpty((CharSequence)className) && StringUtils.isEmpty((CharSequence)name)) {
            String elementIndex = attributes.get("ElementIndex");
            if (attributes.containsKey("ElementIndex") && Integer.parseInt(attributes.get("ElementIndex")) > 0) {
                return String.valueOf(type) + "[" + elementIndex + "]";
            }
            return type;
        }
        if (StringUtils.isNotEmpty((CharSequence)automationId)) {
            return String.format("%s[@AutomationId = \"%s\"]", type, automationId);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(type) + "[");
        String predicate = "";
        if (StringUtils.isNotEmpty((CharSequence)className)) {
            predicate = String.format("@ClassName = \"%s\"", className);
            sb.append(predicate);
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            if (StringUtils.isNotEmpty((CharSequence)predicate)) {
                sb.append(" and ");
            }
            sb.append(String.format("@Name = \"%s\"", name));
        }
        sb.append("]");
        return sb.toString();
    }

    private String buildPartialIndexBasedXPath(WindowsRecordedElement element, boolean isMainWindow) {
        String type = this.getTitleCaseName(element.getType());
        if (isMainWindow) {
            return type;
        }
        Map<String, String> attributes = element.getAttributes();
        String elementIndex = attributes.get("ElementIndex");
        if (attributes.containsKey("ElementIndex") && Integer.parseInt(attributes.get("ElementIndex")) > 0) {
            return String.valueOf(type) + "[" + elementIndex + "]";
        }
        return type;
    }

    private String getTitleCaseName(String name) {
        return RecordedElementLocatorHelper.toTitleCase(name).replace(" ", "");
    }

    private static String toTitleCase(String inputString) {
        if (StringUtils.isBlank((CharSequence)inputString)) {
            return "";
        }
        if (StringUtils.length((CharSequence)inputString) == 1) {
            return inputString.toUpperCase();
        }
        StringBuffer resultPlaceHolder = new StringBuffer(inputString.length());
        Stream.of(inputString.split(" ")).forEach(stringPart -> {
            char[] charArray = stringPart.toCharArray();
            charArray[0] = Character.toUpperCase(charArray[0]);
            resultPlaceHolder.append(new String(charArray)).append(" ");
        });
        return StringUtils.trim((String)resultPlaceHolder.toString());
    }
}

