/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.spy;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.windows.dialog.WindowsSpyObjectDialog;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import com.kms.katalon.composer.windows.element.CapturedWindowsElementConverter;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class CapturedWindowsObjectTableViewer
extends CTableViewer {
    private List<CapturedWindowsElement> capturedElements;
    private WindowsSpyObjectDialog dialog;

    public CapturedWindowsObjectTableViewer(Composite parent, int style, WindowsSpyObjectDialog dialog) {
        super(parent, style);
        this.dialog = dialog;
    }

    public List<CapturedWindowsElement> getCapturedElements() {
        return this.capturedElements;
    }

    public void setCapturedElements(List<CapturedWindowsElement> capturedElements) {
        this.capturedElements = capturedElements;
        this.setInput(capturedElements);
    }

    public CapturedWindowsElement getSelectedElement() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (CapturedWindowsElement)selection.getFirstElement();
    }

    public IStructuredSelection getStructuredSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        return selection;
    }

    public CapturedWindowsElement[] getSelectedElements() {
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.isEmpty()) {
            return new CapturedWindowsElement[0];
        }
        Object[] rawElements = selection.toArray();
        CapturedWindowsElement[] capturedElements = new CapturedWindowsElement[rawElements.length];
        int i = 0;
        while (i < rawElements.length) {
            capturedElements[i] = (CapturedWindowsElement)rawElements[i];
            ++i;
        }
        return capturedElements;
    }

    public void addElements(List<WindowsElementEntity> webElements) {
        CapturedWindowsElementConverter converter = new CapturedWindowsElementConverter();
        ArrayList<CapturedWindowsElement> newWindowsElements = new ArrayList<CapturedWindowsElement>();
        for (WindowsElementEntity webElement : webElements) {
            newWindowsElements.add(converter.revert(webElement));
        }
        this.addWindowsElements(newWindowsElements);
    }

    public void addWindowsElements(List<CapturedWindowsElement> mobileElements) {
        ArrayList<CapturedWindowsElement> added = new ArrayList<CapturedWindowsElement>();
        List<String> currentNames = this.capturedElements.stream().map(e -> e.getName()).collect(Collectors.toList());
        for (CapturedWindowsElement eachElement : mobileElements) {
            int elementIdx;
            if (currentNames.contains(eachElement.getName())) {
                String suggestedName = this.findNameForElement(eachElement.getName(), currentNames);
                eachElement.setName(suggestedName);
                currentNames.add(suggestedName);
            }
            if ((elementIdx = this.capturedElements.indexOf(eachElement)) < 0) {
                this.capturedElements.add(eachElement);
                added.add(eachElement);
                continue;
            }
            added.add(this.capturedElements.get(elementIdx));
        }
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection(added));
        this.showLastItem();
        this.notifyStateChanged();
    }

    private String findNameForElement(String name, List<String> currentNames) {
        String suggestedName = name;
        int index = 0;
        while (currentNames.contains(suggestedName)) {
            suggestedName = String.valueOf(name) + "(" + ++index + ")";
        }
        return suggestedName;
    }

    public void removeCapturedElements(List<CapturedWindowsElement> elements) {
        this.capturedElements.removeAll(elements);
        this.refresh();
        this.notifyStateChanged();
    }

    public void removeCapturedElement(CapturedWindowsElement element) {
        this.removeCapturedElement(element, true);
    }

    public void removeCapturedElement(CapturedWindowsElement element, boolean needRefresh) {
        if (!this.contains(element)) {
            return;
        }
        this.capturedElements.remove(element);
        if (needRefresh) {
            this.refresh();
        }
        this.notifyStateChanged();
    }

    public void checkAllElements(boolean checked) {
        if (this.capturedElements.isEmpty()) {
            return;
        }
        for (CapturedWindowsElement mobileElement : this.capturedElements) {
            mobileElement.setChecked(checked);
        }
        this.refresh();
        this.notifyStateChanged();
    }

    public boolean contains(CapturedWindowsElement element) {
        if (element == null) {
            return false;
        }
        return this.capturedElements.contains(element);
    }

    public boolean isAllElementChecked() {
        for (CapturedWindowsElement mobileElement : this.capturedElements) {
            if (mobileElement.isChecked()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyElementChecked() {
        for (CapturedWindowsElement mobileElement : this.capturedElements) {
            if (!mobileElement.isChecked()) continue;
            return true;
        }
        return false;
    }

    public List<CapturedWindowsElement> getAllCheckedElements() {
        ArrayList<CapturedWindowsElement> checkedElements = new ArrayList<CapturedWindowsElement>();
        for (CapturedWindowsElement mobileElement : this.capturedElements) {
            if (!mobileElement.isChecked()) continue;
            checkedElements.add(mobileElement);
        }
        return checkedElements;
    }

    public void notifyStateChanged() {
        this.dialog.updateCapturedElementSelectingColumnHeader();
    }
}

