/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.EBrowser;
import com.kms.katalon.core.webui.common.EngineLogger;
import com.kms.katalon.core.webui.common.Result;
import java.awt.Robot;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;

public class BaseObject {
    protected WebDriver driver;
    protected WebElement element;
    protected String value;
    protected BaseObject parent;
    protected String loggerName;

    public BaseObject(WebDriver driver, WebElement webElement) {
        this.driver = driver;
        this.value = "";
        this.element = webElement;
    }

    public BaseObject() {
    }

    public Result click() {
        Result result;
        block8: {
            Result exist = this.isExist();
            if (exist.getReturnValue().equals(false)) {
                return exist;
            }
            result = new Result();
            if (this.element.isEnabled()) {
                try {
                    try {
                        this.element.click();
                    }
                    catch (Exception e) {
                        if (e.getMessage().startsWith("unknown error: Element is not clickable")) {
                            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
                            executor.executeScript("arguments[0].click();", new Object[]{this.element});
                            break block8;
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT055"), e.getMessage()));
                    result.setNeedReNewDriver(true);
                }
            } else {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT056"), new Object[0]));
            }
        }
        return result;
    }

    public Result doubleClick() {
        Result exist = this.isExist();
        if (exist.getReturnValue().equals(false)) {
            return exist;
        }
        Result result = new Result();
        try {
            Actions action = new Actions(this.driver);
            action.moveToElement(this.element).build().perform();
            action.doubleClick(this.element);
            action.perform();
        }
        catch (TimeoutException timeoutException) {
            return this.reportUnhappyCase(false, false, "OBJ040", new Object[0]);
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT057"), e.getMessage()));
            result.setNeedReNewDriver(true);
        }
        return result;
    }

    protected Result waitForPageLoaded(int timeOut) {
        return new EBrowser(this.driver).waitForPageLoaded(timeOut);
    }

    protected void handleTimeoutLoading() {
        System.out.println("Time's up");
        try {
            this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{Keys.ESCAPE});
        }
        catch (NoSuchElementException noSuchElementException) {
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            executor.executeScript("return window.stop()", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Stop loading");
    }

    protected void refreshWebElement() throws Exception {
        try {
            this.driver.switchTo().defaultContent();
            this.driver.switchTo().activeElement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Result reportUnhappyCase(Object value, boolean needToReNewBrowser, String logMessageId, Object ... params) {
        try {
            Result result = new Result();
            String message = String.format(EngineLogger.getLogMessageFromProperties(logMessageId), params);
            result.setMessage(message);
            result.setReturnValue(value);
            result.setNeedReNewDriver(needToReNewBrowser);
            return result;
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Should go here because hardcode");
        }
        catch (Exception e) {
            throw e;
        }
        return null;
    }

    protected Result reportHappyCase(Object value) {
        Result result = new Result();
        result.setReturnValue(value);
        return result;
    }

    public Result isExist() {
        try {
            this.refreshWebElement();
            if (this.element != null) {
                return this.reportHappyCase(true);
            }
            return this.reportUnhappyCase(false, false, "INT002", new Object[0]);
        }
        catch (TimeoutException timeoutException) {
            return this.reportUnhappyCase(false, false, "OBJ040", new Object[0]);
        }
        catch (Exception exception) {
            return this.reportUnhappyCase(false, true, "INT002", new Object[0]);
        }
    }

    public Result rightClick() {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                Actions action = new Actions(this.driver);
                action.contextClick(this.element).build().perform();
                return this.reportHappyCase(null);
            }
            catch (TimeoutException timeoutException) {
                return this.reportUnhappyCase(false, false, "OBJ040", new Object[0]);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(null, true, "INT004", e.getMessage());
            }
        }
        return this.reportUnhappyCase(null, checkExist.needReNewDriver(), "INT005", checkExist.getMessage());
    }

    public Result getValue() {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                this.value = this.element.getText();
                return this.reportHappyCase(this.value);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(null, true, "INT008", e.getMessage());
            }
        }
        return this.reportUnhappyCase(false, checkExist.needReNewDriver(), "INT009", checkExist.getMessage());
    }

    public Result checkText(String input) {
        Result value = this.getValue();
        if (value.getMessage() == null) {
            if (input == null) {
                if (value.getReturnValue() == null) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT034", value.getReturnValue());
            }
            int dollarIdx = input.indexOf("$");
            if (dollarIdx == input.length() - 1) {
                String sub = input.substring(0, input.length() - 1);
                sub = sub.replace("$", "\\$");
                input = sub.concat(input.substring(input.length() - 1, input.length()));
            } else {
                input = input.replace("$", "\\$");
            }
            if (value.getReturnValue() != null) {
                String actualValue = value.getReturnValue().toString();
                if (actualValue.matches(input)) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT035", input, actualValue);
            }
            return this.reportUnhappyCase(false, false, "INT037", input);
        }
        return this.reportUnhappyCase(false, value.needReNewDriver(), "INT038", value.getMessage());
    }

    protected String getElementAttribute(String key) {
        String attribute = null;
        if (this.element != null) {
            try {
                attribute = "text".equalsIgnoreCase(key) || "link_text".equalsIgnoreCase(key) ? this.element.getText() : this.element.getAttribute(key);
            }
            catch (StaleElementReferenceException staleElementReferenceException) {
                try {
                    this.refreshWebElement();
                }
                catch (Exception exception) {
                    return null;
                }
                attribute = this.element.getAttribute(key);
            }
        }
        return attribute;
    }

    public String getElementText() throws Exception {
        if (this.element == null) {
            this.refreshWebElement();
        }
        if (this.element != null) {
            return this.element.getText();
        }
        return null;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebElement getElement() {
        if (this.element == null) {
            this.isExist();
        }
        return this.element;
    }

    public void setElement(WebElement element) {
        this.element = element;
    }

    public Result getCssValue(String propertyName) {
        Result exist = this.isExist();
        if (exist.getReturnValue().equals(false)) {
            return exist;
        }
        try {
            if (this.element != null) {
                String cssValue = this.element.getCssValue(propertyName);
                return this.reportHappyCase(cssValue);
            }
            return this.reportUnhappyCase(null, false, "INT039", new Object[0]);
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT040", e.getMessage());
        }
    }

    public Result getAttribute(String name) {
        Result exist = this.isExist();
        if (exist.getReturnValue().equals(false)) {
            return exist;
        }
        try {
            return this.reportHappyCase(this.getElementAttribute(name));
        }
        catch (Exception e) {
            return this.reportUnhappyCase(null, true, "INT041", e.getMessage());
        }
    }

    protected boolean verifyStringExact(String verifyString, String value) {
        return value.equalsIgnoreCase(verifyString);
    }

    protected boolean verifyStringContains(String verifyString, String[] containsValues) {
        if (containsValues != null) {
            String[] stringArray = containsValues;
            int n = containsValues.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!verifyString.toLowerCase().contains(value.toLowerCase())) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected String[] getWindowsTitle() {
        Set handles = this.driver.getWindowHandles();
        HashSet<String> titles = new HashSet<String>();
        String returnHandle = this.driver.getWindowHandle();
        for (String handle : handles) {
            this.driver.switchTo().window(handle);
            titles.add(this.driver.getTitle());
        }
        this.driver.switchTo().window(returnHandle);
        return titles.toArray(new String[0]);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public Result isAttributeContainsValues(String attribute, String[] values) {
        Result exist = this.isExist();
        if (exist.getReturnValue().equals(false)) {
            return exist;
        }
        String attributeValue = this.getElementAttribute(attribute);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (!attributeValue.toLowerCase().contains(value.toLowerCase())) {
                return Result.reportUnHappyCase(false, false, "INT231", attribute, value);
            }
            ++n2;
        }
        return Result.reportHappyCase(true);
    }

    public Result mouseMove() {
        Result checkExist = this.isExist();
        if (checkExist.getReturnValue().equals(true)) {
            try {
                Robot robot = new Robot();
                robot.mouseMove(0, 0);
                Thread.sleep(500L);
                Actions action = new Actions(this.driver);
                action.moveToElement(this.element).build().perform();
                return this.reportHappyCase(null);
            }
            catch (Exception e) {
                return this.reportUnhappyCase(null, true, "INT006", e.getMessage());
            }
        }
        return this.reportUnhappyCase(null, checkExist.needReNewDriver(), "INT007", checkExist.getMessage());
    }

    public Result isValueContain(String input) {
        Result value = this.getValue();
        if (value.getMessage() == null) {
            if (input == null) {
                if (value.getReturnValue() == null) {
                    this.reportHappyCase(true);
                }
                this.reportUnhappyCase(false, value.needReNewDriver(), "INT013", value.getReturnValue());
            }
            if (value.getReturnValue() != null) {
                String actualValue = value.getReturnValue().toString().toLowerCase();
                if (actualValue.contains(input.toLowerCase())) {
                    return this.reportHappyCase(true);
                }
                return this.reportUnhappyCase(false, false, "INT014", actualValue, input);
            }
            return this.reportUnhappyCase(false, false, "INT015", input);
        }
        return this.reportUnhappyCase(false, value.needReNewDriver(), "INT016", value.getMessage());
    }
}

