/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.common;

import com.kms.katalon.core.webui.common.EKeyboard;
import com.kms.katalon.core.webui.common.EngineLogger;
import com.kms.katalon.core.webui.common.ExecuteCommandAction;
import com.kms.katalon.core.webui.common.Result;
import com.kms.katalon.core.webui.constants.StringConstants;
import java.awt.HeadlessException;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;

public class EUtil {
    public Result equal(String value1, String value2) {
        Result result = new Result();
        try {
            if (value1.equals(value2)) {
                result.setReturnValue(true);
            } else {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT192"), value1, value2));
                result.setReturnValue(false);
            }
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT193"), e.getMessage()));
            result.setReturnValue(false);
        }
        return result;
    }

    public Result split(String value, String delimiter) {
        return Result.reportHappyCase(value.split(delimiter));
    }

    public Result concatMulti(Object[] inputs) {
        if (inputs != null) {
            String output = "";
            Object[] objectArray = inputs;
            int n = inputs.length;
            int n2 = 0;
            while (n2 < n) {
                Object input = objectArray[n2];
                output = String.valueOf(output) + input.toString();
                ++n2;
            }
            return Result.reportHappyCase(output);
        }
        return Result.reportUnHappyCase(false, false, "INT196", new Object[0]);
    }

    private Result executeCommand(String command) {
        Result result = new ExecuteCommandAction(command).execute();
        List outputs = (List)result.getReturnValue();
        String resultString = "";
        if (outputs != null) {
            for (String output : outputs) {
                resultString = String.valueOf(resultString) + output;
            }
        }
        result.setReturnValue(resultString);
        return result;
    }

    public Result executeCommand(Object[] command) {
        String output = "";
        if (command != null) {
            Object[] objectArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                Object input = objectArray[n2];
                output = String.valueOf(output) + input.toString() + " ";
                ++n2;
            }
            return this.executeCommand(output);
        }
        return Result.reportUnHappyCase(false, false, MessageFormat.format(StringConstants.COMM_MSG_FAILED_TO_EXEC_COMMAND, output), new Object[0]);
    }

    public Result setURL(String urlFormat, String json) {
        return Result.reportUnHappyCase(null, false, "INT197", new Object[0]);
    }

    public Result queryDB(String sql) {
        String sqlStatement = "cmd /c DB.py execute \"" + sql + "\"";
        return this.executeCommand(sqlStatement);
    }

    public Result selectQueryValueAtIndex(String queryResult, String index) {
        String command = "cmd /c DB.py get_value \"" + queryResult + "\" \"" + index + "\"";
        Result tmpResult = this.executeCommand(command);
        String value = tmpResult.getReturnValue().toString().trim().replace("'", "");
        tmpResult.setReturnValue(value);
        return tmpResult;
    }

    public Result copyDataToClipboard(String value) {
        Result result = new Result();
        try {
            Thread.sleep(2000L);
            StringSelection stringSelection = new StringSelection(value);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            this.keyboardPaste();
            Thread.sleep(1000L);
        }
        catch (HeadlessException e) {
            result.setMessage(MessageFormat.format(StringConstants.COMM_MSG_EXC_ERROR, e.getMessage()));
        }
        catch (InterruptedException e2) {
            result.setMessage(MessageFormat.format(StringConstants.COMM_MSG_EXC_ERROR, e2.getMessage()));
        }
        return result;
    }

    public Result keyboardPaste() {
        Result result = new Result();
        try {
            Robot robot = new Robot();
            robot.keyPress(17);
            robot.keyPress(86);
            Thread.sleep(100L);
            robot.keyRelease(86);
            robot.keyRelease(17);
        }
        catch (Exception e) {
            result.setMessage(MessageFormat.format(StringConstants.COMM_MSG_EXC_ERROR, e.getMessage()));
        }
        return result;
    }

    public Result subString(String text, String beginString, String endString) {
        try {
            int beginLength = beginString.length();
            int beginIndex = text.indexOf(beginString) + beginLength;
            int endIndex = text.indexOf(endString, beginIndex);
            return Result.reportHappyCase(text.substring(beginIndex, endIndex).trim());
        }
        catch (Exception e) {
            return Result.reportUnHappyCase(null, false, "INT230", e.getMessage());
        }
    }

    public Result isTextContains(String text, String containText) {
        if (text == null) {
            throw new IllegalStateException(StringConstants.COMM_EXC_TEXT_VAL_CANNOT_BE_NULL);
        }
        if (containText == null) {
            throw new IllegalStateException(StringConstants.COMM_EXC_CONTAIN_TEXT_VAL_CANNOT_BE_NULL);
        }
        if (text.toLowerCase().contains(containText.toLowerCase())) {
            return Result.reportHappyCase(true);
        }
        return Result.reportUnHappyCase(false, false, "INT256", text, containText);
    }

    public Result multiply(Object op1, Integer op2) {
        double tmp = Double.parseDouble(op1.toString());
        double result = tmp * (double)op2.intValue();
        return Result.reportHappyCase(result);
    }

    public Result divide(Object op1, Integer op2) {
        double tmp = Double.parseDouble(op1.toString());
        double result = tmp / (double)op2.intValue();
        return Result.reportHappyCase(result);
    }

    public Result add(Object op1, Integer op2) {
        double tmp = Double.parseDouble(op1.toString());
        double result = tmp + (double)op2.intValue();
        return Result.reportHappyCase(result);
    }

    public Result subtract(Object op1, Integer op2) {
        double tmp = Double.parseDouble(op1.toString());
        double result = tmp - (double)op2.intValue();
        return Result.reportHappyCase(result);
    }

    public Result match(String value1, String value2) {
        Result result = new Result();
        try {
            Pattern p = Pattern.compile(value2, 32);
            boolean matches = p.matcher(value1).matches();
            if (matches) {
                result.setReturnValue(true);
            } else {
                result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT262"), value1, value2));
                result.setReturnValue(false);
            }
        }
        catch (Exception e) {
            result.setMessage(String.format(EngineLogger.getLogMessageFromProperties("INT193"), e.getMessage()));
            result.setReturnValue(false);
        }
        return result;
    }

    public void enterUserInfo(String username, String password) throws InterruptedException {
        EKeyboard key = new EKeyboard();
        this.copyDataToClipboard(username);
        key.pressKeys("/tab", true);
        this.copyDataToClipboard(password);
        Thread.sleep(1000L);
        key.pressKeys("/enter", true);
        Thread.sleep(1000L);
    }
}

