/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.webui.driver;

import com.google.gson.JsonIOException;
import com.kms.katalon.core.appium.driver.SwipeableAndroidDriver;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.core.event.TestingEvent;
import com.kms.katalon.core.event.TestingEventType;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.util.internal.ProxyUtil;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.core.webui.constants.CoreWebuiMessageConstants;
import com.kms.katalon.core.webui.constants.StringConstants;
import com.kms.katalon.core.webui.driver.DriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.ExistingRemoteWebDriver;
import com.kms.katalon.core.webui.driver.IDriverConfigurationProvider;
import com.kms.katalon.core.webui.driver.KatalonSmartEventListener;
import com.kms.katalon.core.webui.driver.RemoteHttpClientFactory;
import com.kms.katalon.core.webui.driver.SmartWaitWebDriver;
import com.kms.katalon.core.webui.driver.WebMobileDriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.driver.firefox.CFirefoxDriver47;
import com.kms.katalon.core.webui.driver.firefox.CGeckoDriver;
import com.kms.katalon.core.webui.driver.ie.InternetExploreDriverServiceBuilder;
import com.kms.katalon.core.webui.exception.BrowserNotOpenedException;
import com.kms.katalon.core.webui.util.FileExcutableUtil;
import com.kms.katalon.core.webui.util.FileUtil;
import com.kms.katalon.core.webui.util.FirefoxExecutable;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.core.webui.util.URLUtils;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.selenium.driver.CChromeDriver;
import com.kms.katalon.selenium.driver.CEdgeDriver;
import com.kms.katalon.selenium.driver.CFirefoxDriver;
import com.kms.katalon.selenium.driver.CInternetExplorerDriver;
import com.kms.katalon.selenium.driver.CRemoteWebDriver;
import com.kms.katalon.selenium.driver.CSafariDriver;
import com.kms.katalon.util.CryptoUtil;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.remote.AppiumCommandExecutor;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Alert;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.Platform;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.internal.OkHttpClient;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class DriverFactory {
    private static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 120;
    private static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 10800;
    private static final int DEFAULT_WRITE_TIMEOUT_IN_SECONDS = 0;
    private static final String SMART_WAIT_ADDON_CHROME_RELATIVE_PATH = String.valueOf(File.separator) + "Chrome" + File.separator + "Smart Wait";
    private static final String SMART_WAIT_ADDON_FIREFOX_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "smartwait.xpi";
    private static final String SMART_WAIT_ADDON_EDGE_CHROMIUM_RELATIVE_PATH = String.valueOf(File.separator) + "Edge Chromium" + File.separator + "Smart Wait";
    private static final String SMART_LOCATOR_ADDON_FIREFOX_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "smartlocator.xpi";
    private static final String SMART_LOCATOR_ADDON_RELATIVE_PATH = String.valueOf(File.separator) + "Smart Locator";
    private static final KeywordLogger logger = KeywordLogger.getInstance(DriverFactory.class);
    private static final int USING_MARIONETTEE_VERSION = 47;
    private static final int USING_GECKO_VERSION = 57;
    private static final String CAP_IE_USE_PER_PROCESS_PROXY = "ie.usePerProcessProxy";
    private static final String IE_DRIVER_SERVER_LOG_FILE_NAME = "IEDriverServer.log";
    public static final String WEB_UI_DRIVER_PROPERTY = "WebUI";
    public static final String MOBILE_DRIVER_PROPERTY = "Mobile";
    public static final String REMOTE_DRIVER_PROPERTY = "Remote";
    public static final String EXISTING_DRIVER_PROPERTY = "Existing";
    public static final String APPIUM_LOG_PROPERTY = "appiumLogFile";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_ADROID = "android";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME_IOS = "ios";
    private static final String APPIUM_CAPABILITY_PLATFORM_NAME = "platformName";
    public static final String REMOTE_WEB_DRIVER_TYPE_APPIUM = "Appium";
    public static final String REMOTE_WEB_DRIVER_TYPE_SELENIUM = "Selenium";
    public static final String CHROME_DRIVER_PATH_PROPERTY_KEY = "webdriver.chrome.driver";
    public static final String EDGE_CHROMIUM_DRIVER_PATH_PROPERTY_KEY = "webdriver.edge.driver";
    private static final String IE_DRIVER_PATH_PROPERTY_KEY = "webdriver.ie.driver";
    private static final String JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE = "[JavaScript Error: \"h is null\"";
    public static final String IE_DRIVER_PATH_PROPERTY = "ieDriverPath";
    public static final String EDGE_DRIVER_PATH_PROPERTY = "edgeDriverPath";
    public static final String EDGE_CHROMIUM_DRIVER_PATH_PROPERTY = "edgeChromiumDriverPath";
    public static final String CHROME_DRIVER_PATH_PROPERTY = "chromeDriverPath";
    public static final String WAIT_FOR_IE_HANGING_PROPERTY = "waitForIEHanging";
    public static final String ENABLE_PAGE_LOAD_TIMEOUT = "enablePageLoadTimeout";
    public static final String DEFAULT_PAGE_LOAD_TIMEOUT = "defaultPageLoadTimeout";
    public static final String ACTION_DELAY = "actionDelay";
    public static final String USE_ACTION_DELAY_IN_SECOND = "useActionDelayInSecond";
    public static final String IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION = "ignorePageLoadTimeoutException";
    public static final String EXECUTED_BROWSER_PROPERTY = "browserType";
    public static final String REMOTE_WEB_DRIVER_URL = "remoteWebDriverUrl";
    public static final String REMOTE_WEB_DRIVER_TYPE = "remoteWebDriverType";
    public static final String IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED = "isEncrypted";
    public static final String REMOTE_MOBILE_DRIVER = "remoteMobileDriver";
    public static final String DEBUG_PORT = "debugPort";
    public static final String DEBUG_HOST = "debugHost";
    public static final String DEFAULT_FIREFOX_DEBUG_PORT = "10001";
    public static final String DEFAULT_CHROME_DEBUG_PORT = "10002";
    public static final String DEFAULT_DEBUG_HOST = "localhost";
    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;
    private static final String LOAD_EXTENSION_CHROME_PREFIX = "load-extension=";
    private static final String LOAD_EXTENSION_EDGE_CHROMIUM_PREFIX = "load-extension=";
    private static final ThreadLocal<WebDriver> localWebServerStorage = new ThreadLocal<WebDriver>(){

        @Override
        protected WebDriver initialValue() {
            return null;
        }
    };
    private static final ThreadLocal<EdgeDriverService> localEdgeDriverServiceStorage = new ThreadLocal<EdgeDriverService>(){

        @Override
        protected EdgeDriverService initialValue() {
            return (EdgeDriverService)((EdgeDriverService.Builder)((EdgeDriverService.Builder)new EdgeDriverService.Builder().usingDriverExecutable(new File(DriverFactory.getEdgeDriverPath()))).usingAnyFreePort()).build();
        }
    };
    private static final ThreadLocal<EdgeDriverService> localEdgeChromiumDriverServiceStorage = new ThreadLocal<EdgeDriverService>(){

        @Override
        protected EdgeDriverService initialValue() {
            return (EdgeDriverService)((EdgeDriverService.Builder)((EdgeDriverService.Builder)new EdgeDriverService.Builder().usingDriverExecutable(new File(DriverFactory.getEdgeChromiumDriverPath()))).usingAnyFreePort()).build();
        }
    };
    private static InternetExplorerDriverService ieDriverService;
    private static IDriverConfigurationProvider driverConfigProvider;

    static {
        driverConfigProvider = new DriverConfigurationProvider(logger);
    }

    public static void setDriverConfigurationProvider(IDriverConfigurationProvider provider) {
        driverConfigProvider = provider;
    }

    public static IDriverConfigurationProvider getDriverConfigurationProvider() {
        return driverConfigProvider;
    }

    public static WebDriver openWebDriver() throws Exception {
        try {
            String remoteWebDriverUrl;
            WebDriver webDriver = null;
            webDriver = DriverFactory.isUsingExistingDriver() ? DriverFactory.startExistingBrowser() : (StringUtils.isNotEmpty((CharSequence)(remoteWebDriverUrl = DriverFactory.getRemoteWebDriverServerUrl())) ? DriverFactory.startRemoteBrowser() : DriverFactory.startNewBrowser(DriverFactory.getExecutedBrowser()));
            if (webDriver != null) {
                DriverFactory.changeWebDriver(webDriver);
                DriverFactory.switchToSmartWaitWebDriver(webDriver);
            }
            TestingEvent browserOpenedEvent = new TestingEvent(TestingEventType.BROWSER_OPENED, (Object)webDriver);
            EventBusSingleton.getInstance().getEventBus().post((Object)browserOpenedEvent);
            return webDriver;
        }
        catch (Error e) {
            logger.logMessage(LogLevel.WARNING, e.getMessage(), (Throwable)e);
            throw new StepFailedException((Throwable)e);
        }
    }

    private static void switchToSmartWaitWebDriver(WebDriver webDriver) {
        try {
            SmartWaitWebDriver smartWaitWebDriver = new SmartWaitWebDriver(webDriver);
            smartWaitWebDriver.register(new KatalonSmartEventListener());
            DriverFactory.changeWebDriverWithoutLog((WebDriver)smartWaitWebDriver);
        }
        catch (Exception e) {
            logger.logInfo(e.getMessage());
        }
    }

    public static void changeWebDriver(WebDriver webDriver) {
        DriverFactory.changeWebDriverWithoutLog(webDriver);
        DriverFactory.logBrowserRunData(webDriver);
        DriverFactory.switchToSmartWaitWebDriver(webDriver);
    }

    private static void changeWebDriverWithoutLog(WebDriver webDriver) {
        localWebServerStorage.set(webDriver);
        RunConfiguration.storeDriver((Object)webDriver);
        DriverFactory.setTimeout();
    }

    private static boolean isUsingExistingDriver() {
        return RunConfiguration.getDriverSystemProperties((String)EXISTING_DRIVER_PROPERTY) != null;
    }

    private static WebDriver startRemoteBrowser() throws MalformedURLException, MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException, Exception {
        if (localWebServerStorage.get() != null && DriverFactory.getRemoteSessionId(localWebServerStorage.get()) != null) {
            logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_ALREADY_OPENED);
            DriverFactory.closeWebDriver();
        }
        WebUIDriverType driver = WebUIDriverType.REMOTE_WEB_DRIVER;
        String remoteServerUrl = DriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isEmpty((CharSequence)remoteServerUrl)) {
            return null;
        }
        Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)REMOTE_DRIVER_PROPERTY);
        DesiredCapabilities desireCapibilities = null;
        if (driverPreferenceProps != null) {
            desireCapibilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, driver);
        }
        WebDriver webDriver = DriverFactory.createNewRemoteWebDriver(driverPreferenceProps, desireCapibilities);
        DriverFactory.saveWebDriverSessionData(webDriver);
        DriverFactory.switchToSmartWaitWebDriver(webDriver);
        return webDriver;
    }

    private static WebDriver startNewBrowser(DriverType executedBrowser) throws MalformedURLException, MobileDriverInitializeException, IOException, InterruptedException, AppiumStartException, Exception {
        WebUIDriverType driver = (WebUIDriverType)executedBrowser;
        if (driver == null) {
            throw new StepFailedException(StringConstants.DRI_ERROR_MSG_NO_BROWSER_SET);
        }
        if (localWebServerStorage.get() != null && DriverFactory.getRemoteSessionId(localWebServerStorage.get()) != null) {
            logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_ALREADY_OPENED);
            DriverFactory.closeWebDriver();
        }
        logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_STARTING_DRIVER_X, driver.toString()));
        Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)WEB_UI_DRIVER_PROPERTY);
        DesiredCapabilities desireCapibilities = null;
        if (driverPreferenceProps != null) {
            desireCapibilities = WebDriverPropertyUtil.toDesireCapabilities(driverPreferenceProps, driver);
        }
        WebDriver webDriver = null;
        switch (driver) {
            case FIREFOX_DRIVER: {
                webDriver = DriverFactory.createNewFirefoxDriver(desireCapibilities);
                break;
            }
            case IE_DRIVER: {
                webDriver = DriverFactory.createNewIEDriver(desireCapibilities);
                break;
            }
            case SAFARI_DRIVER: {
                webDriver = DriverFactory.createNewSafariDriver(desireCapibilities);
                break;
            }
            case CHROME_DRIVER: {
                webDriver = DriverFactory.createNewChromeDriver(desireCapibilities);
                break;
            }
            case REMOTE_WEB_DRIVER: 
            case KOBITON_WEB_DRIVER: 
            case TESTCLOUD_DRIVER: {
                webDriver = DriverFactory.createNewRemoteWebDriver(driverPreferenceProps, desireCapibilities);
                break;
            }
            case ANDROID_DRIVER: 
            case IOS_DRIVER: {
                webDriver = WebMobileDriverFactory.createMobileDriver(driver);
                break;
            }
            case EDGE_DRIVER: {
                webDriver = DriverFactory.createNewEdgeDriver(desireCapibilities);
                break;
            }
            case EDGE_CHROMIUM_DRIVER: {
                webDriver = DriverFactory.createNewEdgeChromiumDriver(desireCapibilities);
                break;
            }
            case REMOTE_FIREFOX_DRIVER: {
                webDriver = DriverFactory.createNewRemoteFirefoxDriver(desireCapibilities);
                break;
            }
            case REMOTE_CHROME_DRIVER: {
                webDriver = DriverFactory.createNewRemoteChromeDriver(desireCapibilities);
                break;
            }
            case HEADLESS_DRIVER: {
                webDriver = DriverFactory.createHeadlessChromeDriver(desireCapibilities);
                break;
            }
            case FIREFOX_HEADLESS_DRIVER: {
                webDriver = DriverFactory.createHeadlessFirefoxDriver(desireCapibilities);
                break;
            }
            default: {
                throw new StepFailedException(MessageFormat.format(StringConstants.DRI_ERROR_DRIVER_X_NOT_IMPLEMENTED, driver.getName()));
            }
        }
        DriverFactory.isTimeCapsuleAvailable(driver);
        DriverFactory.saveWebDriverSessionData(webDriver);
        DriverFactory.switchToSmartWaitWebDriver(webDriver);
        return webDriver;
    }

    private static boolean isTimeCapsuleAvailable(WebUIDriverType driver) {
        if (!RunConfiguration.shouldApplyTimeCapsule().booleanValue()) {
            return false;
        }
        switch (driver) {
            case CHROME_DRIVER: 
            case EDGE_CHROMIUM_DRIVER: 
            case HEADLESS_DRIVER: {
                return true;
            }
        }
        KeywordLogger.getInstance(KatalonSmartEventListener.class).logWarning(CoreWebuiMessageConstants.MSG_TIME_CAPSULE_IS_NOT_SUPPORTED_ON_CURRENT_BROWSER);
        return false;
    }

    private static CSafariDriver createNewSafariDriver(DesiredCapabilities desireCapibilities) {
        return new CSafariDriver((Capabilities)desireCapibilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewChromeDriver(DesiredCapabilities desireCapibilities) {
        return new CChromeDriver((Capabilities)DriverFactory.addCapbilitiesForChrome(desireCapibilities), DriverFactory.getActionDelay());
    }

    private static DesiredCapabilities addCapbilitiesForChrome(DesiredCapabilities desiredCapibilities) {
        System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks(proxyInformation)) {
                WebDriverPropertyUtil.addArgumentsForChrome(desiredCapibilities, "--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString(proxyInformation));
            } else {
                desiredCapibilities.setCapability("proxy", DriverFactory.getDefaultProxy());
            }
        }
        DriverFactory.addKatalonExtensionsToChrome(desiredCapibilities);
        return desiredCapibilities;
    }

    private static DesiredCapabilities addKatalonExtensionsToChrome(DesiredCapabilities capabilities) {
        boolean isInstalledKatalonCompactUtility = WebDriverPropertyUtil.didUserProfileInstallKatalonCompactUtility(WebUIDriverType.CHROME_DRIVER, capabilities);
        if (isInstalledKatalonCompactUtility) {
            return capabilities;
        }
        String argumentValue = "load-extension=";
        if (DriverFactory.shouldInstallSmartLocator()) {
            argumentValue = String.valueOf(argumentValue) + DriverFactory.installExtensionFromFile(DriverFactory.getSmartLocatorExtensionFile()) + ",";
        }
        if (DriverFactory.shouldInstallSmartWait()) {
            String pathToSmartWaitExtension = DriverFactory.installExtensionFromFile(DriverFactory.getChromeExtensionFile());
            argumentValue = String.valueOf(argumentValue) + "," + pathToSmartWaitExtension;
        }
        WebDriverPropertyUtil.addArgumentsForChrome(capabilities, argumentValue);
        return capabilities;
    }

    private static String installExtensionFromFile(File file) {
        String pathToExtension = "";
        try {
            if (file != null) {
                pathToExtension = file.getCanonicalPath();
            }
        }
        catch (Exception e) {
            logger.logError(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return pathToExtension;
    }

    private static File getChromeExtensionFile() {
        try {
            return new File(FileUtil.getExtensionsDirectory(), SMART_WAIT_ADDON_CHROME_RELATIVE_PATH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File getEdgeChromiumExtensionFile() {
        try {
            return new File(FileUtil.getExtensionsDirectory(), SMART_WAIT_ADDON_EDGE_CHROMIUM_RELATIVE_PATH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File getSmartLocatorExtensionFile() {
        try {
            return new File(FileUtil.getExtensionsDirectory(), SMART_LOCATOR_ADDON_RELATIVE_PATH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static WebDriver createHeadlessChromeDriver(DesiredCapabilities desireCapibilities) {
        DesiredCapabilities chromeCapbilities = DriverFactory.addCapbilitiesForChrome(desireCapibilities);
        WebDriverPropertyUtil.addArgumentsForChrome(desireCapibilities, "--headless", "disable-gpu");
        return new CChromeDriver((Capabilities)chromeCapbilities, DriverFactory.getActionDelay());
    }

    private static Map<String, Object> getDefaultProxy() {
        return WebDriverProxyUtil.getSeleniumProxy(RunConfiguration.getProxyInformation());
    }

    private static boolean isEdgeBrowser(DesiredCapabilities desiredCapibilities) {
        Set capabilityNames = desiredCapibilities.getCapabilityNames();
        if (capabilityNames.contains("browserName") && desiredCapibilities.getCapability("browserName") instanceof String) {
            return ((String)desiredCapibilities.getCapability("browserName")).toLowerCase().contains("edge");
        }
        if (capabilityNames.contains("browser") && desiredCapibilities.getCapability("browser") instanceof String) {
            return ((String)desiredCapibilities.getCapability("browser")).toLowerCase().contains("edge");
        }
        return false;
    }

    private static WebDriver createNewRemoteWebDriver(Map<String, Object> driverPreferenceProps, DesiredCapabilities desiredCapabilities) throws URISyntaxException, IOException, GeneralSecurityException {
        ProxyInformation proxyInfo;
        String remoteWebServerUrl = DriverFactory.getRemoteWebDriverServerUrl();
        String remoteWebServerType = DriverFactory.getRemoteWebDriverServerType();
        if (remoteWebServerType == null) {
            remoteWebServerType = REMOTE_WEB_DRIVER_TYPE_SELENIUM;
        }
        if ((proxyInfo = RunConfiguration.getProxyInformation()).isApplyToDesiredCapabilities() && !DriverFactory.isEdgeBrowser(desiredCapabilities)) {
            desiredCapabilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        }
        if (!TestCloudPropertyUtil.getInstance().isRunFromTestCloud((Capabilities)desiredCapabilities)) {
            logger.logInfo(MessageFormat.format(StringConstants.XML_LOG_CONNECTING_TO_REMOTE_WEB_SERVER_X_WITH_TYPE_Y, URLUtils.removeCrendentialsFromURL(remoteWebServerUrl), remoteWebServerType));
        }
        if (!remoteWebServerType.equals(REMOTE_WEB_DRIVER_TYPE_APPIUM)) {
            HttpCommandExecutor seleniumExecutor = DriverFactory.getSeleniumExecutorForRemoteDriver(remoteWebServerUrl);
            return new CRemoteWebDriver((CommandExecutor)seleniumExecutor, (Capabilities)desiredCapabilities, DriverFactory.getActionDelay());
        }
        Object platformName = desiredCapabilities.getCapability(APPIUM_CAPABILITY_PLATFORM_NAME);
        if (platformName == null || !(platformName instanceof String)) {
            throw new StepFailedException(MessageFormat.format(StringConstants.DRI_MISSING_PROPERTY_X_FOR_APPIUM_REMOTE_WEB_DRIVER, APPIUM_CAPABILITY_PLATFORM_NAME));
        }
        if (APPIUM_CAPABILITY_PLATFORM_NAME_ADROID.equalsIgnoreCase((String)platformName)) {
            AppiumCommandExecutor appiumExecutor = DriverFactory.getAppiumExecutorForRemoteDriver(remoteWebServerUrl);
            return new SwipeableAndroidDriver((HttpCommandExecutor)appiumExecutor, (Capabilities)desiredCapabilities);
        }
        if (APPIUM_CAPABILITY_PLATFORM_NAME_IOS.equalsIgnoreCase((String)platformName)) {
            AppiumCommandExecutor appiumExecutor = DriverFactory.getAppiumExecutorForRemoteDriver(remoteWebServerUrl);
            return new IOSDriver((HttpCommandExecutor)appiumExecutor, (Capabilities)desiredCapabilities);
        }
        throw new StepFailedException(MessageFormat.format(StringConstants.DRI_PLATFORM_NAME_X_IS_NOT_SUPPORTED_FOR_APPIUM_REMOTE_WEB_DRIVER, platformName));
    }

    private static AppiumCommandExecutor getAppiumExecutorForRemoteDriver(String remoteWebServerUrl) throws URISyntaxException, IOException, GeneralSecurityException {
        URL url = new URL(remoteWebServerUrl);
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        HttpClient.Factory clientFactory = DriverFactory.getClientFactoryForRemoteDriverExecutor(proxyInfo, url);
        AppiumCommandExecutor executor = new AppiumCommandExecutor(MobileCommand.commandRepository, url, clientFactory);
        return executor;
    }

    private static HttpCommandExecutor getSeleniumExecutorForRemoteDriver(String remoteWebServerUrl) throws URISyntaxException, IOException, GeneralSecurityException {
        URL url = new URL(remoteWebServerUrl);
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        HttpClient.Factory clientFactory = DriverFactory.getClientFactoryForRemoteDriverExecutor(proxyInfo, url);
        HttpCommandExecutor executor = new HttpCommandExecutor(new HashMap(), url, clientFactory);
        return executor;
    }

    private static HttpClient.Factory getClientFactoryForRemoteDriverExecutor(ProxyInformation proxyInfo, URL url) throws URISyntaxException, IOException {
        Proxy proxy;
        String[] userInfo;
        String rawTimeout = RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)"readTimeout");
        int readTimeout = rawTimeout != null ? Integer.valueOf(rawTimeout) * 60 : 10800;
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout(120L, TimeUnit.SECONDS).readTimeout((long)readTimeout, TimeUnit.SECONDS).writeTimeout(0L, TimeUnit.SECONDS);
        if (StringUtils.isNotBlank((CharSequence)url.getUserInfo()) && (userInfo = url.getUserInfo().split(":")) != null && userInfo.length == 2) {
            Authenticator basicAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)userInfo[0], (String)userInfo[1]);
                    return response.request().newBuilder().header("Authorization", credential).build();
                }
            };
            client = client.authenticator(basicAuthenticator);
        }
        Proxy proxy2 = proxy = proxyInfo != null ? ProxyUtil.getProxy((ProxyInformation)proxyInfo) : null;
        if (proxy != null) {
            final String proxyUser = proxyInfo.getUsername();
            final String proxyPassword = proxyInfo.getPassword();
            Authenticator proxyAuthenticator = new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)proxyUser, (String)proxyPassword);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            };
            client = client.proxy(proxy).proxyAuthenticator(proxyAuthenticator);
        }
        return new RemoteHttpClientFactory(new OkHttpClient(client.build(), url));
    }

    private static WebDriver createNewRemoteChromeDriver(DesiredCapabilities desireCapibilities) throws MalformedURLException, IOException, Exception {
        String chromeDebugHost = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_HOST, (String)DEFAULT_DEBUG_HOST);
        String chromeDebugPort = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_PORT, (String)DEFAULT_CHROME_DEBUG_PORT);
        System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
        desireCapibilities.merge((Capabilities)DesiredCapabilities.chrome());
        HashMap<String, String> chromeOptions = new HashMap<String, String>();
        chromeOptions.put("debuggerAddress", String.valueOf(chromeDebugHost) + ":" + chromeDebugPort);
        desireCapibilities.setCapability("goog:chromeOptions", chromeOptions);
        int chromeDriverPort = DriverFactory.determineNextFreePort(9515);
        URL chromeDriverUrl = new URL("http", chromeDebugHost, chromeDriverPort, "/");
        Runtime.getRuntime().exec(new String[]{System.getProperty(CHROME_DRIVER_PATH_PROPERTY_KEY), "--port=" + chromeDriverPort});
        DriverFactory.waitForRemoteBrowserReady(chromeDriverUrl);
        return new RemoteWebDriver(chromeDriverUrl, (Capabilities)desireCapibilities);
    }

    private static WebDriver createNewRemoteFirefoxDriver(DesiredCapabilities desireCapibilities) throws MalformedURLException, Exception {
        String fireFoxDebugHost = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_HOST, (String)DEFAULT_DEBUG_HOST);
        String firefoxDebugPort = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)DEBUG_PORT, (String)DEFAULT_FIREFOX_DEBUG_PORT);
        desireCapibilities.merge((Capabilities)DesiredCapabilities.firefox());
        URL firefoxDriverUrl = new URL("http", fireFoxDebugHost, Integer.parseInt(firefoxDebugPort), "/hub");
        RemoteWebDriver webDriver = new RemoteWebDriver(firefoxDriverUrl, (Capabilities)desireCapibilities);
        DriverFactory.waitForRemoteBrowserReady(firefoxDriverUrl);
        return webDriver;
    }

    private static WebDriver createNewEdgeDriver(DesiredCapabilities desiredCapabilities) throws IOException {
        EdgeDriverService edgeService = localEdgeDriverServiceStorage.get();
        if (!edgeService.isRunning()) {
            edgeService.start();
        }
        return new CEdgeDriver(edgeService, (Capabilities)desiredCapabilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewEdgeChromiumDriver(DesiredCapabilities desiredCapabilities) throws IOException {
        EdgeDriverService edgeService = localEdgeChromiumDriverServiceStorage.get();
        if (!edgeService.isRunning()) {
            edgeService.start();
        }
        DriverFactory.addSmartWaitExtensionToEdgeChromium(desiredCapabilities);
        return new CEdgeDriver(edgeService, (Capabilities)desiredCapabilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewIEDriver(DesiredCapabilities desireCapibilities) {
        desireCapibilities.setCapability(CAP_IE_USE_PER_PROCESS_PROXY, "true");
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && !WebDriverProxyUtil.isNoProxy(proxyInformation)) {
            desireCapibilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        }
        ieDriverService = (InternetExplorerDriverService)((InternetExplorerDriverService.Builder)((InternetExplorerDriverService.Builder)new InternetExploreDriverServiceBuilder().withLogLevel(InternetExplorerDriverLogLevel.TRACE).usingDriverExecutable(new File(DriverFactory.getIEDriverPath()))).withLogFile(new File(String.valueOf(RunConfiguration.getLogFolderPath()) + File.separator + IE_DRIVER_SERVER_LOG_FILE_NAME))).build();
        return new CInternetExplorerDriver(ieDriverService, (Capabilities)desireCapibilities, DriverFactory.getActionDelay());
    }

    private static WebDriver createNewFirefoxDriver(DesiredCapabilities desiredCapabilities) {
        int actionDelay = DriverFactory.getActionDelay();
        int firefoxMajorVersion = FirefoxExecutable.getFirefoxVersion(desiredCapabilities);
        DriverFactory.addSmartWaitExtensionToFirefox(desiredCapabilities);
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities()) {
            desiredCapabilities.setCapability("proxy", DriverFactory.getDefaultProxy());
        }
        if (firefoxMajorVersion >= 57) {
            DriverFactory.setFirefoxBinaryForMac(desiredCapabilities);
            return CGeckoDriver.from(desiredCapabilities, actionDelay);
        }
        if (firefoxMajorVersion >= 47) {
            return CFirefoxDriver47.from(desiredCapabilities, actionDelay);
        }
        return CGeckoDriver.from(desiredCapabilities, actionDelay);
    }

    private static void setFirefoxBinaryForMac(DesiredCapabilities desiredCapabilities) {
        if (Platform.getCurrent().is(Platform.MAC)) {
            desiredCapabilities.setCapability("firefox_binary", "/Applications/Firefox.app/Contents/MacOS/firefox");
        }
    }

    private static boolean shouldInstallSmartWait() {
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        return globalSmartWaitEnabled;
    }

    private static boolean shouldInstallSmartLocator() {
        boolean smartLocatorEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("smartLocatorEnabled")).orElse(false);
        return smartLocatorEnabled;
    }

    private static void addSmartWaitExtensionToFirefox(DesiredCapabilities desiredCapabilities) {
        FirefoxProfile firefoxProfile = new FirefoxProfile();
        if (DriverFactory.shouldInstallSmartLocator()) {
            firefoxProfile.addExtension(DriverFactory.getFirefoxSmartLocatorfoxAddonFile());
        }
        if (DriverFactory.shouldInstallSmartWait()) {
            firefoxProfile.addExtension(DriverFactory.getFirefoxAddonFile());
        }
        desiredCapabilities.setCapability("firefox_profile", (Object)firefoxProfile);
    }

    private static DesiredCapabilities addSmartWaitExtensionToEdgeChromium(DesiredCapabilities desiredCapabilities) {
        boolean isInstalledKatalonCompactUtility = WebDriverPropertyUtil.didUserProfileInstallKatalonCompactUtility(WebUIDriverType.EDGE_CHROMIUM_DRIVER, desiredCapabilities);
        if (isInstalledKatalonCompactUtility) {
            return desiredCapabilities;
        }
        String extensions = "load-extension=";
        if (DriverFactory.shouldInstallSmartLocator()) {
            extensions = String.valueOf(extensions) + DriverFactory.installExtensionFromFile(DriverFactory.getSmartLocatorExtensionFile()) + ",";
        }
        if (DriverFactory.shouldInstallSmartWait()) {
            String pathToSmartWaitExtension = DriverFactory.installExtensionFromFile(DriverFactory.getEdgeChromiumExtensionFile());
            extensions = String.valueOf(extensions) + pathToSmartWaitExtension;
        }
        WebDriverPropertyUtil.addArgumentsForEdgeChromium(desiredCapabilities, extensions);
        return desiredCapabilities;
    }

    private static File getFirefoxAddonFile() {
        try {
            return new File(FileUtil.getExtensionsDirectory(), SMART_WAIT_ADDON_FIREFOX_RELATIVE_PATH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File getFirefoxSmartLocatorfoxAddonFile() {
        try {
            return new File(FileUtil.getExtensionsDirectory(), SMART_LOCATOR_ADDON_FIREFOX_RELATIVE_PATH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static WebDriver createHeadlessFirefoxDriver(DesiredCapabilities desiredCapibilities) {
        FirefoxOptions firefoxOptions = new FirefoxOptions((Capabilities)desiredCapibilities);
        firefoxOptions.setHeadless(true);
        return DriverFactory.createNewFirefoxDriver(new DesiredCapabilities(firefoxOptions.asMap()));
    }

    private static void saveWebDriverSessionData(WebDriver webDriver) {
        block21: {
            if (!(webDriver instanceof RemoteWebDriver) || webDriver instanceof ExistingRemoteWebDriver || webDriver instanceof SafariDriver) {
                return;
            }
            RemoteWebDriver remoteWebDriver = (RemoteWebDriver)webDriver;
            Socket myClient = null;
            PrintStream output = null;
            try {
                try {
                    myClient = new Socket(RunConfiguration.getSessionServerHost(), RunConfiguration.getSessionServerPort());
                    output = new PrintStream(myClient.getOutputStream());
                    output.println(remoteWebDriver.getSessionId());
                    output.println(DriverFactory.getWebDriverServerUrl(remoteWebDriver));
                    DriverType remoteDriverType = DriverFactory.getExecutedBrowser();
                    output.println(remoteDriverType);
                    output.println(RunConfiguration.getLogFolderPath());
                    if (remoteDriverType == WebUIDriverType.ANDROID_DRIVER) {
                        output.println(String.valueOf(WebMobileDriverFactory.getDeviceManufacturer()) + " " + WebMobileDriverFactory.getDeviceModel() + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    } else if (remoteDriverType == WebUIDriverType.IOS_DRIVER) {
                        output.println(String.valueOf(WebMobileDriverFactory.getDeviceName()) + " " + WebMobileDriverFactory.getDeviceOSVersion());
                    }
                    output.flush();
                }
                catch (Exception exception) {
                    if (myClient != null) {
                        try {
                            myClient.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        output.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (myClient != null) {
                    try {
                        myClient.close();
                    }
                    catch (IOException iOException) {}
                }
                if (output != null) {
                    output.close();
                }
                throw throwable;
            }
            if (myClient != null) {
                try {
                    myClient.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static String getWebDriverServerUrl(RemoteWebDriver remoteWebDriver) {
        CommandExecutor commandExecutor = remoteWebDriver.getCommandExecutor();
        if (commandExecutor instanceof HttpCommandExecutor) {
            return ((HttpCommandExecutor)commandExecutor).getAddressOfRemoteServer().toString();
        }
        return "";
    }

    protected static WebDriver startExistingBrowser() throws MalformedURLException, MobileDriverInitializeException, ConnectException {
        String remoteDriverType = RunConfiguration.getExistingSessionDriverType();
        String sessionId = RunConfiguration.getExistingSessionSessionId();
        String remoteServerUrl = RunConfiguration.getExistingSessionServerUrl();
        if (WebUIDriverType.ANDROID_DRIVER.toString().equals(remoteDriverType) || WebUIDriverType.IOS_DRIVER.toString().equals(remoteDriverType)) {
            return WebMobileDriverFactory.startExisitingMobileDriver(WebUIDriverType.fromStringValue(remoteDriverType), sessionId, remoteServerUrl);
        }
        ExistingRemoteWebDriver driver = new ExistingRemoteWebDriver(new URL(remoteServerUrl), sessionId);
        DriverFactory.switchToSmartWaitWebDriver((WebDriver)driver);
        return driver;
    }

    private static void logBrowserRunData(WebDriver webDriver) {
        if (webDriver == null) {
            return;
        }
        String serverUrl = DriverFactory.getRemoteWebDriverServerUrl();
        if (StringUtils.isNotEmpty((CharSequence)serverUrl) && webDriver instanceof RemoteWebDriver) {
            String testCloudRemoteOS = RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)"testCloudRemoteOS");
            RemoteWebDriver remoteDriver = (RemoteWebDriver)webDriver;
            Capabilities driverCapabilities = remoteDriver.getCapabilities();
            HashMap driverCapabilitiesMapAsDisplay = new HashMap(driverCapabilities.asMap());
            Map driverPreferenceProps = RunConfiguration.getDriverPreferencesProperties((String)REMOTE_DRIVER_PROPERTY);
            DesiredCapabilities inputDesireCapibilities = null;
            if (driverPreferenceProps != null) {
                inputDesireCapibilities = new DesiredCapabilities(driverPreferenceProps);
                if (testCloudRemoteOS != null) {
                    driverCapabilitiesMapAsDisplay.put("deviceName", driverPreferenceProps.get("deviceName"));
                    if (DriverFactory.getBrowserVersion(webDriver).split(" ").length > 1) {
                        driverCapabilitiesMapAsDisplay.put("browserVersion", DriverFactory.getBrowserVersion(webDriver).split(" ")[1]);
                    }
                }
            }
            if (testCloudRemoteOS != null) {
                logger.logRunData("remoteDriverUrl", URLUtils.removeCrendentialsFromURL(serverUrl));
                logger.logRunData("remoteOS", testCloudRemoteOS);
                TestCloudPropertyUtil.getInstance().setRunFromTestCloud(driverCapabilitiesMapAsDisplay);
            } else if (!TestCloudPropertyUtil.getInstance().isRunFromTestCloud((Capabilities)inputDesireCapibilities)) {
                logger.logRunData("remoteDriverUrl", serverUrl);
            }
            if (TestCloudPropertyUtil.getInstance().isRunFromTestCloud()) {
                String log = JsonUtil.toJson((Object)TestCloudPropertyUtil.getInstance().hideTestCloudSensitiveDesiredCapabilities(driverCapabilitiesMapAsDisplay));
                log = TestCloudPropertyUtil.getInstance().hideSauceLabsDocumentLink(log);
                logger.logRunData("desiredCapabilities", log);
            } else {
                try {
                    logger.logRunData("desiredCapabilities", JsonUtil.toJson(driverCapabilitiesMapAsDisplay));
                }
                catch (JsonIOException jsonIOException) {
                    try {
                        logger.logRunData("desiredCapabilities", JsonUtil.toJson(driverCapabilitiesMapAsDisplay, (boolean)true, (boolean)true));
                    }
                    catch (JsonIOException jsex) {
                        logger.logInfo("Cannot parse driverCapabilities to json - " + jsex.getMessage());
                    }
                }
            }
        }
        logger.logRunData("sessionId", DriverFactory.getRemoteSessionId(webDriver).toString());
        logger.logRunData("browser", DriverFactory.getBrowserVersion(webDriver));
        logger.logRunData("platform", webDriver.getClass() == RemoteWebDriver.class ? ((RemoteWebDriver)webDriver).getCapabilities().getPlatform().toString() : System.getProperty("os.name"));
        logger.logRunData("seleniumVersion", new BuildInfo().getReleaseLabel());
        ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
        proxyInfo.setPassword("******");
        logger.logRunData("proxyInformation", proxyInfo.toString());
    }

    public static String getBrowserVersion(WebDriver webDriver) {
        try {
            return WebUiCommonHelper.getBrowserAndVersion(webDriver);
        }
        catch (Exception e) {
            e = ExceptionsUtil.customException((Exception)e);
            e.printStackTrace();
            return "";
        }
    }

    public static WebDriver openWebDriver(DriverType driver, Object options) throws Exception {
        block14: {
            try {
                if (driver instanceof WebUIDriverType) break block14;
                return null;
            }
            catch (Error e) {
                logger.logMessage(LogLevel.WARNING, e.getMessage(), (Throwable)e);
                throw new StepFailedException((Throwable)e);
            }
        }
        DriverFactory.closeWebDriver();
        CSafariDriver webDriver = null;
        WebUIDriverType webUIDriver = (WebUIDriverType)driver;
        switch (webUIDriver) {
            case FIREFOX_DRIVER: {
                if (options instanceof FirefoxProfile var4_6) {
                    DesiredCapabilities desiredCapabilities = DesiredCapabilities.firefox();
                    desiredCapabilities.setCapability("firefox_profile", (Object)firefoxProfile);
                    webDriver = DriverFactory.createNewFirefoxDriver(desiredCapabilities);
                    break;
                }
                if (options instanceof DesiredCapabilities desiredCapabilities) {
                    System.setProperty("webdriver.gecko.driver", DriverFactory.getGeckoDriverPath());
                    DriverFactory.setFirefoxBinaryForMac(desiredCapabilities);
                    webDriver = new CFirefoxDriver(GeckoDriverService.createDefaultService(), (Capabilities)desiredCapabilities);
                    break;
                }
                webDriver = new CFirefoxDriver((Capabilities)DesiredCapabilities.firefox(), DriverFactory.getActionDelay());
                break;
            }
            case IE_DRIVER: {
                System.setProperty(IE_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getIEDriverPath());
                if (options instanceof DesiredCapabilities) {
                    webDriver = new InternetExplorerDriver(new InternetExplorerOptions((Capabilities)options));
                    break;
                }
                webDriver = new InternetExplorerDriver();
                break;
            }
            case SAFARI_DRIVER: {
                if (!(options instanceof DesiredCapabilities)) break;
                webDriver = DriverFactory.createNewSafariDriver((DesiredCapabilities)options);
                break;
            }
            case CHROME_DRIVER: {
                System.setProperty(CHROME_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getChromeDriverPath());
                if (!(options instanceof DesiredCapabilities)) break;
                CChromeDriver chromeDriver = new CChromeDriver((Capabilities)((DesiredCapabilities)options), 0);
                return chromeDriver;
            }
            case EDGE_CHROMIUM_DRIVER: {
                System.setProperty(EDGE_CHROMIUM_DRIVER_PATH_PROPERTY_KEY, DriverFactory.getEdgeChromiumDriverPath());
                if (!(options instanceof DesiredCapabilities)) break;
                EdgeDriverService edgeService = localEdgeChromiumDriverServiceStorage.get();
                if (!edgeService.isRunning()) {
                    edgeService.start();
                }
                return new CEdgeDriver(edgeService, (Capabilities)((DesiredCapabilities)options), DriverFactory.getActionDelay());
            }
            default: {
                throw new StepFailedException(MessageFormat.format(StringConstants.DRI_ERROR_DRIVER_X_NOT_IMPLEMENTED, driver.getName()));
            }
        }
        localWebServerStorage.set((WebDriver)webDriver);
        DriverFactory.setTimeout();
        return webDriver;
    }

    private static void setTimeout() {
        WebDriver webDriver = localWebServerStorage.get();
        if (webDriver instanceof EdgeDriver) {
            return;
        }
        WebDriver.Timeouts timeouts = webDriver.manage().timeouts();
        timeouts.implicitlyWait(0L, TimeUnit.SECONDS);
        if (DriverFactory.isEnablePageLoadTimeout()) {
            timeouts.pageLoadTimeout((long)DriverFactory.getDefaultPageLoadTimeout(), TimeUnit.SECONDS);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static WebDriver getWebDriver() throws StepFailedException, WebDriverException {
        block4: {
            try {
                DriverFactory.verifyWebDriver();
                break block4;
            }
            catch (BrowserNotOpenedException e) {
                var4_1 = RunConfiguration.getStoredDrivers();
                var3_2 = var4_1.length;
                var2_3 = 0;
                ** while (var2_3 < var3_2)
            }
lbl-1000:
            // 1 sources

            {
                driverObject = var4_1[var2_3];
                if (driverObject instanceof RemoteWebDriver) {
                    return (RemoteWebDriver)driverObject;
                }
                ++var2_3;
                continue;
            }
lbl14:
            // 1 sources

            throw e;
        }
        return DriverFactory.localWebServerStorage.get();
    }

    private static void verifyWebDriver() throws StepFailedException, WebDriverException {
        block3: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverFactory.verifyWebDriverIsOpen();
            try {
                if (DriverFactory.getRemoteSessionId(localWebServerStorage.get()) == null) {
                    DriverFactory.switchToAvailableWindow();
                }
            }
            catch (WebDriverException e) {
                if (e instanceof NoSuchWindowException || e.getMessage() == null || e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) break block3;
                throw e;
            }
        }
    }

    private static void verifyWebDriverIsOpen() throws WebDriverException {
        if (localWebServerStorage.get() == null) {
            throw new BrowserNotOpenedException();
        }
    }

    public static Alert getAlert() throws WebDriverException {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        Alert alert = null;
        if (DriverFactory.getExecutedBrowser() == WebUIDriverType.IE_DRIVER) {
            final WebDriver ieDriver = localWebServerStorage.get();
            Thread ieSafeThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            ieDriver.switchTo().alert();
                        }
                        catch (Exception e) {
                            if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(DriverFactory.JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                                throw e;
                            }
                            DriverFactory.switchToAvailableWindow();
                            ieDriver.switchTo().alert();
                        }
                    }
                    catch (WebDriverException webDriverException) {}
                }
            });
            ieSafeThread.start();
            float count = 0.0f;
            while (ieSafeThread.isAlive()) {
                if (count > (float)DriverFactory.getWaitForIEHanging()) {
                    ieSafeThread.interrupt();
                    throw new StepFailedException(MessageFormat.format(StringConstants.DRI_MSG_UNABLE_REACH_WEB_DRI_TIMEOUT, RunConfiguration.getTimeOut()));
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                count = (float)((double)count + 0.1);
            }
        }
        try {
            try {
                alert = localWebServerStorage.get().switchTo().alert();
            }
            catch (Exception e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith(JAVA_SCRIPT_ERROR_H_IS_NULL_MESSAGE)) {
                    throw e;
                }
                DriverFactory.switchToAvailableWindow();
                alert = localWebServerStorage.get().switchTo().alert();
            }
            return alert;
        }
        catch (NoAlertPresentException noAlertPresentException) {
            return null;
        }
    }

    public static boolean waitForAlert(int timeOut) {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        float count = 0.0f;
        long miliseconds = System.currentTimeMillis();
        while (count < (float)timeOut) {
            Alert alert = DriverFactory.getAlert();
            if (alert != null) {
                return true;
            }
            count += (float)((System.currentTimeMillis() - miliseconds) / 1000L);
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            count = (float)((double)count + 0.5);
            miliseconds = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static void switchToAvailableWindow() {
        block6: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverFactory.verifyWebDriverIsOpen();
            try {
                DriverFactory.localWebServerStorage.get().switchTo().window("");
                break block6;
            }
            catch (WebDriverException e) {
                if (!(e instanceof NoSuchWindowException) && e.getMessage() != null && !e.getMessage().startsWith("[JavaScript Error: \"h is null\"")) {
                    throw e;
                }
                availableWindows = DriverFactory.localWebServerStorage.get().getWindowHandles();
                ** for (windowId : availableWindows)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    DriverFactory.localWebServerStorage.get().switchTo().window(windowId);
                    return;
                }
                catch (WebDriverException exception) {
                    if (exception instanceof NoSuchWindowException || e.getMessage() == null || exception.getMessage().startsWith("[JavaScript Error: \"h is null\"")) continue;
                    throw exception;
                }
            }
        }
    }

    public static int getCurrentWindowIndex() {
        DriverFactory.startExistingBrowserIfPossible();
        DriverFactory.verifyWebDriverIsOpen();
        String currentWindowHandle = localWebServerStorage.get().getWindowHandle();
        Set availableWindowHandles = localWebServerStorage.get().getWindowHandles();
        int count = 0;
        for (String windowHandle : availableWindowHandles) {
            if (windowHandle.equals(currentWindowHandle)) {
                return count;
            }
            ++count;
        }
        throw new StepFailedException(StringConstants.XML_LOG_ERROR_CANNOT_FOUND_WINDOW_HANDLE);
    }

    private static void startExistingBrowserIfPossible() {
        if (DriverFactory.isUsingExistingDriver() && localWebServerStorage.get() == null) {
            try {
                WebDriver webDriver = DriverFactory.startExistingBrowser();
                DriverFactory.changeWebDriver(webDriver);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (ConnectException connectException) {
            }
            catch (MobileDriverInitializeException mobileDriverInitializeException) {}
        }
    }

    private static String getIEDriverPath() {
        if (OSUtil.is64Bit()) {
            File customIELocation = new File(RunConfiguration.getProjectDir(), "Include/drivers/iedriver_win64/IEDriverServer.exe");
            if (customIELocation.exists()) {
                logger.logInfo("Custom IEDriverServer detected at location: " + customIELocation.getAbsolutePath());
                return customIELocation.getAbsolutePath();
            }
        } else {
            File customIELocationWin32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/iedriver_win32/IEDriverServer.exe");
            if (customIELocationWin32.exists()) {
                logger.logInfo("Custom IEDriverServer detected at location: " + customIELocationWin32.getAbsolutePath());
                return customIELocationWin32.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)IE_DRIVER_PATH_PROPERTY);
    }

    private static String getEdgeDriverPath() {
        if (OSUtil.is64Bit()) {
            File customEdgeLocation = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgedriver_win64/MicrosoftWebDriver.exe");
            if (customEdgeLocation.exists()) {
                logger.logInfo("Custom edgedriver detected at location: " + customEdgeLocation.getAbsolutePath());
                return customEdgeLocation.getAbsolutePath();
            }
        } else {
            File customEdgeLocationWin32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgedriver_win32/MicrosoftWebDriver.exe");
            if (customEdgeLocationWin32.exists()) {
                logger.logInfo("Custom edgedriver detected at location: " + customEdgeLocationWin32.getAbsolutePath());
                return customEdgeLocationWin32.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)EDGE_DRIVER_PATH_PROPERTY);
    }

    private static String getEdgeChromiumDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File customDriverLocationWin64 = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_win64/msedgedriver.exe");
                if (customDriverLocationWin64.exists()) {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + customDriverLocationWin64.getAbsolutePath());
                    return customDriverLocationWin64.getAbsolutePath();
                }
            } else {
                File customDriverLocationWin32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_win32/msedgedriver.exe");
                if (customDriverLocationWin32.exists()) {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + customDriverLocationWin32.getAbsolutePath());
                    return customDriverLocationWin32.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File customDriverLocationMac = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_mac/msedgedriver");
            if (customDriverLocationMac.exists()) {
                String customDriverPath = customDriverLocationMac.getAbsolutePath();
                try {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + customDriverLocationMac.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(customDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Edge Chromium driver file : " + customDriverPath + " excutable");
                }
                return customDriverPath;
            }
        } else {
            File customDriverLocationLinux = new File(RunConfiguration.getProjectDir(), "Include/drivers/edgechromiumdriver_linux64/msedgedriver");
            if (customDriverLocationLinux.exists()) {
                String customDriverPath = customDriverLocationLinux.getAbsolutePath();
                try {
                    logger.logInfo("Custom Edge Chromium driver detected at location: " + customDriverLocationLinux.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(customDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make Edge Chromium driver file : " + customDriverPath + " excutable");
                }
                return customDriverLocationLinux.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)EDGE_CHROMIUM_DRIVER_PATH_PROPERTY);
    }

    public static String getChromeDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File customeChromeLocation = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_win64/chromedriver.exe");
                if (customeChromeLocation.exists()) {
                    logger.logInfo("Custom chrome detected at location: " + customeChromeLocation.getAbsolutePath());
                    return customeChromeLocation.getAbsolutePath();
                }
            } else {
                File customChromeLocationWin32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_win32/chromedriver.exe");
                if (customChromeLocationWin32.exists()) {
                    logger.logInfo("Custom chrome detected at location: " + customChromeLocationWin32.getAbsolutePath());
                    return customChromeLocationWin32.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File customeChromeLocationMac = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_mac64/chromedriver");
            String chromeDriverPath = customeChromeLocationMac.getAbsolutePath();
            if (customeChromeLocationMac.exists()) {
                try {
                    logger.logInfo("Custom chrome detected at location: " + customeChromeLocationMac.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make chromedriver file : " + customeChromeLocationMac.getAbsolutePath() + "excutable");
                }
                return customeChromeLocationMac.getAbsolutePath();
            }
        } else if (OSUtil.is64Bit()) {
            File customeChromeLocationLinux = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_linux64/chromedriver");
            String chromeDriverPath = customeChromeLocationLinux.getAbsolutePath();
            if (customeChromeLocationLinux.exists()) {
                try {
                    logger.logInfo("Custom chrome detected at location: " + customeChromeLocationLinux.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make chromedriver file :" + customeChromeLocationLinux.getAbsolutePath() + " excutable");
                }
                return customeChromeLocationLinux.getAbsolutePath();
            }
        } else {
            File customChromeLocationLinux32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/chromedriver_linux32/chromedriver");
            String chromeDriverPath = customChromeLocationLinux32.getAbsolutePath();
            if (customChromeLocationLinux32.exists()) {
                try {
                    logger.logInfo("Custom chrome detected at location: " + customChromeLocationLinux32.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(chromeDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make chromedriver file :" + customChromeLocationLinux32.getAbsolutePath() + "excutable");
                }
                return customChromeLocationLinux32.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)CHROME_DRIVER_PATH_PROPERTY);
    }

    public static String getGeckoDriverPath() {
        if (OSUtil.isWindows()) {
            if (OSUtil.is64Bit()) {
                File customeGeckoLocation = new File(RunConfiguration.getProjectDir(), "Include/drivers/geckodriver_win64/geckodriver.exe");
                if (customeGeckoLocation.exists()) {
                    logger.logInfo("Custom gecko detected at location: " + customeGeckoLocation.getAbsolutePath());
                    return customeGeckoLocation.getAbsolutePath();
                }
            } else {
                File customChromeLocationWin32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/geckodriver_win32/geckodriver.exe");
                if (customChromeLocationWin32.exists()) {
                    logger.logInfo("Custom gecko detected at location: " + customChromeLocationWin32.getAbsolutePath());
                    return customChromeLocationWin32.getAbsolutePath();
                }
            }
        } else if (OSUtil.isMac()) {
            File customeGeckoLocationMac = new File(RunConfiguration.getProjectDir(), "Include/drivers/geckodriver_mac64/geckodriver");
            String geckoDriverPath = customeGeckoLocationMac.getAbsolutePath();
            if (customeGeckoLocationMac.exists()) {
                try {
                    logger.logInfo("Custom gecko detected at location: " + customeGeckoLocationMac.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make geckodriver file : " + customeGeckoLocationMac.getAbsolutePath() + " excutable");
                }
                return customeGeckoLocationMac.getAbsolutePath();
            }
        } else if (OSUtil.is64Bit()) {
            File customeGeckoLocationLinux = new File(RunConfiguration.getProjectDir(), "Include/drivers/geckodriver_linux64/geckodriver");
            String geckoDriverPath = customeGeckoLocationLinux.getAbsolutePath();
            if (customeGeckoLocationLinux.exists()) {
                try {
                    logger.logInfo("Custom gecko detected at location: " + customeGeckoLocationLinux.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make geckodriver file : " + customeGeckoLocationLinux.getAbsolutePath() + " excutable");
                }
                return customeGeckoLocationLinux.getAbsolutePath();
            }
        } else {
            File customGeckoLocationLinux32 = new File(RunConfiguration.getProjectDir(), "Include/drivers/geckodriver_linux32/geckodriver");
            String geckoDriverPath = customGeckoLocationLinux32.getAbsolutePath();
            if (customGeckoLocationLinux32.exists()) {
                try {
                    logger.logInfo("Custom gecko detected at location: " + customGeckoLocationLinux32.getAbsolutePath());
                    FileExcutableUtil.makeFileExecutable(geckoDriverPath);
                }
                catch (IOException iOException) {
                    logger.logInfo("Cannot make geckodriver file : " + customGeckoLocationLinux32.getAbsolutePath() + " excutable");
                }
                return customGeckoLocationLinux32.getAbsolutePath();
            }
        }
        return RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)"geckoDriverPath");
    }

    private static int getWaitForIEHanging() {
        if (DriverFactory.getExecutedBrowser() != WebUIDriverType.IE_DRIVER) {
            throw new IllegalArgumentException(StringConstants.XML_LOG_ERROR_BROWSER_NOT_IE);
        }
        return Integer.parseInt(RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)WAIT_FOR_IE_HANGING_PROPERTY));
    }

    public static boolean isEnablePageLoadTimeout() {
        return RunConfiguration.getBooleanProperty((String)ENABLE_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getDefaultPageLoadTimeout() {
        return RunConfiguration.getIntProperty((String)DEFAULT_PAGE_LOAD_TIMEOUT, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static int getActionDelay() {
        return driverConfigProvider.getActionDelayInMilisecond();
    }

    public static boolean isIgnorePageLoadTimeoutException() {
        return RunConfiguration.getBooleanProperty((String)IGNORE_PAGE_LOAD_TIMEOUT_EXCEPTION, (Map)RunConfiguration.getExecutionGeneralProperties());
    }

    public static DriverType getExecutedBrowser() {
        WebUIDriverType webDriverType = null;
        if (DriverFactory.isUsingExistingDriver()) {
            webDriverType = WebUIDriverType.fromStringValue(RunConfiguration.getExistingSessionDriverType());
        }
        if (webDriverType != null) {
            return webDriverType;
        }
        String driverTypeString = RunConfiguration.getDriverSystemProperty((String)WEB_UI_DRIVER_PROPERTY, (String)EXECUTED_BROWSER_PROPERTY);
        if (driverTypeString != null) {
            webDriverType = WebUIDriverType.valueOf(driverTypeString);
        }
        if (webDriverType == null && RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform") != null) {
            webDriverType = WebUIDriverType.valueOf(RunConfiguration.getDriverSystemProperty((String)MOBILE_DRIVER_PROPERTY, (String)"devicePlatform"));
        }
        return webDriverType;
    }

    public static String getRemoteWebDriverServerUrl() {
        boolean isEncrypted;
        String remoteServerUrl = RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)REMOTE_WEB_DRIVER_URL);
        Map jsonObjProperties = RunConfiguration.getDriverSystemProperties((String)REMOTE_DRIVER_PROPERTY);
        if (jsonObjProperties != null && (isEncrypted = RunConfiguration.getBooleanProperty((String)IS_REMOTE_WEB_DRIVER_URL_ENCRYPTED, (Map)jsonObjProperties))) {
            try {
                remoteServerUrl = CryptoUtil.decode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)remoteServerUrl));
            }
            catch (IOException | GeneralSecurityException exception) {
                LogUtil.logError((Throwable)exception);
            }
        }
        return remoteServerUrl;
    }

    public static String getRemoteWebDriverServerType() {
        return RunConfiguration.getDriverSystemProperty((String)REMOTE_DRIVER_PROPERTY, (String)REMOTE_WEB_DRIVER_TYPE);
    }

    public static void closeWebDriver() {
        WebDriver webDriver;
        block12: {
            DriverFactory.startExistingBrowserIfPossible();
            DriverType driverType = DriverFactory.getExecutedBrowser();
            if (driverType == WebUIDriverType.IE_DRIVER) {
                DriverFactory.quitIE();
                return;
            }
            webDriver = localWebServerStorage.get();
            if (webDriver != null && DriverFactory.getRemoteSessionId(webDriver) != null) {
                try {
                    webDriver.quit();
                    if (!(driverType instanceof WebUIDriverType)) break block12;
                    switch ((WebUIDriverType)driverType) {
                        case ANDROID_DRIVER: 
                        case IOS_DRIVER: {
                            WebMobileDriverFactory.closeDriver();
                            break;
                        }
                        case EDGE_DRIVER: {
                            EdgeDriverService edgeDriverService = localEdgeDriverServiceStorage.get();
                            if (edgeDriverService.isRunning()) {
                                edgeDriverService.stop();
                            }
                            break;
                        }
                        case EDGE_CHROMIUM_DRIVER: {
                            EdgeDriverService edgeChromiumDriverService = localEdgeChromiumDriverServiceStorage.get();
                            if (edgeChromiumDriverService.isRunning()) {
                                edgeChromiumDriverService.stop();
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (UnreachableBrowserException e) {
                    logger.logWarning(StringConstants.DRI_LOG_WARNING_BROWSER_NOT_REACHABLE, null, (Throwable)e);
                }
                catch (UnsupportedCommandException e) {
                    String message = e.getMessage();
                    if (!StringUtils.isNotEmpty((CharSequence)message)) break block12;
                    logger.logDebug(message);
                }
            }
        }
        localWebServerStorage.set(null);
        RunConfiguration.removeDriver((Object)webDriver);
    }

    private static void quitIE() {
        try {
            WebDriver webDriver = localWebServerStorage.get();
            if (webDriver != null && DriverFactory.getRemoteSessionId(webDriver) != null) {
                webDriver.quit();
            }
        }
        catch (UnreachableBrowserException unreachableBrowserException) {}
        DriverFactory.quitIEDriverServer();
    }

    private static void quitIEDriverServer() {
        if (ieDriverService == null) {
            return;
        }
        ieDriverService.stop();
    }

    private static void waitForRemoteBrowserReady(URL url) throws Exception {
        long waitUntil = System.currentTimeMillis() + 60000L;
        boolean connectable = false;
        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            }
            catch (IOException iOException) {}
            if (waitUntil < System.currentTimeMillis()) {
                throw new Exception(String.format("Unable to connect to browser on host %s and port %s after %s seconds.", url.getHost(), url.getPort(), 60000));
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int determineNextFreePort(int port) {
        networkUtils = new NetworkUtils();
        newport = port;
        while (newport < port + 2000) {
            block13: {
                address = new InetSocketAddress(networkUtils.obtainLoopbackIp4Address(), newport);
                socket = null;
                socket = new Socket();
                socket.bind(address);
                var6_5 = newport;
                if (socket == null) break block13;
                try {
                    socket.close();
                }
                catch (IOException v0) {}
            }
            return var6_5;
            catch (IOException v1) {
                try {
                    ** if (socket == null) goto lbl-1000
                }
                catch (Throwable var5_6) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException v3) {}
                    }
                    throw var5_6;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        socket.close();
                    }
                    catch (IOException v2) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            ++newport;
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", new Object[]{port, newport}));
    }

    private static SessionId getRemoteSessionId(WebDriver webDriver) {
        try {
            WebDriver wrappedWebDriver;
            if (webDriver instanceof EventFiringWebDriver && (wrappedWebDriver = ((EventFiringWebDriver)webDriver).getWrappedDriver()) instanceof RemoteWebDriver) {
                return ((RemoteWebDriver)wrappedWebDriver).getSessionId();
            }
            if (webDriver instanceof RemoteWebDriver) {
                return ((RemoteWebDriver)webDriver).getSessionId();
            }
        }
        catch (Exception e) {
            logger.logInfo(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return null;
    }
}

