/*
 * Decompiled with CFR 0.152.
 */
package jd.ide.eclipse.editors;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import jd.commonide.IdeDecompiler;
import jd.commonide.preferences.IdePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompilerSourceMapper;

public abstract class JDSourceMapper
extends BaseDecompilerSourceMapper {
    private static final String JAVA_CLASS_SUFFIX = ".class";
    private static final String JAVA_SOURCE_SUFFIX = ".java";
    private static final int JAVA_SOURCE_SUFFIX_LENGTH = 5;
    private File basePath;

    public JDSourceMapper(File basePath, IPath sourcePath, String sourceRootPath, Map options) {
        super(sourcePath, sourceRootPath, options);
        this.basePath = basePath;
    }

    public char[] findSource(String javaSourcePath) {
        char[] source = null;
        if (this.rootPaths == null) {
            source = super.findSource(javaSourcePath);
        } else {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext() && source == null) {
                String sourcesRootPath = (String)iterator.next();
                source = super.findSource(String.valueOf(sourcesRootPath) + '/' + javaSourcePath);
            }
        }
        if (source == null && javaSourcePath.endsWith(JAVA_SOURCE_SUFFIX)) {
            String classPath = String.valueOf(javaSourcePath.substring(0, javaSourcePath.length() - 5)) + JAVA_CLASS_SUFFIX;
            try {
                String result = this.decompile(this.basePath.getAbsolutePath(), classPath);
                if (result != null) {
                    source = result.toCharArray();
                }
            }
            catch (Exception e) {
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.sf.feeling.decompiler", 0, e.getMessage(), (Throwable)e));
            }
        }
        return source;
    }

    public String decompile(String basePath, String classPath) {
        IPreferenceStore store = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        boolean showDefaultConstructor = false;
        boolean realignmentLineNumber = store.getBoolean("jd.ide.eclipse.prefs.RealignLineNumbers");
        boolean showPrefixThis = false;
        boolean mergeEmptyLines = false;
        boolean unicodeEscape = false;
        boolean showLineNumbers = store.getBoolean("jd.ide.eclipse.prefs.DisplayLineNumbers");
        boolean showMetadata = store.getBoolean("jd.ide.eclipse.prefs.DisplayMetadata");
        IdePreferences preferences = new IdePreferences(showDefaultConstructor, realignmentLineNumber, showPrefixThis, mergeEmptyLines, unicodeEscape, showLineNumbers, showMetadata);
        return IdeDecompiler.decompile((IdePreferences)preferences, (String)basePath, (String)classPath);
    }

    public static String getVersion() {
        return "0.7.1";
    }
}

