/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.jd.decompiler;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.ide.eclipse.editors.JDSourceMapper;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.JarClassExtractor;
import org.sf.feeling.decompiler.util.UIUtil;

public class JDCoreDecompiler
implements IDecompiler {
    private String source = "";
    private long time;
    private long start;
    private String log = "";
    private JDSourceMapper mapper;

    public JDCoreDecompiler(JDSourceMapper mapper) {
        this.mapper = mapper;
    }

    public void decompile(String root, String classPackage, String className) {
        this.start = System.currentTimeMillis();
        this.log = "";
        this.source = "";
        Boolean displayNumber = null;
        File workingDir = new File(root);
        File zipFile = new File(System.getProperty("java.io.tmpdir"), className.replaceAll("(?i)\\.class", String.valueOf(System.currentTimeMillis()) + ".jar"));
        String zipFileName = zipFile.getAbsolutePath();
        try {
            if (classPackage.length() == 0) {
                StructClass structClass = new StructClass(FileUtil.getBytes((File)new File(root, className)), true, new LazyLoader(null));
                structClass.releaseResources();
                classPackage = structClass.qualifiedName.replace("/" + className.replaceAll("(?i)\\.class", ""), "");
            }
            FileUtil.zipDir((File)workingDir, (String)classPackage, (String)zipFileName);
            if (UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode()) {
                displayNumber = JavaDecompilerPlugin.getDefault().isDisplayLineNumber();
                JavaDecompilerPlugin.getDefault().displayLineNumber(Boolean.TRUE);
            }
            this.source = this.mapper.decompile(zipFileName, String.valueOf(classPackage.length() > 0 ? String.valueOf(classPackage) + "/" : "") + className);
            if (!zipFile.delete()) {
                zipFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
        }
        if (displayNumber != null) {
            JavaDecompilerPlugin.getDefault().displayLineNumber(displayNumber);
        }
        if (this.source != null) {
            Pattern wp = Pattern.compile("/\\*.+?\\*/", 32);
            Matcher m = wp.matcher(this.source);
            while (m.find()) {
                if (m.group().matches("/\\*\\s+\\d*\\s+\\*/")) continue;
                String group = m.group();
                group = group.replace("/* ", "\t");
                group = group.replace(" */", "");
                group = group.replace(" * ", "\t");
                if (this.log.length() > 0) {
                    this.log = String.valueOf(this.log) + "\n";
                }
                this.log = String.valueOf(this.log) + group;
                this.source = this.source.replace(m.group(), "");
            }
        }
        this.time = System.currentTimeMillis() - this.start;
    }

    public void decompileFromArchive(String archivePath, String packege, String className) {
        this.start = System.currentTimeMillis();
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/" + System.currentTimeMillis());
        try {
            try {
                workingDir.mkdirs();
                JarClassExtractor.extract((String)archivePath, (String)packege, (String)className, (boolean)true, (String)workingDir.getAbsolutePath());
                this.decompile(workingDir.getAbsolutePath(), packege, className);
            }
            catch (Exception e) {
                JavaDecompilerPlugin.logError((Throwable)e, (String)e.getMessage());
                FileUtil.deltree((File)workingDir);
                return;
            }
        }
        finally {
            FileUtil.deltree((File)workingDir);
        }
    }

    public long getDecompilationTime() {
        return this.time;
    }

    public List getExceptions() {
        return Collections.EMPTY_LIST;
    }

    public String getLog() {
        return this.log;
    }

    public String getSource() {
        return this.source;
    }

    public String getDecompilerType() {
        return "JD-Core";
    }

    public String removeComment(String source) {
        return source;
    }

    public boolean supportLevel(int level) {
        return true;
    }

    public boolean supportDebugLevel(int level) {
        return true;
    }

    public boolean supportDebug() {
        return true;
    }
}

