/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.dialog;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.control.CTreeViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.KeyEventUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.treetable.AstAbstractKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstBuiltInKeywordTreeTableNode;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.components.KeywordTreeViewerToolTipSupport;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ArgumentListExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MethodCallExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.IVariablePart;
import com.kms.katalon.composer.testcase.parts.TestCaseVariableView;
import com.kms.katalon.composer.testcase.providers.AstTreeItemLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstTreeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstTreeTableContentProvider;
import com.kms.katalon.composer.testcase.support.DescriptionColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.InputColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.ItemColumnEditingSupport;
import com.kms.katalon.composer.testcase.support.OutputColumnEditingSupport;
import com.kms.katalon.composer.webui.recorder.action.HTMLAction;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionMapping;
import com.kms.katalon.composer.webui.recorder.action.HTMLActionParamValueType;
import com.kms.katalon.composer.webui.recorder.action.IHTMLAction;
import com.kms.katalon.composer.webui.recorder.ast.RecordedElementMethodCallWrapper;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.composer.webui.recorder.dialog.provider.CapturedElementEditingSupport;
import com.kms.katalon.composer.webui.recorder.util.HTMLActionUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.objectspy.dialog.CapturedObjectsView;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.CryptoUtil;
import com.kms.katalon.util.listener.EventListener;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.openqa.selenium.Keys;

public class RecordedStepsView
implements ITestCasePart,
EventListener<ObjectSpyEvent> {
    private IEventBroker eventBroker;
    private TestCaseTreeTableInput treeTableInput;
    private ScriptNodeWrapper wrapper = new ScriptNodeWrapper();
    private CTreeViewer treeViewer;
    private CapturedObjectsView capturedObjectsView;
    private String windowId;
    private TestCaseVariableView variableView;

    public RecordedStepsView() {
        this.wrapper.addDefaultImports();
        this.wrapper.addImport(Keys.class);
        this.eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    }

    public CTreeViewer getTreeTable() {
        return this.treeViewer;
    }

    public void setCapturedObjectsView(CapturedObjectsView capturedObjectsView) {
        this.capturedObjectsView = capturedObjectsView;
    }

    public CapturedObjectsView getCapturedObjectsView() {
        return this.capturedObjectsView;
    }

    public Composite createContent(Composite parent) {
        Composite compositeTable = new Composite(parent, 0);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new CTreeViewer(compositeTable, 67586);
        Tree childTableTree = this.treeViewer.getTree();
        childTableTree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        childTableTree.setLinesVisible(ControlUtils.shouldLineVisble((Display)childTableTree.getDisplay()));
        childTableTree.setHeaderVisible(true);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        compositeTable.setLayout((Layout)treeColumnLayout);
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, ComposerTestcaseMessageConstants.PA_COL_ITEM, 200, 0, (CellLabelProvider)new AstTreeItemLabelProvider(), (EditingSupport)new ItemColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.OBJECT, 150, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new CapturedElementEditingSupport((TreeViewer)this.treeViewer, this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.INPUT, 150, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new InputColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.OUTPUT, 80, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new OutputColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.addTreeTableColumn((TreeViewer)this.treeViewer, treeColumnLayout, GlobalMessageConstants.DESCRIPTION, 100, 0, (CellLabelProvider)new AstTreeLabelProvider(), (EditingSupport)new DescriptionColumnEditingSupport((TreeViewer)this.treeViewer, (ITestCasePart)this));
        this.treeViewer.setContentProvider((IContentProvider)new AstTreeTableContentProvider());
        this.setTreeTableActivation();
        this.treeTableInput = new TestCaseTreeTableInput(this.wrapper, (TreeViewer)this.treeViewer, (ITestCasePart)this);
        this.treeViewer.setInput((Object)this.treeTableInput.getMainClassNode().getAstChildren());
        this.treeViewer.addSelectionChangedListener(event -> {
            RecordedElementMethodCallWrapper recordedElementMethodCallWrapper;
            void kwNode;
            Object testObjectMethodCall;
            void node;
            void var3_2;
            AstTreeTableNode astTreeTableNode;
            Object object = this.treeViewer.getStructuredSelection().getFirstElement();
            if (object instanceof AstTreeTableNode && (astTreeTableNode = (AstTreeTableNode)object) == (AstTreeTableNode)var3_2 && ( instanceOfPatternExpressionValue = node) instanceof AstBuiltInKeywordTreeTableNode var4_5 && ( instanceOfPatternExpressionValue = (testObjectMethodCall = kwNode.getTestObject())) instanceof RecordedElementMethodCallWrapper && (recordedElementMethodCallWrapper = (RecordedElementMethodCallWrapper)((Object)((Object) instanceOfPatternExpressionValue))) == (RecordedElementMethodCallWrapper)((Object)((Object) instanceOfPatternExpressionValue))) {
                void methodCallExprs;
                EventBrokerSingleton.getInstance().getEventBroker().post("RECORDER/ACTION_SELECTED", (Object)methodCallExprs.getWebElement());
            }
        });
        this.createTreeTableMenu();
        KeywordTreeViewerToolTipSupport.enableFor((TreeViewer)this.treeViewer);
        return compositeTable;
    }

    public void refreshTree() {
        this.treeViewer.refresh();
    }

    public ScriptNodeWrapper getWrapper() {
        return this.wrapper;
    }

    private TreeViewerColumn addTreeTableColumn(TreeViewer parent, TreeColumnLayout treeColumnLayout, String headerText, int width, int weight, CellLabelProvider labelProvider, EditingSupport editingSupport) {
        TreeViewerColumn treeTableColumn = new TreeViewerColumn(parent, 0);
        TreeColumn treeColumn = treeTableColumn.getColumn();
        treeColumn.setWidth(width);
        treeColumn.setMoveable(true);
        treeColumn.setText(headerText);
        treeTableColumn.setLabelProvider(labelProvider);
        treeTableColumn.setEditingSupport(editingSupport);
        treeColumnLayout.setColumnData((Widget)treeTableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, treeColumn.getWidth()));
        return treeTableColumn;
    }

    private void setTreeTableActivation() {
        ColumnViewerUtil.setTreeTableActivation((TreeViewer)this.treeViewer);
    }

    public TestCaseEntity getTestCase() {
        return new TestCaseEntity();
    }

    public void setDirty(boolean isDirty) {
        this.treeTableInput.reloadTestCaseVariables(this.getVariables());
    }

    public void addVariables(VariableEntity[] variables) {
        this.variableView.addVariable(variables);
    }

    public VariableEntity[] getVariables() {
        return this.variableView.getVariables();
    }

    public TestCaseTreeTableInput getTreeTableInput() {
        return this.treeTableInput;
    }

    public List<AstTreeTableNode> getDragNodes() {
        return null;
    }

    public void createDynamicGotoMenu(Menu menu) {
    }

    public void deleteVariables(List<VariableEntity> variableList) {
    }

    public void addNewStep(HTMLActionMapping newAction) throws ClassNotFoundException {
        if (this.windowId == null && StringUtils.isNotEmpty((CharSequence)newAction.getWindowId())) {
            this.addNode(HTMLActionUtil.createNewSwitchToWindowAction(HTMLActionUtil.getPageTitleForAction(newAction)));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.windowId) && !this.windowId.equals(newAction.getWindowId()) && StringUtils.isNotEmpty((CharSequence)newAction.getWindowId())) {
            this.addNode(HTMLActionUtil.createNewSwitchToWindowAction(HTMLActionUtil.getPageTitleForAction(newAction)));
        }
        this.windowId = newAction.getWindowId();
        this.addNode(newAction);
    }

    private void addNode(HTMLActionMapping newAction) throws ClassNotFoundException {
        this.beforeNodeAdded(newAction);
        ExpressionStatementWrapper wrapper = this.shouldAddNewNode(newAction);
        if (wrapper != null) {
            this.treeTableInput.addNewAstObject((ASTNodeWrapper)wrapper, null, TestCaseTreeTableInput.NodeAddType.Add);
            this.treeViewer.refresh();
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getLatestNode()));
        }
    }

    private ExpressionStatementWrapper shouldAddNewNode(HTMLActionMapping newAction) throws ClassNotFoundException {
        WebElement targetElement = newAction.getTargetElement();
        AstAbstractKeywordTreeTableNode latestNode = this.getLatestNode();
        ExpressionStatementWrapper wrapper = (ExpressionStatementWrapper)HTMLActionUtil.generateWebUiTestStep(newAction, targetElement, (ASTNodeWrapper)this.treeTableInput.getMainClassNode());
        if (targetElement != null && latestNode instanceof AstBuiltInKeywordTreeTableNode && this.preventDuplicatedActions(newAction, latestNode, targetElement, wrapper)) {
            return null;
        }
        return wrapper;
    }

    private void beforeNodeAdded(HTMLActionMapping newAction) {
        AstAbstractKeywordTreeTableNode latestNode = this.getLatestNode();
        if (Objects.isNull(latestNode)) {
            return;
        }
        String objectId = latestNode.getTestObjectText();
        String latestKeywordName = latestNode.getKeywordName();
        WebElement targetElement = newAction.getTargetElement();
        if (Objects.nonNull(targetElement)) {
            boolean newActionFromContextMenu;
            IHTMLAction htmlAction = newAction.getAction();
            if (htmlAction == HTMLAction.SetText) {
                WebElementPropertyEntity property = targetElement.getProperty("type");
                if (Objects.nonNull(property) && StringUtils.equals((CharSequence)"password", (CharSequence)property.getValue())) {
                    this.secureSetTextAction(newAction);
                    return;
                }
                if (StringUtils.equals((CharSequence)HTMLAction.LeftClick.getMappedKeywordMethod(), (CharSequence)latestKeywordName) && StringUtils.equals((CharSequence)objectId, (CharSequence)targetElement.getName())) {
                    this.removeTestStep();
                    return;
                }
            }
            String newActionName = htmlAction.getName();
            boolean bl = newActionFromContextMenu = StringUtils.containsAny((CharSequence)newActionName, (CharSequence[])new CharSequence[]{"Verify", "WaitFor"}) || htmlAction == HTMLAction.MouseOver;
            if (StringUtils.equals((CharSequence)HTMLAction.RightClick.getMappedKeywordMethod(), (CharSequence)latestKeywordName) && newActionFromContextMenu && StringUtils.equals((CharSequence)objectId, (CharSequence)targetElement.getName())) {
                this.removeTestStep();
                Trackings.trackWebRecordStepByContextMenu((String)newActionName);
                return;
            }
        }
    }

    private void secureSetTextAction(HTMLActionMapping newAction) {
        if (newAction.getAction() != HTMLAction.SendKeys) {
            newAction.setAction(HTMLAction.SetEncryptedText);
            HTMLActionParamValueType passwordParam = newAction.getData()[0];
            ConstantExpressionWrapper stringWrapper = (ConstantExpressionWrapper)passwordParam.getValue();
            String password = stringWrapper.getValueAsString();
            try {
                stringWrapper.setValue((Object)CryptoUtil.encode((CryptoUtil.CrytoInfo)CryptoUtil.getDefault((String)password)));
            }
            catch (UnsupportedEncodingException | GeneralSecurityException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }

    private boolean preventDuplicatedActions(HTMLActionMapping newAction, AstAbstractKeywordTreeTableNode latestNode, WebElement targetElement, ExpressionStatementWrapper wrapper) {
        if (Objects.isNull(latestNode)) {
            return false;
        }
        String objectId = latestNode.getTestObjectText();
        String latestKeywordName = latestNode.getKeywordName();
        String newActionName = newAction.getAction().getName();
        if (StringUtils.equals((CharSequence)objectId, (CharSequence)targetElement.getName())) {
            if (this.preventAddMultiSetTextAction(latestKeywordName, newActionName)) {
                this.modifyStep(wrapper, latestNode);
                return true;
            }
            if (this.preventAddMultiClickAction(latestKeywordName, newActionName)) {
                AstBuiltInKeywordTreeTableNode twoStepBefore = this.getNodeItem(this.treeViewer.getTree().getItemCount() - 2);
                this.treeTableInput.removeRows(Arrays.asList(latestNode));
                if (Objects.nonNull(twoStepBefore)) {
                    this.modifyStep(wrapper, (AstAbstractKeywordTreeTableNode)twoStepBefore);
                }
                return true;
            }
        }
        return false;
    }

    private void modifyStep(ExpressionStatementWrapper wrapper, AstAbstractKeywordTreeTableNode twoStepBefore) {
        ExpressionStatementWrapper oldWrapper = (ExpressionStatementWrapper)twoStepBefore.getASTObject();
        oldWrapper.setExpression(wrapper.getExpression());
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)twoStepBefore));
    }

    private boolean preventAddMultiClickAction(String latestKeywordName, String newActionName) {
        AstBuiltInKeywordTreeTableNode twoStepBefore = this.getNodeItem(this.treeViewer.getTree().getItemCount() - 2);
        return Objects.nonNull(twoStepBefore) && StringUtils.equals((CharSequence)HTMLAction.LeftClick.getMappedKeywordMethod(), (CharSequence)twoStepBefore.getKeywordName()) && StringUtils.equals((CharSequence)HTMLAction.LeftClick.getMappedKeywordMethod(), (CharSequence)latestKeywordName) && StringUtils.equals((CharSequence)HTMLAction.DoubleClick.getName(), (CharSequence)newActionName);
    }

    private boolean preventAddMultiSetTextAction(String latestKeywordName, String newActionName) {
        return HTMLAction.SetText.getMappedKeywordMethod().equals(latestKeywordName) && HTMLAction.SetText.getName().equals(newActionName) || HTMLAction.SetEncryptedText.getMappedKeywordMethod().equals(latestKeywordName) && HTMLAction.SetEncryptedText.getName().equals(newActionName);
    }

    /*
     * WARNING - void declaration
     */
    public AstAbstractKeywordTreeTableNode getLatestNode() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem latestItem = items[items.length - 1];
        Object object = latestItem.getData();
        if (object instanceof AstAbstractKeywordTreeTableNode var3_4) {
            void astKeywordTreeTableNode;
            return astKeywordTreeTableNode;
        }
        return null;
    }

    public AstBuiltInKeywordTreeTableNode getNodeItem(int offset) {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return null;
        }
        TreeItem item = items[offset];
        if (item.getData() instanceof AstBuiltInKeywordTreeTableNode) {
            return (AstBuiltInKeywordTreeTableNode)item.getData();
        }
        return null;
    }

    public List<AstTreeTableNode> getNodes() {
        TreeItem[] items = this.treeViewer.getTree().getItems();
        if (items == null || items.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<AstTreeTableNode> nodes = new ArrayList<AstTreeTableNode>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i.getData() instanceof AstTreeTableNode) {
                nodes.add((AstTreeTableNode)i.getData());
            }
            ++n2;
        }
        return nodes;
    }

    public void addSimpleKeyword(String keywordName, boolean hasParam) {
        String webUiKwAliasName = HTMLActionUtil.getWebUiKeywordClass().getAliasName();
        MethodCallExpressionWrapper methodCallExpressionWrapper = new MethodCallExpressionWrapper(webUiKwAliasName, keywordName, (ASTNodeWrapper)this.treeTableInput.getMainClassNode());
        if (hasParam) {
            ArgumentListExpressionWrapper arguments = methodCallExpressionWrapper.getArguments();
            arguments.addExpression((ExpressionWrapper)new ConstantExpressionWrapper((Object)""));
        }
        ExpressionStatementWrapper openBrowserStmt = new ExpressionStatementWrapper((ExpressionWrapper)methodCallExpressionWrapper);
        this.treeTableInput.addNewAstObject((ASTNodeWrapper)openBrowserStmt, null, TestCaseTreeTableInput.NodeAddType.Add);
        this.treeViewer.refresh();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.getLatestNode()));
    }

    public void handleEvent(ObjectSpyEvent event, Object object) {
        switch (event) {
            case ELEMENT_NAME_CHANGED: {
                this.refreshTree();
                break;
            }
            case SELENIUM_SESSION_STARTED: 
            case ADDON_SESSION_STARTED: {
                this.windowId = "";
                break;
            }
        }
    }

    public Composite createVariableTab(Composite parent) {
        this.variableView = new TestCaseVariableView((IVariablePart)this);
        Composite component = this.variableView.createComponents(parent);
        GridLayout gl = (GridLayout)component.getLayout();
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        return component;
    }

    public void removeTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.removeSelectedRows();
        }
    }

    public void copyTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.copy(this.treeTableInput.getSelectedNodes());
        }
    }

    public void cutTestStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.treeTableInput.cut(this.treeTableInput.getSelectedNodes());
        }
    }

    public void pasteTestStep() {
        if (this.treeTableInput.canPaste()) {
            this.treeTableInput.paste(this.treeTableInput.getSelectedNode(), TestCaseTreeTableInput.NodeAddType.Add);
        }
    }

    private void runFromFirstSelectedStep() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.eventBroker.post("WEBUI_VERIFICATION/RUN_FROM_STEP_CMD", null);
        }
    }

    private void runSelectedSteps() {
        boolean hasSelection;
        boolean bl = hasSelection = !this.treeViewer.getStructuredSelection().isEmpty();
        if (hasSelection) {
            this.eventBroker.post("WEBUI_VERIFICATION/RUN_SELECTED_STEPS_CMD", null);
        }
    }

    private void runAllSteps() {
        this.eventBroker.post("WEBUI_VERIFICATION/RUN_ALL_STEPS_CMD", null);
    }

    private void createTreeTableMenu() {
        final Tree tree = this.treeViewer.getTree();
        tree.addListener(35, new Listener(){
            private SelectionListener selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!(e.widget instanceof MenuItem)) {
                        return;
                    }
                    MenuItem item = (MenuItem)e.widget;
                    switch (item.getID()) {
                        case 64: {
                            RecordedStepsView.this.copyTestStep();
                            break;
                        }
                        case 65: {
                            RecordedStepsView.this.cutTestStep();
                            break;
                        }
                        case 66: {
                            RecordedStepsView.this.pasteTestStep();
                            break;
                        }
                        case 67: {
                            RecordedStepsView.this.removeTestStep();
                            break;
                        }
                        case 69: {
                            RecordedStepsView.this.getTreeTableInput().enable();
                            break;
                        }
                        case 68: {
                            RecordedStepsView.this.getTreeTableInput().disable();
                            break;
                        }
                        case 256: {
                            RecordedStepsView.this.runFromFirstSelectedStep();
                            break;
                        }
                        case 257: {
                            RecordedStepsView.this.runSelectedSteps();
                        }
                    }
                }
            };

            private String createMenuItemLabel(String text, String keyCombination) {
                return String.valueOf(text) + "\t" + keyCombination;
            }

            public void handleEvent(Event event) {
                Menu menu = tree.getMenu();
                if (menu != null) {
                    menu.dispose();
                }
                boolean hasSelection = tree.getSelectionCount() > 0;
                menu = new Menu((Control)tree);
                MenuItem runFromThisStepMenuItem = new MenuItem(menu, 8);
                runFromThisStepMenuItem.setText(this.createMenuItemLabel(ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_FROM_HERE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "SHIFT", "E"})));
                runFromThisStepMenuItem.addSelectionListener(this.selectionListener);
                runFromThisStepMenuItem.setID(256);
                runFromThisStepMenuItem.setEnabled(hasSelection);
                MenuItem runSelectedStepsMenuItem = new MenuItem(menu, 8);
                runSelectedStepsMenuItem.setText(this.createMenuItemLabel(ComposerWebuiRecorderMessageConstants.DIA_ITEM_RUN_SELECTED_STEPS, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "ALT", "E"})));
                runSelectedStepsMenuItem.addSelectionListener(this.selectionListener);
                runSelectedStepsMenuItem.setID(257);
                runSelectedStepsMenuItem.setEnabled(hasSelection);
                new MenuItem(menu, 2);
                MenuItem removeMenuItem = new MenuItem(menu, 8);
                removeMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.DELETE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"DEL"})));
                removeMenuItem.addSelectionListener(this.selectionListener);
                removeMenuItem.setID(67);
                removeMenuItem.setEnabled(hasSelection);
                MenuItem copyMenuItem = new MenuItem(menu, 8);
                copyMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.COPY, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "C"})));
                copyMenuItem.addSelectionListener(this.selectionListener);
                copyMenuItem.setID(64);
                copyMenuItem.setEnabled(hasSelection);
                MenuItem cutMenuItem = new MenuItem(menu, 8);
                cutMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.CUT, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "X"})));
                cutMenuItem.addSelectionListener(this.selectionListener);
                cutMenuItem.setID(65);
                cutMenuItem.setEnabled(hasSelection);
                MenuItem pasteMenuItem = new MenuItem(menu, 8);
                pasteMenuItem.setText(this.createMenuItemLabel(GlobalStringConstants.PASTE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "V"})));
                pasteMenuItem.addSelectionListener(this.selectionListener);
                pasteMenuItem.setID(66);
                pasteMenuItem.setEnabled(RecordedStepsView.this.getTreeTableInput().canPaste());
                tree.setMenu(menu);
                new MenuItem(menu, 2);
                MenuItem disableMenuItem = new MenuItem(menu, 8);
                disableMenuItem.setText(this.createMenuItemLabel(ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_DISABLE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"M1", "/"})));
                disableMenuItem.addSelectionListener(this.selectionListener);
                disableMenuItem.setID(68);
                disableMenuItem.setEnabled(hasSelection);
                MenuItem enableMenuItem = new MenuItem(menu, 8);
                enableMenuItem.setText(this.createMenuItemLabel(ComposerTestcaseMessageConstants.ADAP_MENU_CONTEXT_ENABLE, KeyEventUtil.geNativeKeyLabel((String[])new String[]{"ALT", "M1", "/"})));
                enableMenuItem.addSelectionListener(this.selectionListener);
                enableMenuItem.setID(69);
                enableMenuItem.setEnabled(hasSelection);
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    RecordedStepsView.this.removeTestStep();
                    return;
                }
                if ((e.stateMask & SWT.MOD1) == SWT.MOD1) {
                    if (e.keyCode == 99) {
                        RecordedStepsView.this.copyTestStep();
                        return;
                    }
                    if (e.keyCode == 120) {
                        RecordedStepsView.this.cutTestStep();
                        return;
                    }
                    if (e.keyCode == 118) {
                        RecordedStepsView.this.pasteTestStep();
                        return;
                    }
                    if (e.keyCode == 47 && (e.stateMask & 0x10000) == 65536) {
                        RecordedStepsView.this.treeTableInput.enable();
                        return;
                    }
                    if (e.keyCode == 47) {
                        RecordedStepsView.this.treeTableInput.disable();
                        return;
                    }
                    if (e.keyCode == 101 && (e.stateMask & 0x10000) == 65536) {
                        RecordedStepsView.this.runSelectedSteps();
                        return;
                    }
                    if (e.keyCode == 101 && (e.stateMask & 0x20000) == 131072) {
                        RecordedStepsView.this.runFromFirstSelectedStep();
                        return;
                    }
                    if (e.keyCode == 101) {
                        RecordedStepsView.this.runAllSteps();
                    }
                }
            }
        });
    }
}

