/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.studioassist.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.studioassist.constants.ComposerStudioAssistConstants;
import com.kms.katalon.composer.studioassist.handlers.GPTBaseHandler;
import com.kms.katalon.composer.studioassist.util.StudioAssistActionUtil;
import com.kms.katalon.tracking.service.Trackings;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.ui.IWorkbenchWindow;

public class GenerateCodeHandler
extends GPTBaseHandler {
    @Override
    public void trackFeatureUsage() {
        Trackings.trackStudioAssistUsage((String)"GENERATE_CODE");
        this.currentProfile = UserProfileHelper.getCurrentProfile();
        int numberOfGenerateCodeUsed = this.currentProfile.getNumberOfTimeGenerateCodeUsed();
        int newNumberOfGenerateCodeUsed = numberOfGenerateCodeUsed + 1;
        this.currentProfile.setNumberOfTimeGenerateCodeUsed(newNumberOfGenerateCodeUsed);
        UserProfileHelper.saveProfile((UserProfile)this.currentProfile);
    }

    @Override
    protected void showFeedbackDialog() {
        if (this.currentProfile.getNumberOfTimeGenerateCodeUsed() == 10) {
            this.openShareFeedbackDialog();
        }
    }

    @Override
    public String getProgressText() {
        return ComposerStudioAssistConstants.GENERATE_CODE_JOB_PROGRESS_MSG;
    }

    @Override
    public void insertCodeIntoEditor(String result, IWorkbenchWindow window) {
        UISynchronizeService.asyncExec(() -> {
            if (StringUtils.isNotBlank((CharSequence)result)) {
                StudioAssistActionUtil.insertCodeIntoEditor(String.valueOf('\n') + result, window);
            }
        });
    }

    @Override
    public String getPrompt() {
        return "Just write a script for the requirement. Make sure you abide by the 3 following rules:\n    1. Use Katalon Studio keywords\n    2. Do not import any libraries\n    3. Use the findTestObject keyword inline rather than creating a separate test object\n\nIf the requirement is about writing a `method` or `keyword` that returns a value,\ngenerate a document before your result with the following format:\n\n    /*\n     *  <Purpose of the method or keyword>\n     *\n     *  @param <first param name> <Explanation of the first param>\n     *  @param <second param name> <Explanation of the second param>\n     *  @return <Explanation of the returned value>\n     */\nIf the requirement is about writing a void `method` or `keyword`,\ngenerate a document before your result with the following format:\n\n    /*\n     *  <Purpose of the method or keyword>\n     *\n     *  @param <first param name> <Explanation of the first param>\n     *  @param <second param name> <Explanation of the second param>\n     */\n\nOtherwise, just generate Katalon Studio keywords with the format as follows:\n    // <Only explain the keyword purpose>\n    <Your generated keyword>\nDo not generate methods or functions if the requirement does not ask for.\n\n" + ComposerStudioAssistConstants.FINAL_WORK;
    }
}

