/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.platform.internal.entity.testobject;

import com.katalon.platform.api.model.testobject.WebElementEntity;
import com.katalon.platform.api.model.testobject.WebElementProperty;
import com.katalon.platform.api.model.testobject.WebElementSelectorMethod;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import com.kms.katalon.platform.internal.entity.testobject.WebElementPropertyImpl;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class WebElementEntityImpl
implements WebElementEntity {
    private final com.kms.katalon.entity.repository.WebElementEntity source;

    public WebElementEntityImpl(com.kms.katalon.entity.repository.WebElementEntity source) {
        this.source = source;
    }

    public String getFileLocation() {
        return new File(this.source.getId()).getAbsolutePath();
    }

    public String getFolderLocation() {
        return this.source.getParentFolder().getLocation();
    }

    public String getId() {
        return this.source.getIdForDisplay();
    }

    public String getName() {
        return this.source.getName();
    }

    public String getImagePath() {
        return this.source.getImagePath();
    }

    public String getParentElementId() {
        if (this.hasParentElement()) {
            return "";
        }
        return this.source.getWebElementProperties().stream().filter(prop -> "ref_element".equals(prop.getName())).findFirst().get().getValue();
    }

    public Map<WebElementSelectorMethod, String> getSelectorCollection() {
        if (this.source.getSelectorCollection() == null) {
            return Collections.emptyMap();
        }
        HashMap<WebElementSelectorMethod, String> selectorCollections = new HashMap<WebElementSelectorMethod, String>();
        for (Map.Entry entry : this.source.getSelectorCollection().entrySet()) {
            selectorCollections.put(WebElementSelectorMethod.valueOf((String)((com.kms.katalon.entity.repository.WebElementSelectorMethod)entry.getKey()).name()), (String)entry.getValue());
        }
        return Collections.unmodifiableMap(selectorCollections);
    }

    public WebElementSelectorMethod getSelectorMethod() {
        return WebElementSelectorMethod.valueOf((String)this.source.getGenericSelectorMethod().name());
    }

    public List<WebElementProperty> getWebElementProperties() {
        if (this.source.getWebElementProperties() == null) {
            return Collections.emptyList();
        }
        return this.source.getWebElementProperties().stream().map(prop -> new WebElementPropertyImpl((WebElementPropertyEntity)prop)).collect(Collectors.toList());
    }

    public List<WebElementProperty> getXpathElementProperties() {
        if (this.source.getWebElementProperties() == null) {
            return Collections.emptyList();
        }
        return this.source.getWebElementXpaths().stream().map(prop -> new WebElementPropertyImpl((WebElementPropertyEntity)prop)).collect(Collectors.toList());
    }

    public boolean hasParentElement() {
        return this.source.getWebElementProperties().stream().filter(prop -> "ref_element".equals(prop.getName())).findFirst().isPresent();
    }

    public boolean isRelativeImagePath() {
        return this.source.getUseRalativeImagePath();
    }

    public String getDescription() {
        return this.source.getDescription();
    }
}

