/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.components;

import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.util.MobileDeviceUIProvider;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileActionMapping;
import com.kms.katalon.composer.mobile.objectspy.components.MobileAppComposite;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.exceptions.SmartStartAppException;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ConstantExpressionWrapper;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.appium.exception.AppiumStartException;
import com.kms.katalon.core.appium.exception.IOSWebkitStartException;
import com.kms.katalon.core.appium.exception.MobileDriverInitializeException;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.mobile.device.AndroidDeviceInfo;
import com.kms.katalon.execution.mobile.device.AndroidSDKManager;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.exception.AndroidSetupException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MobileLocalAppComposite
implements MobileAppComposite {
    private static final int START_WITH_APPLICATION_FILE = 0;
    private static final int START_WITH_APPLICATION_ID = 1;
    private String ANDROID_FILTER_NAMES = "Android Application (*.apk)";
    private String ANDROID_FILTER_EXTS = "*.apk";
    private String IOS_FILTER_NAMES = "iOS Application (*.app, *.ipa)";
    private String IOS_FILTER_EXTS = "*.app;*.ipa";
    private MobileAppDialog parentDialog;
    private Combo cbbDevices;
    private Button btnBrowse;
    private Button btnRefreshDevice;
    private Text txtAppFile;
    private List<MobileDeviceInfo> deviceInfos = new ArrayList<MobileDeviceInfo>();
    private MobileDeviceInfo selectedDevice = null;
    private Link linkLabel;
    private Composite composite;
    private MobileDriverType driverType;
    private Combo cbbStartType;
    private Text txtAppId;
    private Composite appFileChooserComposite;
    private Composite appComposite;
    private Composite appIdComposite;
    private StackLayout slAppComposite;
    private Label appFileLabel;

    public MobileLocalAppComposite(MobileDriverType driverType) {
        this.driverType = driverType;
    }

    private String[] getFilterNames() {
        switch (this.driverType) {
            case ANDROID_DRIVER: {
                return new String[]{this.ANDROID_FILTER_NAMES};
            }
            case IOS_DRIVER: {
                return new String[]{this.IOS_FILTER_NAMES};
            }
        }
        return new String[0];
    }

    private String[] getFilterExtensions() {
        switch (this.driverType) {
            case ANDROID_DRIVER: {
                return new String[]{this.ANDROID_FILTER_EXTS};
            }
            case IOS_DRIVER: {
                return new String[]{this.IOS_FILTER_EXTS};
            }
        }
        return new String[0];
    }

    @Override
    public boolean isAbleToStart() {
        if (this.cbbDevices.getSelectionIndex() < 0) {
            return false;
        }
        switch (this.cbbStartType.getSelectionIndex()) {
            case 0: {
                return StringUtils.isNotBlank((CharSequence)this.getAppFile());
            }
            case 1: {
                return StringUtils.isNotBlank((CharSequence)this.txtAppId.getText());
            }
        }
        return false;
    }

    public void updateLocalDevices() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_LOADING_DEVICES, -1);
                MobileLocalAppComposite.this.deviceInfos = MobileLocalAppComposite.this.getDeviceList();
                final List<String> devices = MobileLocalAppComposite.this.getAllDevicesName();
                MobileLocalAppComposite.this.checkMonitorCanceled(monitor);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        (this).MobileLocalAppComposite.this.cbbDevices.setItems(devices.toArray(new String[0]));
                        if (!devices.isEmpty()) {
                            (this).MobileLocalAppComposite.this.cbbDevices.select(Math.max(0, devices.indexOf((this).MobileLocalAppComposite.this.cbbDevices.getText())));
                        }
                        MobileLocalAppComposite.this.setLinkLabelVisible(devices.isEmpty());
                    }
                });
                monitor.done();
            }
        };
        new ProgressMonitorDialogWithThread(Display.getDefault().getActiveShell()).run(true, true, runnable);
    }

    private List<MobileDeviceInfo> getDeviceList() {
        switch (this.driverType) {
            case ANDROID_DRIVER: {
                return MobileDeviceUIProvider.getAndroidDevices();
            }
            case IOS_DRIVER: {
                return MobileDeviceUIProvider.getIOSDevices();
            }
        }
        return Collections.emptyList();
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    private List<String> getAllDevicesName() {
        ArrayList<String> devicesNameList = new ArrayList<String>();
        for (MobileDeviceInfo deviceInfo : this.deviceInfos) {
            devicesNameList.add(deviceInfo.getDisplayName());
        }
        return devicesNameList;
    }

    @Override
    public String getAppName() {
        return FilenameUtils.getName((String)this.getAppFile());
    }

    @Override
    public String getAppFile() {
        return this.txtAppFile.getText();
    }

    public MobileDeviceInfo getSelectedMobileDeviceInfo() {
        if (this.cbbDevices == null || this.cbbDevices.isDisposed()) {
            return this.selectedDevice;
        }
        int selectedMobileDeviceIndex = this.cbbDevices.getSelectionIndex();
        if (selectedMobileDeviceIndex < 0 || selectedMobileDeviceIndex >= this.deviceInfos.size()) {
            this.selectedDevice = null;
            return this.selectedDevice;
        }
        this.selectedDevice = this.deviceInfos.get(selectedMobileDeviceIndex);
        return this.selectedDevice;
    }

    public boolean validateLocalAppSetting() {
        if (this.cbbDevices.getSelectionIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)GlobalStringConstants.ERROR, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_PLS_CONNECT_AND_SELECT_DEVICE);
            return false;
        }
        switch (this.cbbStartType.getSelectionIndex()) {
            case 0: {
                String appFilePath = this.getAppFile().trim();
                if (appFilePath.equals("")) {
                    MessageDialog.openError((Shell)this.getShell(), (String)GlobalStringConstants.ERROR, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_PLS_SELECT_APP_FILE);
                    return false;
                }
                File appFile = new File(appFilePath);
                if (!appFile.exists()) {
                    MessageDialog.openWarning((Shell)this.getShell(), (String)GlobalStringConstants.ERROR, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_APP_FILE_NOT_EXIST);
                    return false;
                }
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private Shell getShell() {
        return this.composite.getShell();
    }

    private void setLinkLabelVisible(boolean visible) {
        this.linkLabel.setVisible(visible);
        if (this.linkLabel.getLayoutData() != null) {
            ((GridData)this.linkLabel.getLayoutData()).exclude = !visible;
        }
        this.linkLabel.pack();
        this.linkLabel.getParent().layout();
    }

    @Override
    public Composite createComposite(Composite parent, int type, final MobileAppDialog parentDialog) {
        this.parentDialog = parentDialog;
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.composite.setLayout((Layout)layout);
        Composite deviceNameCompposite = new Composite(this.composite, 0);
        GridLayout deviceNameComppositeLayout = new GridLayout(3, false);
        deviceNameComppositeLayout.marginHeight = 0;
        deviceNameComppositeLayout.marginWidth = 0;
        deviceNameCompposite.setLayout((Layout)deviceNameComppositeLayout);
        deviceNameCompposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeviceName = new Label(deviceNameCompposite, 0);
        lblDeviceName.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_DEVICE_NAME);
        final GridData gdDeviceNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDeviceName.setLayoutData((Object)gdDeviceNameLabel);
        this.cbbDevices = new Combo(deviceNameCompposite, 8);
        this.cbbDevices.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cbbDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parentDialog.refreshButtonsState();
            }
        });
        this.btnRefreshDevice = new Button(deviceNameCompposite, 8);
        this.btnRefreshDevice.setText(GlobalStringConstants.REFRESH);
        this.btnRefreshDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parentDialog.updateDeviceNames();
            }
        });
        this.linkLabel = new Link(this.composite, 0);
        this.linkLabel.setText(String.valueOf(ComposerMobileObjectspyMessageConstants.MSG_NO_DEVICES) + " <a href=\"" + ComposerMobileObjectspyMessageConstants.NO_DEVICES_TROUBLESHOOTING_GUIDE_LINK + "\">" + ComposerMobileObjectspyMessageConstants.MSG_WRAPPED_NO_DEVICES_TROUBLESHOOTING_GUIDE + "</a>");
        this.linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)e.text);
            }
        });
        this.linkLabel.setVisible(false);
        Composite startTypeComposite = new Composite(this.composite, 0);
        GridLayout glStartTypeComposite = new GridLayout(2, false);
        glStartTypeComposite.marginHeight = 0;
        glStartTypeComposite.marginWidth = 0;
        startTypeComposite.setLayout((Layout)glStartTypeComposite);
        Label lblStartType = new Label(startTypeComposite, 0);
        final GridData gdStartWithLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblStartType.setLayoutData((Object)gdStartWithLabel);
        lblStartType.setText("Start with");
        this.cbbStartType = new Combo(startTypeComposite, 8);
        this.cbbStartType.setItems(new String[]{"Application File", "Application ID"});
        this.cbbStartType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (MobileLocalAppComposite.this.cbbStartType.getSelectionIndex()) {
                    case 0: {
                        MobileLocalAppComposite.this.slAppComposite.topControl = MobileLocalAppComposite.this.appFileChooserComposite;
                        MobileLocalAppComposite.this.appComposite.layout();
                        parentDialog.refreshButtonsState();
                        break;
                    }
                    case 1: {
                        MobileLocalAppComposite.this.slAppComposite.topControl = MobileLocalAppComposite.this.appIdComposite;
                        MobileLocalAppComposite.this.appComposite.layout();
                        parentDialog.refreshButtonsState();
                    }
                }
            }
        });
        this.appComposite = new Composite(this.composite, 0);
        this.appComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.slAppComposite = new StackLayout();
        this.appComposite.setLayout((Layout)this.slAppComposite);
        this.appFileChooserComposite = new Composite(this.appComposite, 0);
        this.appFileChooserComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppFileChooserComposite = new GridLayout(3, false);
        glAppFileChooserComposite.marginHeight = 0;
        glAppFileChooserComposite.marginWidth = 0;
        this.appFileChooserComposite.setLayout((Layout)glAppFileChooserComposite);
        this.appFileLabel = new Label(this.appFileChooserComposite, 0);
        this.appFileLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_APP_FILE);
        GridData gdAppFileLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.appFileLabel.setLayoutData((Object)gdAppFileLabel);
        this.txtAppFile = new Text(this.appFileChooserComposite, 2048);
        final GridData gdText = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtAppFile.setLayoutData((Object)gdText);
        this.txtAppFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                parentDialog.refreshButtonsState();
            }
        });
        this.txtAppFile.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdText.widthHint = 100;
            }
        });
        this.btnBrowse = new Button(this.appFileChooserComposite, 8);
        GridData btnBrowserGridData = new GridData(4, 0x1000000, false, false, 1, 1);
        this.btnBrowse.setLayoutData((Object)btnBrowserGridData);
        this.btnBrowse.setText(GlobalStringConstants.BROWSE);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(MobileLocalAppComposite.this.btnBrowse.getShell());
                dialog.setFilterNames(MobileLocalAppComposite.this.getFilterNames());
                dialog.setFilterExtensions(MobileLocalAppComposite.this.getFilterExtensions());
                String absolutePath = dialog.open();
                if (StringUtils.isEmpty((CharSequence)absolutePath)) {
                    return;
                }
                parentDialog.getPreferencesHelper().setLastAppFile(absolutePath);
                MobileLocalAppComposite.this.txtAppFile.setText(absolutePath);
            }
        });
        this.appIdComposite = new Composite(this.appComposite, 0);
        this.appIdComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GridLayout glAppIdComposite = new GridLayout(2, false);
        glAppIdComposite.marginHeight = 0;
        glAppIdComposite.marginWidth = 0;
        this.appIdComposite.setLayout((Layout)glAppIdComposite);
        Label appIdLabel = new Label(this.appIdComposite, 0);
        appIdLabel.setText("Application ID");
        final GridData gdAppIdLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        appIdLabel.setLayoutData((Object)gdAppIdLabel);
        this.txtAppId = new Text(this.appIdComposite, 2048);
        final GridData gdAppId = new GridData(4, 0x1000000, true, false, 1, 1);
        gdAppId.widthHint = 100;
        this.txtAppId.setLayoutData((Object)gdText);
        this.txtAppId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                parentDialog.refreshButtonsState();
            }
        });
        this.txtAppId.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                gdAppId.widthHint = 100;
            }
        });
        this.appFileLabel.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int appFileLabelWidth = MobileLocalAppComposite.this.appFileLabel.getBounds().width;
                if (appFileLabelWidth == 0) {
                    return;
                }
                gdDeviceNameLabel.widthHint = appFileLabelWidth;
                gdStartWithLabel.widthHint = appFileLabelWidth;
                gdAppIdLabel.widthHint = appFileLabelWidth;
                MobileLocalAppComposite.this.composite.layout(true, true);
            }
        });
        return this.composite;
    }

    @Override
    public boolean validateSetting() {
        return this.validateLocalAppSetting();
    }

    @Override
    public MobileDriverType getSelectedDriverType() {
        return this.driverType;
    }

    @Override
    public boolean startApp(final MobileInspectorController inspectorController, final AppiumMonitorDialog progressDlg) throws InvocationTargetException, InterruptedException {
        final MobileDeviceInfo selectDeviceInfo = this.getSelectedMobileDeviceInfo();
        if (selectDeviceInfo == null) {
            return false;
        }
        if (selectDeviceInfo instanceof AndroidDeviceInfo && !MobileDeviceUIProvider.checkAndroidSDKExist((Shell)this.getShell())) {
            return false;
        }
        final String appFile = this.getAppFile();
        final String appId = this.txtAppId.getText();
        final int startType = this.cbbStartType.getSelectionIndex();
        IRunnableWithProgress processToRun = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_LBL_STATUS_APP_STARTING, -1);
                progressDlg.runAndWait(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        switch (startType) {
                            case 0: {
                                try {
                                    MobileLocalAppComposite.this.smartStartApp(inspectorController, selectDeviceInfo, appFile);
                                }
                                catch (SmartStartAppException smartStartAppException) {
                                    MobileLocalAppComposite.this.startLocalAppAsNormal(inspectorController, selectDeviceInfo, appFile);
                                }
                                break;
                            }
                            case 1: {
                                inspectorController.startExistingApp(selectDeviceInfo, appId);
                            }
                        }
                        return null;
                    }
                });
                MobileLocalAppComposite.this.checkMonitorCanceled(monitor);
                monitor.done();
            }
        };
        progressDlg.run(true, true, processToRun);
        return true;
    }

    private void smartStartApp(MobileInspectorController inspectorController, MobileDeviceInfo selectDeviceInfo, String appFile) throws SmartStartAppException, ExecutionException, InterruptedException, IOException, AppiumStartException, MobileDriverInitializeException, IOSWebkitStartException {
        if (!MobileInspectorController.getMobileDriverType(selectDeviceInfo).equals((Object)MobileDriverType.ANDROID_DRIVER)) {
            throw new SmartStartAppException(ComposerMobileObjectspyMessageConstants.SMART_START_ERROR_NOT_SUPPORTED);
        }
        this.smartStartAndroidApp(inspectorController, selectDeviceInfo, appFile);
    }

    public void smartStartAndroidApp(MobileInspectorController inspectorController, MobileDeviceInfo selectDeviceInfo, String appFile) throws SmartStartAppException, ExecutionException, InterruptedException, IOException, AppiumStartException, MobileDriverInitializeException, IOSWebkitStartException {
        String deviceId = selectDeviceInfo.getDeviceId();
        AndroidSDKManager androidSDKManager = new AndroidSDKManager();
        String aaptFolder = androidSDKManager.getSDKLocator().getBuildToolsRootFolder().getAbsolutePath();
        String adbPath = null;
        try {
            adbPath = AndroidDeviceInfo.getADBPath();
        }
        catch (AndroidSetupException androidSetupException) {
            throw new SmartStartAppException(ComposerMobileObjectspyMessageConstants.SMART_START_ERROR_ADB_NOT_AVAILABLE);
        }
        String adbFolder = new File(adbPath).getParentFile().getAbsolutePath();
        String appId = MobileCommonHelper.getBundleId((String)appFile, (String)aaptFolder);
        boolean isInstalled = MobileCommonHelper.inAndroidAppInstalled((String)deviceId, (String)appId, (String)adbFolder);
        if (!isInstalled) {
            this.startLocalAppAsNormal(inspectorController, selectDeviceInfo, appFile);
            return;
        }
        boolean isSameApp = MobileCommonHelper.isSameApp((String)appFile, (String)deviceId, (String)appId, (String)adbFolder, (String)aaptFolder);
        if (!isSameApp) {
            MobileCommonHelper.uninstallAndroidApp((String)deviceId, (String)appId, (String)adbFolder);
            this.startLocalAppAsNormal(inspectorController, selectDeviceInfo, appFile);
        } else {
            inspectorController.startExistingApp(selectDeviceInfo, appId);
        }
    }

    public void startLocalAppAsNormal(MobileInspectorController inspectorController, MobileDeviceInfo selectDeviceInfo, String appFile) throws ExecutionException, InterruptedException, IOException, AppiumStartException, MobileDriverInitializeException, IOSWebkitStartException {
        inspectorController.startMobileApp(selectDeviceInfo, appFile, false);
    }

    @Override
    public void setInput() throws InvocationTargetException, InterruptedException {
        this.updateLocalDevices();
        this.cbbStartType.select(0);
        this.cbbStartType.notifyListeners(13, new Event());
        this.appFileLabel.notifyListeners(11, new Event());
    }

    @Override
    public void loadDevices() throws InvocationTargetException, InterruptedException {
        this.updateLocalDevices();
    }

    @Override
    public MobileActionMapping buildStartAppActionMapping() {
        int startType = this.cbbStartType.getSelectionIndex();
        switch (startType) {
            case 0: {
                MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartApplication, null);
                String appValue = this.getAppFile();
                startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
                return startAppAction;
            }
            case 1: {
                MobileActionMapping startAppAction = new MobileActionMapping(MobileAction.StartExistingApplication, null);
                String appValue = this.txtAppId.getText();
                startAppAction.getData()[0].setValue(new ConstantExpressionWrapper((Object)appValue));
                return startAppAction;
            }
        }
        return null;
    }
}

