/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.composites;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileLocatorFinder;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.dal.fileservice.dataprovider.EntityNameFileServiceDataProvider;
import com.kms.katalon.entity.repository.MobileElementEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MobileElementPropertiesComposite
extends Composite {
    private Text txtObjectName;
    private CapturedMobileElement editingElement;
    private TableViewer attributesTableViewer;
    private MobileElementInspectorDialog parentDialog;
    private Combo cbbLocatorStrategy;
    private StyledText txtLocator;
    private Button btnGenerate;
    private static String[] strategies = MobileElementEntity.LocatorStrategy.getStrategies();

    public MobileElementPropertiesComposite(MobileElementInspectorDialog parentDialog, Composite parent, int style) {
        super(parent, style);
        this.parentDialog = parentDialog;
        this.createComposite();
    }

    public MobileElementPropertiesComposite(MobileElementInspectorDialog dialog, Composite parent) {
        this(dialog, parent, 0);
    }

    public void setEditingElement(CapturedMobileElement editingElement) {
        this.editingElement = editingElement;
        this.refreshAttributesTable();
        this.refreshButtonStates();
    }

    public CapturedMobileElement getEditingElement() {
        return this.editingElement;
    }

    private void createComposite() {
        GridLayout glObjectPropertiesComposite = new GridLayout(2, false);
        glObjectPropertiesComposite.horizontalSpacing = 10;
        this.setLayout((Layout)glObjectPropertiesComposite);
        Label lblObjectProperties = new Label((Composite)this, 0);
        lblObjectProperties.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        ControlUtils.setFontToBeBold((Control)lblObjectProperties);
        lblObjectProperties.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_OBJECT_PROPERTIES);
        Label objectNameLabel = new Label((Composite)this, 0);
        GridData gdObjectNameLabel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdObjectNameLabel.widthHint = 90;
        objectNameLabel.setLayoutData((Object)gdObjectNameLabel);
        objectNameLabel.setText(ComposerMobileObjectspyMessageConstants.DIA_LBL_OBJECT_NAME);
        this.txtObjectName = new Text((Composite)this, 2048);
        this.txtObjectName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtObjectName.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_OBJECT_NAME);
        Composite locatorComposite = new Composite((Composite)this, 0);
        GridLayout glLocatorComposite = new GridLayout(2, false);
        glLocatorComposite.marginWidth = 0;
        glLocatorComposite.marginHeight = 0;
        locatorComposite.setLayout((Layout)glLocatorComposite);
        locatorComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label lblLocatorStrategy = new Label(locatorComposite, 0);
        lblLocatorStrategy.setText("Locator Strategy");
        GridData gdLocatorStrategy = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblLocatorStrategy.setLayoutData((Object)gdLocatorStrategy);
        Composite locatorStrategyComposite = new Composite(locatorComposite, 0);
        locatorStrategyComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout glLocatorStrategy = new GridLayout(2, false);
        glLocatorStrategy.marginWidth = 0;
        glLocatorStrategy.marginHeight = 0;
        locatorStrategyComposite.setLayout((Layout)glLocatorStrategy);
        this.cbbLocatorStrategy = new Combo(locatorStrategyComposite, 8);
        this.cbbLocatorStrategy.setItems(strategies);
        this.cbbLocatorStrategy.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.btnGenerate = new Button(locatorStrategyComposite, 8);
        this.btnGenerate.setText("Generate");
        Label lblLocator = new Label(locatorComposite, 0);
        GridData gdLocator = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblLocator.setLayoutData((Object)gdLocator);
        lblLocator.setText("Locator");
        this.txtLocator = new StyledText(locatorComposite, 2624);
        GridData gdTxtEditor = new GridData(4, 4, true, false);
        gdTxtEditor.heightHint = 50;
        this.txtLocator.setLayoutData((Object)gdTxtEditor);
        Composite attributesTableComposite = new Composite((Composite)this, 0);
        attributesTableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        attributesTableComposite.setLayout((Layout)tableColumnLayout);
        this.attributesTableViewer = new CTableViewer(attributesTableComposite, 68354);
        this.createColumns(this.attributesTableViewer, tableColumnLayout);
        Table attributesTable = this.attributesTableViewer.getTable();
        attributesTable.setHeaderVisible(true);
        attributesTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)attributesTable.getDisplay()));
        this.attributesTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.attributesTableViewer.setInput(Collections.emptyList());
        this.registerControlModifyListeners();
        this.refreshButtonStates();
    }

    private void commitEditingName() {
        if (this.editingElement == null || this.txtObjectName.isDisposed()) {
            return;
        }
        String objectName = this.txtObjectName.getText();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)objectName) && !StringUtils.equals((String)this.editingElement.getName(), (String)objectName)) {
            this.editingElement.setName(objectName);
            this.parentDialog.updateSelectedElement(this.editingElement);
        }
    }

    private void registerControlModifyListeners() {
        this.txtObjectName.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text source = (Text)e.widget;
                String oldS = source.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (MobileElementPropertiesComposite.this.editingElement != null) {
                    try {
                        new EntityNameFileServiceDataProvider().validateName(newS);
                    }
                    catch (Exception invalidName) {
                        MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)"Invalid name", (String)invalidName.getMessage());
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.txtObjectName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                MobileElementPropertiesComposite.this.commitEditingName();
            }
        });
        this.txtObjectName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (MobileElementPropertiesComposite.this.editingElement == null) {
                    return;
                }
                int keyCode = e.keyCode;
                switch (keyCode) {
                    case 13: 
                    case 0x1000050: {
                        MobileElementPropertiesComposite.this.commitEditingName();
                    }
                }
            }
        });
        this.cbbLocatorStrategy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileElementPropertiesComposite.this.editingElement == null) {
                    return;
                }
                int index = MobileElementPropertiesComposite.this.cbbLocatorStrategy.getSelectionIndex();
                MobileElementPropertiesComposite.this.editingElement.setLocatorStrategy(MobileElementEntity.LocatorStrategy.valueOfStrategy((String)strategies[index]));
            }
        });
        this.txtLocator.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (MobileElementPropertiesComposite.this.editingElement != null) {
                    MobileElementPropertiesComposite.this.editingElement.setLocator(MobileElementPropertiesComposite.this.txtLocator.getText());
                }
            }
        });
        this.attributesTableViewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection = (StructuredSelection)MobileElementPropertiesComposite.this.attributesTableViewer.getSelection();
                if (selection == null || selection.isEmpty()) {
                    return;
                }
                if (e.keyCode == 127) {
                    Map<String, String> allAttributes = MobileElementPropertiesComposite.this.editingElement.getAttributes();
                    Object[] objectArray = selection.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedEntry = objectArray[n2];
                        allAttributes.remove(((Map.Entry)selectedEntry).getKey());
                        ++n2;
                    }
                    MobileElementPropertiesComposite.this.refreshAttributesTable();
                }
            }
        });
        this.btnGenerate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String locator = new MobileLocatorFinder(MobileElementPropertiesComposite.this.editingElement).findLocator(MobileElementPropertiesComposite.this.parentDialog.getInspectorController().getDriver(), MobileElementPropertiesComposite.this.editingElement.getLocatorStrategy());
                MobileElementPropertiesComposite.this.txtLocator.setText(locator);
            }
        });
    }

    private void createColumns(TableViewer viewer, TableColumnLayout tableColumnLayout) {
        TableViewerColumn keyColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        keyColumn.getColumn().setText(GlobalStringConstants.NAME);
        keyColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryKey(element);
            }
        });
        TableViewerColumn valueColumn = new TableViewerColumn(this.attributesTableViewer, 0);
        valueColumn.getColumn().setText(GlobalStringConstants.VALUE);
        valueColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryValue(element);
            }
        });
        valueColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.attributesTableViewer){

            protected void setValue(Object element, Object value) {
                if (element instanceof Map.Entry && value instanceof String) {
                    Map.Entry entry = (Map.Entry)element;
                    entry.setValue(String.valueOf(value));
                    MobileElementPropertiesComposite.this.attributesTableViewer.refresh(element);
                }
            }

            protected Object getValue(Object element) {
                return MobileElementPropertiesComposite.this.getTextForEntryValue(element);
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof Map.Entry) {
                    return new TextCellEditor((Composite)MobileElementPropertiesComposite.this.attributesTableViewer.getTable());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof Map.Entry;
            }
        });
        tableColumnLayout.setColumnData((Widget)keyColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100, true));
        tableColumnLayout.setColumnData((Widget)valueColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 150, true));
    }

    private String getTextForEntryKey(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryKey = (String)entry.getKey();
        if (entryKey != null) {
            return entryKey.toString();
        }
        return "";
    }

    private String getTextForEntryValue(Object element) {
        if (!(element instanceof Map.Entry)) {
            return "";
        }
        Map.Entry entry = (Map.Entry)element;
        String entryValue = (String)entry.getValue();
        if (entryValue != null) {
            return entryValue.toString();
        }
        return "";
    }

    private void refreshAttributesTable() {
        if (this.attributesTableViewer == null || this.attributesTableViewer.getTable().isDisposed()) {
            return;
        }
        if (this.editingElement != null) {
            this.txtObjectName.setText(this.editingElement.getName());
            this.txtLocator.setText(StringUtils.defaultString((String)this.editingElement.getLocator()));
            int selectedIndex = Arrays.asList(strategies).indexOf(this.editingElement.getLocatorStrategy().getLocatorStrategy());
            if (selectedIndex >= 0) {
                this.cbbLocatorStrategy.select(selectedIndex);
            }
            this.attributesTableViewer.setInput(new ArrayList<Map.Entry<String, String>>(this.editingElement.getAttributes().entrySet()));
        } else {
            this.txtObjectName.setText("");
            this.txtLocator.setText("");
            this.cbbLocatorStrategy.select(-1);
            this.attributesTableViewer.setInput(Collections.emptyList());
        }
        this.attributesTableViewer.refresh();
        if (OSUtil.isMacBigSurOrLater()) {
            this.attributesTableViewer.getTable().redraw();
        }
    }

    private void refreshButtonStates() {
        boolean isActive = this.editingElement != null;
        this.txtObjectName.setEnabled(isActive);
        this.txtLocator.setEnabled(isActive);
        this.cbbLocatorStrategy.setEnabled(isActive);
        this.btnGenerate.setEnabled(isActive);
    }

    public void focusAndEditCapturedElementName() {
        this.txtObjectName.setFocus();
        this.txtObjectName.selectAll();
    }

    public void saveAndRefresh() {
        this.attributesTableViewer.applyEditorValue();
        this.attributesTableViewer.refresh();
    }
}

