/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.composites;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.util.MobileActionHelper;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.entity.repository.MobileElementEntity;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebElement;

public class MobileHighlightComposite {
    private MobileElementInspectorDialog parentDialog;
    private Label lblMessageVerifyObject;
    private CapturedMobileElement editingElement;
    private Button btnHighlight;
    private boolean isFinding;

    public MobileHighlightComposite(MobileElementInspectorDialog parentDialog) {
        this.parentDialog = parentDialog;
    }

    public Composite createComposite(Composite parent) {
        Composite elementToolsComposite = new Composite(parent, 0x4000000);
        elementToolsComposite.setLayout((Layout)new GridLayout(2, false));
        elementToolsComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.lblMessageVerifyObject = new Label(elementToolsComposite, 16448);
        this.lblMessageVerifyObject.setLayoutData((Object)new GridData(4, 128, true, true));
        this.btnHighlight = new Button(elementToolsComposite, 131072);
        this.btnHighlight.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.btnHighlight.setText(ComposerMobileObjectspyMessageConstants.DIA_BTN_HIGHLIGHT);
        this.btnHighlight.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TOOLTIP_HIGHLIGHT_BUTTON);
        this.btnHighlight.setEnabled(false);
        this.btnHighlight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileHighlightComposite.this.findAndHighlightEditingElement();
            }
        });
        return elementToolsComposite;
    }

    private void findAndHighlightEditingElement() {
        MobileElementEntity.LocatorStrategy locatorStrategy = this.editingElement.getLocatorStrategy();
        String locatorStrategyName = locatorStrategy.getLocatorStrategy();
        String locator = this.editingElement.getLocator();
        Thread thread = new Thread(() -> {
            block8: {
                this.isFinding = true;
                UISynchronizeService.syncExec(() -> {
                    this.clearMessage();
                    this.refreshButtonStates();
                });
                if (this.editingElement == null) {
                    return;
                }
                UISynchronizeService.syncExec(() -> this.displayWaitMessage(locator, locatorStrategyName));
                try {
                    long startTime = System.currentTimeMillis();
                    List<WebElement> webElements = this.findElements(this.editingElement);
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (webElements != null && webElements.size() > 0) {
                        List elementRects = webElements.stream().map(webElement -> {
                            Point location = webElement.getLocation();
                            Dimension size = webElement.getSize();
                            double ratio = this.parentDialog.getInspectorController().getDriver() instanceof IOSDriver ? 2 : 1;
                            return new Rectangle(MobileHighlightComposite.safeRoundDouble((double)location.x * ratio), MobileHighlightComposite.safeRoundDouble((double)location.y * ratio), MobileHighlightComposite.safeRoundDouble((double)size.width * ratio), MobileHighlightComposite.safeRoundDouble((double)size.height * ratio));
                        }).collect(Collectors.toList());
                        UISynchronizeService.syncExec(() -> this.parentDialog.highlightElementRects(elementRects));
                    }
                    UISynchronizeService.syncExec(() -> {
                        if (webElements != null && webElements.size() > 0) {
                            this.displayFoundMessage(webElements.size(), locatorStrategyName, locator, elapsedTime);
                        } else {
                            this.displayNotFoundMessage(locatorStrategyName, locator);
                        }
                    });
                }
                catch (NoSuchElementException noSuchElementException) {
                    UISynchronizeService.syncExec(() -> this.displayNotFoundMessage(locatorStrategyName, locator));
                    UISynchronizeService.syncExec(() -> {
                        this.isFinding = false;
                        this.refreshButtonStates();
                    });
                    break block8;
                }
                catch (Exception exception) {
                    try {
                        UISynchronizeService.syncExec(() -> this.displayNotFoundMessage(locatorStrategyName, locator));
                    }
                    catch (Throwable throwable) {
                        UISynchronizeService.syncExec(() -> {
                            this.isFinding = false;
                            this.refreshButtonStates();
                        });
                        throw throwable;
                    }
                    UISynchronizeService.syncExec(() -> {
                        this.isFinding = false;
                        this.refreshButtonStates();
                    });
                    break block8;
                }
                UISynchronizeService.syncExec(() -> {
                    this.isFinding = false;
                    this.refreshButtonStates();
                });
            }
        });
        thread.start();
    }

    private List<WebElement> findElements(CapturedMobileElement targetElement) throws Exception {
        if (targetElement == null) {
            return null;
        }
        MobileTestObject mobileTestObject = new MobileTestObject(targetElement.getName());
        mobileTestObject.setMobileLocator(targetElement.getLocator());
        mobileTestObject.setMobileLocatorStrategy(MobileTestObject.MobileLocatorStrategy.valueOf((String)this.editingElement.getLocatorStrategy().name()));
        AppiumDriver<?> driver = this.parentDialog.getInspectorController().getDriver();
        MobileActionHelper mobileActionHelper = new MobileActionHelper(driver);
        driver.manage().timeouts().implicitlyWait(1L, TimeUnit.SECONDS);
        return mobileActionHelper.findElements(mobileTestObject);
    }

    private void displaySuccessfulMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextSuccessfulColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayWarningMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getWarningForegroudColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayErrorMessage(String message) {
        this.lblMessageVerifyObject.setForeground(ColorUtil.getTextErrorColor());
        this.lblMessageVerifyObject.setText(message);
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private void displayFoundMessage(int numElements, String strategy, String selector, long elapsedTime) {
        String pluralPostfix = numElements > 1 ? "s" : "";
        this.displaySuccessfulMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_FOUND, numElements, pluralPostfix, strategy, selector, elapsedTime));
    }

    private void displayWaitMessage(String strategy, String selector) {
        this.displayWarningMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_SEARCHING_FOR_ELEMENTS, strategy, selector));
    }

    private void displayNotFoundMessage(String strategy, String selector) {
        this.displayErrorMessage(MessageFormat.format(ComposerMobileObjectspyMessageConstants.DIA_MSG_ELEMENT_NOT_FOUND, strategy, selector));
    }

    private void clearMessage() {
        this.lblMessageVerifyObject.setText("");
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    public CapturedMobileElement getEditingElement() {
        return this.editingElement;
    }

    public void setEditingElement(CapturedMobileElement editingElement) {
        this.editingElement = editingElement;
        this.refreshButtonStates();
        this.clearMessage();
    }

    private void refreshButtonStates() {
        boolean isEnableHightlightButton = !this.isFinding && this.editingElement != null;
        this.btnHighlight.setEnabled(isEnableHightlightButton);
    }

    private static int safeRoundDouble(double d) {
        long rounded = Math.round(d);
        return (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, rounded));
    }
}

