/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.dialogs.ProgressMonitorDialogWithThread;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.mobile.objectspy.actions.MobileAction;
import com.kms.katalon.composer.mobile.objectspy.components.MobileAppComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileAllObjectsWithCheckboxComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileCapturedObjectsComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileConfigurationsComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileElementPropertiesComposite;
import com.kms.katalon.composer.mobile.objectspy.composites.MobileHighlightComposite;
import com.kms.katalon.composer.mobile.objectspy.constant.ComposerMobileObjectspyMessageConstants;
import com.kms.katalon.composer.mobile.objectspy.constant.ImageConstants;
import com.kms.katalon.composer.mobile.objectspy.dialog.AddElementToObjectRepositoryDialogV2;
import com.kms.katalon.composer.mobile.objectspy.dialog.AppiumMonitorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.ErrorStartMobileApplicationHaveTroubleshootDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileAppDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceView;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileElementInspectorDialog;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileInspectorController;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverter;
import com.kms.katalon.composer.mobile.objectspy.element.CapturedMobileElementConverterV2;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.composer.mobile.objectspy.preferences.MobileObjectSpyPreferencesHelper;
import com.kms.katalon.composer.mobile.objectspy.util.ElementSelectionHelper;
import com.kms.katalon.composer.mobile.objectspy.util.MobileElementHelper;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.MobileElementEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;

public class MobileObjectSpyDialog
extends Dialog
implements MobileElementInspectorDialog,
MobileAppDialog {
    public static final Point DIALOG_SIZE = new Point(1100, 800);
    private static final String DIALOG_TITLE = ComposerMobileObjectspyMessageConstants.DIA_DIALOG_TITLE_MOBILE_OBJ_SPY;
    private ToolItem btnStart;
    private ToolItem btnCapture;
    private ToolItem btnAdd;
    private ToolItem btnStop;
    private TreeMobileElement appRootElement;
    private boolean disposed;
    private MobileInspectorController inspectorController;
    private MobileDeviceView deviceView;
    private Composite container;
    private boolean canceledBeforeOpening;
    private MobileConfigurationsComposite configurationsComposite;
    private MobileElementPropertiesComposite propertiesComposite;
    private MobileCapturedObjectsComposite capturedObjectsComposite;
    private MobileHighlightComposite highlightElementComposite;
    private MobileAllObjectsWithCheckboxComposite allObjectsComposite;
    private MobileObjectSpyPreferencesHelper preferencesHelper;
    private MobileAppComposite mobileComposite;
    private static MobileObjectSpyDialog instance;

    public boolean isCanceledBeforeOpening() {
        return this.canceledBeforeOpening;
    }

    public MobileObjectSpyDialog(Shell parentShell, MobileAppComposite mobileComposite) throws Exception {
        super(parentShell);
        this.setShellStyle(1264);
        this.disposed = false;
        this.inspectorController = new MobileInspectorController();
        this.preferencesHelper = new MobileObjectSpyPreferencesHelper();
        this.mobileComposite = mobileComposite;
        instance = this;
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(this.container, 0);
        sashForm.setSashWidth(3);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createLeftPanel((Composite)sashForm);
        this.createRightPanel((Composite)sashForm);
        this.deviceView = new MobileDeviceView(this);
        this.deviceView.createControls((Composite)sashForm);
        sashForm.setWeights(new int[]{4, 4, 4});
        new HelpCompositeForDialog(this.container, DocumentationMessageConstants.DIALOG_OBJECT_SPY_MOBILE);
        return this.container;
    }

    private void createLeftPanel(Composite parent) {
        ScrolledComposite leftPanelScrolledComposite = new ScrolledComposite(parent, 768);
        leftPanelScrolledComposite.setExpandHorizontal(true);
        leftPanelScrolledComposite.setExpandVertical(true);
        leftPanelScrolledComposite.setMinSize(180, 400);
        Composite leftPanelComposite = new Composite((Composite)leftPanelScrolledComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        leftPanelComposite.setLayout((Layout)layout);
        this.addElementTreeToolbar(leftPanelComposite);
        SashForm hSashForm = new SashForm(leftPanelComposite, 512);
        hSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.createCapturedObjectsComposite((Composite)hSashForm);
        this.createElementPropertiesComposite((Composite)hSashForm);
        this.createHighlightElementComposite((Composite)hSashForm);
        hSashForm.setWeights(new int[]{5, 6, 1});
        leftPanelScrolledComposite.setContent((Control)leftPanelComposite);
    }

    private void createRightPanel(Composite parent) {
        ScrolledComposite rightPanelScrolledComposite = new ScrolledComposite(parent, 768);
        rightPanelScrolledComposite.setExpandHorizontal(true);
        rightPanelScrolledComposite.setExpandVertical(true);
        rightPanelScrolledComposite.setMinSize(280, 400);
        Composite rightPanelComposite = new Composite((Composite)rightPanelScrolledComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rightPanelComposite.setLayout((Layout)layout);
        this.addStartStopToolbar(rightPanelComposite);
        this.createSettingComposite(rightPanelComposite);
        this.createAllObjectsComposite(rightPanelComposite);
        rightPanelScrolledComposite.setContent((Control)rightPanelComposite);
    }

    private void createCapturedObjectsComposite(Composite parent) {
        this.capturedObjectsComposite = new MobileCapturedObjectsComposite(this, parent);
    }

    private void createElementPropertiesComposite(Composite parent) {
        this.propertiesComposite = new MobileElementPropertiesComposite(this, parent);
    }

    @Override
    public void handleCapturedObjectsTableSelectionChange() {
        this.btnAdd.setEnabled(this.capturedObjectsComposite.hasAnyElement());
    }

    private void createHighlightElementComposite(Composite parent) {
        this.highlightElementComposite = new MobileHighlightComposite(this);
        this.highlightElementComposite.createComposite(parent);
    }

    @Override
    public void verifyCapturedElementsStates(CapturedMobileElement[] elements) {
        this.clearAllObjectState(elements);
        if (this.appRootElement != null) {
            CapturedMobileElement[] capturedMobileElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                CapturedMobileElement needToVerify = capturedMobileElementArray[n2];
                TreeMobileElement foundElement = this.appRootElement.findBestMatch(needToVerify);
                if (foundElement != null) {
                    needToVerify.setLink(foundElement);
                    foundElement.setCapturedElement(needToVerify);
                    this.allObjectsComposite.getAllElementTreeViewer().setChecked((Object)foundElement, true);
                }
                ++n2;
            }
        }
        this.allObjectsComposite.refreshTree();
        this.capturedObjectsComposite.refresh();
    }

    @Override
    public void removeCapturedElement(CapturedMobileElement element) {
        this.capturedObjectsComposite.removeElement(element);
        if (element == this.propertiesComposite.getEditingElement()) {
            this.propertiesComposite.setEditingElement(null);
            this.highlightElementComposite.setEditingElement(null);
        }
    }

    @Override
    public void removeSelectedCapturedElements(CapturedMobileElement[] elements) {
        this.clearAllObjectState(elements);
        this.allObjectsComposite.refreshTree();
        this.capturedObjectsComposite.removeElements(Arrays.asList(elements));
        this.propertiesComposite.setEditingElement(null);
        this.highlightElementComposite.setEditingElement(null);
    }

    private void clearAllObjectState(CapturedMobileElement[] elements) {
        CapturedMobileElement[] capturedMobileElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            CapturedMobileElement captured = capturedMobileElementArray[n2];
            TreeMobileElement treeElementLink = captured.getLink();
            if (treeElementLink != null) {
                treeElementLink.setCapturedElement(null);
                captured.setLink(null);
                CheckboxTreeViewer allElementTreeViewer = this.allObjectsComposite.getAllElementTreeViewer();
                Tree elementTree = allElementTreeViewer.getTree();
                if (elementTree != null && !elementTree.isDisposed() && allElementTreeViewer.getChecked((Object)treeElementLink)) {
                    allElementTreeViewer.setChecked((Object)treeElementLink, false);
                }
            }
            ++n2;
        }
    }

    private void createAllObjectsComposite(Composite parent) {
        this.allObjectsComposite = new MobileAllObjectsWithCheckboxComposite(this, parent);
    }

    private void createSettingComposite(Composite parent) {
        this.configurationsComposite = new MobileConfigurationsComposite(this, parent, this.mobileComposite);
    }

    @Override
    public void refreshButtonsState() {
        this.btnStart.setEnabled(this.mobileComposite.isAbleToStart());
    }

    public void create() {
        super.create();
        this.initializeData();
        this.refreshButtonsState();
    }

    private void initializeData() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.setInput();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.refreshButtonsState();
                }
                catch (InterruptedException interruptedException) {
                    this.refreshButtonsState();
                }
            }
            finally {
                this.refreshButtonsState();
            }
        });
    }

    @Override
    public void updateDeviceNames() {
        UISynchronizeService.asyncExec(() -> {
            try {
                try {
                    this.mobileComposite.loadDevices();
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    LoggerSingleton.logError((Throwable)targetException);
                    MultiStatusErrorDialog.showErrorDialog((Throwable)targetException, (String)"Error", (String)targetException.getClass().getSimpleName());
                    this.refreshButtonsState();
                }
                catch (InterruptedException interruptedException) {
                    this.refreshButtonsState();
                }
            }
            finally {
                this.refreshButtonsState();
            }
        });
    }

    public int open() {
        try {
            this.canceledBeforeOpening = false;
            String appiumVersion = AppiumVersionUtil.readVersionFromFile((String)MobileExecutionUtil.findAppiumDir());
            Trackings.trackOpenMobileSpy((String)this.getDeviceTypeString(), (String)appiumVersion);
            int n = super.open();
            return n;
        }
        finally {
            if (this.canceledBeforeOpening) {
                this.close();
            }
        }
    }

    private void addElementTreeToolbar(Composite explorerComposite) {
        ToolBar elementTreeToolbar = new ToolBar(explorerComposite, 0x820000);
        elementTreeToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        GridData layoutData = new GridData(4, 0x1000000, true, false, 1, 1);
        layoutData.horizontalIndent = 2;
        layoutData.minimumWidth = 180;
        elementTreeToolbar.setLayoutData((Object)layoutData);
        this.btnAdd = new ToolItem(elementTreeToolbar, 0);
        this.btnAdd.setImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY);
        this.btnAdd.setDisabledImage(ImageConstants.IMG_24_ADD_TO_OBJECT_REPOSITORY_DISABLED);
        this.btnAdd.setText(ComposerMobileObjectspyMessageConstants.DIA_TIP_ADD);
        this.btnAdd.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TIP_ADD);
        this.btnAdd.setEnabled(false);
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    MobileObjectSpyDialog.this.propertiesComposite.saveAndRefresh();
                    AddElementToObjectRepositoryDialogV2 dialog = new AddElementToObjectRepositoryDialogV2(MobileObjectSpyDialog.this.getParentShell(), MobileObjectSpyDialog.this.capturedObjectsComposite.getCapturedElements(), true);
                    if (dialog.open() != 0) {
                        return;
                    }
                    FolderTreeEntity folderTreeEntity = dialog.getDialogResult().getSelectedParentFolder();
                    FolderEntity folder = folderTreeEntity.getObject();
                    List<CapturedMobileElement> capturedElements = dialog.getDialogResult().getAllSelectedElement();
                    List<ITreeEntity> newTreeEntities = this.addElementsToRepository(folderTreeEntity, folder, capturedElements, dialog.getDialogResult());
                    Trackings.trackSaveMobileSpy((String)MobileObjectSpyDialog.this.getDeviceTypeString(), (int)newTreeEntities.size());
                    this.updateExplorerState(folderTreeEntity, newTreeEntities);
                }
                catch (Exception ex) {
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)MobileObjectSpyDialog.this.getParentShell(), (String)GlobalStringConstants.ERROR, (String)ex.getMessage());
                }
            }

            private void updateExplorerState(FolderTreeEntity folderTreeEntity, List<ITreeEntity> newTreeEntities) {
                IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
                eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity);
                eventBroker.send("EXPLORER/SET_SELECTED_ITEMS", (Object)newTreeEntities.toArray());
            }

            private List<ITreeEntity> addElementsToRepository(FolderTreeEntity folderTreeEntity, FolderEntity folder, List<CapturedMobileElement> capturedElements, AddElementToObjectRepositoryDialogV2.AddToObjectRepositoryDialogResult dialogResult) throws Exception {
                CapturedMobileElementConverterV2 converter = new CapturedMobileElementConverterV2();
                MobileElementHelper helper = new MobileElementHelper();
                ArrayList<ITreeEntity> newTreeEntities = new ArrayList<ITreeEntity>();
                ObjectRepositoryController objectRepositoryController = ObjectRepositoryController.getInstance();
                MobileDriverType currentMobileType = MobileObjectSpyDialog.this.getCurrentMobileDriverType();
                for (CapturedMobileElement mobileElement : capturedElements) {
                    if (mobileElement.isConflicted()) {
                        helper.addConflictedMobileElement(mobileElement, dialogResult, newTreeEntities);
                        continue;
                    }
                    MobileElementEntity testObject = converter.convert(mobileElement, folder, currentMobileType);
                    objectRepositoryController.updateTestObject((WebElementEntity)testObject);
                    newTreeEntities.add((ITreeEntity)new WebElementTreeEntity((WebElementEntity)testObject, (ITreeEntity)folderTreeEntity));
                }
                return newTreeEntities;
            }
        });
    }

    private MobileDriverType getCurrentMobileDriverType() {
        return this.mobileComposite.getSelectedDriverType();
    }

    private void addStartStopToolbar(Composite contentComposite) {
        Composite toolbarComposite = new Composite(contentComposite, 0);
        toolbarComposite.setLayout((Layout)new GridLayout(2, false));
        toolbarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar contentToolbar = new ToolBar(toolbarComposite, 0x820000);
        contentToolbar.setForeground(ColorUtil.getToolBarForegroundColor());
        contentToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.btnCapture = new ToolItem(contentToolbar, 0);
        this.btnCapture.setImage(ImageConstants.IMG_24_CAPTURE);
        this.btnCapture.setDisabledImage(ImageConstants.IMG_24_CAPTURE_DISABLED);
        this.btnCapture.setText(ComposerMobileObjectspyMessageConstants.DIA_TIP_CAPTURE_OBJ);
        this.btnCapture.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TIP_CAPTURE_OBJ);
        this.btnCapture.setEnabled(false);
        this.btnCapture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.captureObjectAction();
            }
        });
        this.btnStart = new ToolItem(contentToolbar, 0);
        this.btnStart.setImage(ImageConstants.IMG_24_START_DEVICE);
        this.btnStart.setDisabledImage(ImageConstants.IMG_24_START_DEVICE_DISABLED);
        this.btnStart.setText(ComposerMobileObjectspyMessageConstants.DIA_TIP_START_APP);
        this.btnStart.setToolTipText(ComposerMobileObjectspyMessageConstants.DIA_TIP_START_APP);
        this.btnStart.setEnabled(false);
        this.btnStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MobileObjectSpyDialog.this.validateAppSetting()) {
                    MobileObjectSpyDialog.this.startObjectInspectorAction();
                }
            }
        });
        this.btnStop = new ToolItem(contentToolbar, 0);
        this.btnStop.setImage(ImageConstants.IMG_24_STOP_DEVICE);
        this.btnStop.setDisabledImage(ImageConstants.IMG_24_STOP_DEVICE_DISABLED);
        this.btnStop.setText(GlobalStringConstants.STOP);
        this.btnStop.setToolTipText(GlobalStringConstants.STOP);
        this.btnStop.setEnabled(false);
        this.btnStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MobileObjectSpyDialog.this.stopObjectInspectorAction();
            }
        });
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.dispose();
    }

    public void dispose() {
        this.disposed = true;
    }

    protected Point getInitialSize() {
        return DIALOG_SIZE;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(DIALOG_TITLE);
        shell.setMinimumSize(500, 500);
    }

    @Override
    public void highlightElement(MobileElement selectedElement) {
        if (selectedElement == null || this.deviceView == null || this.deviceView.isDisposed()) {
            return;
        }
        this.deviceView.highlightElement(selectedElement);
    }

    @Override
    public void highlightElementRects(List<Rectangle> rects) {
        this.deviceView.highlightRects(rects);
    }

    private int calculateObjectSpyDialogStartX(Rectangle displayBounds, Point dialogSize) {
        int dialogsWidth = dialogSize.x + 400;
        int startX = (displayBounds.width - dialogsWidth) / 2 + displayBounds.x;
        return Math.max(startX, 0);
    }

    private int calculateObjectSpyDialogStartY(Rectangle displayBounds, Point dialogSize) {
        int startY = displayBounds.height - dialogSize.y;
        return Math.max(startY, 0) / 2;
    }

    @Override
    public void setSelectedElementByLocation(int x, int y) {
        if (this.appRootElement == null) {
            return;
        }
        final TreeMobileElement foundElement = new ElementSelectionHelper().findTopMostElementByLocation(this.appRootElement, x, y);
        if (foundElement == null) {
            return;
        }
        this.highlightElement(foundElement);
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MobileObjectSpyDialog.this.getShell().setFocus();
                MobileObjectSpyDialog.this.allObjectsComposite.focusToElementsTree();
                MobileObjectSpyDialog.this.allObjectsComposite.setSelection(foundElement);
            }
        });
    }

    private void captureObjectAction() {
        final ProgressMonitorDialogWithThread dialog = new ProgressMonitorDialogWithThread(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(ComposerMobileObjectspyMessageConstants.DIA_JOB_TASK_CAPTURING_OBJECTS, -1);
                dialog.runAndWait((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        (this).MobileObjectSpyDialog.this.appRootElement = (this).MobileObjectSpyDialog.this.inspectorController.getMobileObjectRoot();
                        return null;
                    }
                });
                MobileObjectSpyDialog.this.checkMonitorCanceled(monitor);
                this.refreshTreeElements(dialog);
                String imgPath = this.captureImage();
                MobileObjectSpyDialog.this.checkMonitorCanceled(monitor);
                this.refreshDeviceView(imgPath);
                monitor.done();
            }

            private void refreshTreeElements(final ProgressMonitorDialogWithThread dialog2) {
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        dialog2.setCancelable(false);
                        CheckboxTreeViewer allElementTreeViewer = (this).MobileObjectSpyDialog.this.allObjectsComposite.getAllElementTreeViewer();
                        if ((this).MobileObjectSpyDialog.this.appRootElement != null) {
                            allElementTreeViewer.setInput((Object)new Object[]{(this).MobileObjectSpyDialog.this.appRootElement});
                        } else {
                            allElementTreeViewer.setInput((Object)new Object[0]);
                        }
                        allElementTreeViewer.refresh();
                        allElementTreeViewer.expandAll();
                        MobileObjectSpyDialog.this.verifyCapturedElementsStates((this).MobileObjectSpyDialog.this.capturedObjectsComposite.getCapturedElements().toArray(new CapturedMobileElement[0]));
                        dialog2.setCancelable(true);
                    }
                });
            }

            private void refreshDeviceView(String imgPath) {
                File imgFile = new File(imgPath);
                if (imgFile.exists()) {
                    MobileObjectSpyDialog.this.deviceView.refreshDialog(imgFile, MobileObjectSpyDialog.this.appRootElement);
                }
            }

            private String captureImage() throws InvocationTargetException {
                try {
                    return MobileObjectSpyDialog.this.inspectorController.captureScreenshot();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.btnCapture.setEnabled(false);
                dialog.run(true, true, runnable);
            }
            catch (InterruptedException interruptedException) {
                this.btnCapture.setEnabled(true);
            }
            catch (InvocationTargetException e) {
                LoggerSingleton.logError((Throwable)e);
                Throwable exception = e.getTargetException();
                MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)ComposerMobileObjectspyMessageConstants.DIA_ERROR_UNABLE_TO_CAPTURE_OBJECTS, (String)exception.getClass().getSimpleName());
                this.btnCapture.setEnabled(true);
            }
        }
        finally {
            this.btnCapture.setEnabled(true);
        }
    }

    public String getAppName() {
        return this.mobileComposite.getAppName();
    }

    private void checkMonitorCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(ComposerMobileObjectspyMessageConstants.DIA_ERROR_MSG_OPERATION_CANCELED);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    private void startObjectInspectorAction() {
        this.btnStart.setEnabled(false);
        this.deviceView.setDisposed(false);
        AppiumMonitorDialog progressDlg = new AppiumMonitorDialog(this.getShell()){

            public void cancelPressed() {
                super.cancelPressed();
                this.finishedRun();
                this.getProgressMonitor().done();
                MobileObjectSpyDialog.this.btnStart.setEnabled(true);
                MobileObjectSpyDialog.this.btnStop.setEnabled(false);
                MobileObjectSpyDialog.this.btnCapture.setEnabled(false);
            }
        };
        try {
            this.inspectorController.setStreamHandler(progressDlg);
            if (!this.mobileComposite.startApp(this.inspectorController, progressDlg)) {
                this.btnStart.setEnabled(true);
                return;
            }
            this.captureObjectAction();
            this.btnCapture.setEnabled(true);
            this.btnStop.setEnabled(true);
            Trackings.trackMobileSpy((String)this.getDeviceTypeString(), (String)AppiumVersionUtil.getInstance().getAppiumVersionOrDefault());
        }
        catch (InterruptedException | InvocationTargetException ex) {
            if (ex instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)ex).getTargetException();
                String message = targetException instanceof ExecutionException ? targetException.getCause().getMessage() : targetException.getMessage();
                boolean runIOSDevice = this.mobileComposite.getSelectedDriverType() == MobileDriverType.IOS_DRIVER;
                UISynchronizeService.syncExec(() -> {
                    ErrorStartMobileApplicationHaveTroubleshootDialog dialog = new ErrorStartMobileApplicationHaveTroubleshootDialog("Unable to start application", message, ExceptionsUtil.getStackTraceForThrowable((Throwable)targetException), runIOSDevice);
                    dialog.open();
                });
                LoggerSingleton.logError((Throwable)targetException);
            }
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
        }
    }

    private void stopObjectInspectorAction() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                MobileObjectSpyDialog.this.inspectorController.closeApp();
            }
        });
        thread.start();
        if (!this.getShell().isDisposed()) {
            this.btnStart.setEnabled(true);
            this.btnStop.setEnabled(false);
            this.btnCapture.setEnabled(false);
            this.allObjectsComposite.clearAllElements();
        }
        if (this.deviceView != null) {
            this.deviceView.setDisposed(true);
        }
        this.dispose();
    }

    private boolean validateAppSetting() {
        return this.mobileComposite.validateSetting();
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x40 | 0x800 | 0x20);
        this.setBlockOnOpen(false);
    }

    protected Control createButtonBar(Composite parent) {
        return parent;
    }

    public boolean close() {
        this.stopObjectInspectorAction();
        try {
            this.preferencesHelper.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        Trackings.trackCloseMobileSpy((String)this.getDeviceTypeString());
        boolean result = super.close();
        instance = null;
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Rectangle displayBounds = this.getShell().getMonitor().getBounds();
        return new Point(this.calculateObjectSpyDialogStartX(displayBounds, initialSize), this.calculateObjectSpyDialogStartY(displayBounds, initialSize));
    }

    public void addElements(List<WebElementEntity> webElements) {
        if (webElements == null) {
            return;
        }
        CapturedMobileElementConverter converter = new CapturedMobileElementConverter();
        ArrayList<CapturedMobileElement> newMobileElements = new ArrayList<CapturedMobileElement>();
        for (WebElementEntity webElement : webElements) {
            newMobileElements.add(converter.revert(webElement));
        }
        this.capturedObjectsComposite.addElements(newMobileElements);
        this.verifyCapturedElementsStates(this.capturedObjectsComposite.getSelectedElements());
    }

    @Override
    public MobileObjectSpyPreferencesHelper getPreferencesHelper() {
        return this.preferencesHelper;
    }

    public static MobileObjectSpyDialog getInstance() {
        return instance;
    }

    public static void setInstance(MobileObjectSpyDialog instance) {
        MobileObjectSpyDialog.instance = instance;
    }

    @Override
    public void setSelectedElement(MobileElement element) {
        this.highlightElement(element);
        this.allObjectsComposite.focusToElementsTree();
        MobileElement mobileElement = element;
        if (mobileElement instanceof TreeMobileElement && (var2_3 = (TreeMobileElement)mobileElement) == (TreeMobileElement)var3_2) {
            this.allObjectsComposite.setSelection((TreeMobileElement)treeElement);
        } else {
            if (element instanceof CapturedMobileElement var4_5) {
                this.allObjectsComposite.setSelection(capElement.getLink());
            }
        }
    }

    @Override
    public void updateSelectedElement(CapturedMobileElement selectedElement) {
        this.capturedObjectsComposite.refresh(selectedElement, true);
        TreeMobileElement element = selectedElement.getLink();
        if (element != null) {
            this.allObjectsComposite.refreshTree(element);
            this.allObjectsComposite.setSelection(element);
        }
    }

    @Override
    public void setEdittingElement(CapturedMobileElement element) {
        this.highlightElementComposite.setEditingElement(element);
        this.propertiesComposite.setEditingElement(element);
    }

    @Override
    public void addCapturedElement(CapturedMobileElement element) {
        this.capturedObjectsComposite.addElement(element);
        this.propertiesComposite.focusAndEditCapturedElementName();
    }

    @Override
    public boolean isAddedCapturedElement(CapturedMobileElement element) {
        return this.capturedObjectsComposite.containsElement(element);
    }

    @Override
    public void focusAndEditCapturedElementName() {
        this.propertiesComposite.focusAndEditCapturedElementName();
    }

    @Override
    public CapturedMobileElement captureMobileElement(final TreeMobileElement selectedElement) {
        final ArrayList mobileElements = new ArrayList();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            monitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("Capturing Mobile element...", 1);
                        mobileElements.add(selectedElement.newCapturedElement(MobileObjectSpyDialog.this.inspectorController.getDriver(), MobileObjectSpyDialog.this.capturedObjectsComposite.getHashCapturedElements()));
                        monitor.worked(1);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Error", (String)"Unable to capture object");
        }
        if (mobileElements.size() > 0) {
            return (CapturedMobileElement)mobileElements.get(0);
        }
        return null;
    }

    private String getDeviceTypeString() {
        MobileDriverType deviceType = this.mobileComposite.getSelectedDriverType();
        return deviceType != null ? deviceType.toString() : null;
    }

    @Override
    public MobileInspectorController getInspectorController() {
        return this.inspectorController;
    }

    @Override
    public CapturedMobileElement captureMobileElement(int x, int y) {
        return null;
    }

    @Override
    public void onActionChosen(MobileAction action, TreeMobileElement selectedElement) {
    }
}

